/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.naming;

import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.checks.naming.AbstractNameCheck;
import com.puppycrawl.tools.checkstyle.checks.naming.AccessModifier;
import com.puppycrawl.tools.checkstyle.utils.CheckUtils;
import com.puppycrawl.tools.checkstyle.utils.ScopeUtils;
import java.util.Arrays;
import java.util.Optional;

public class ParameterNameCheck
extends AbstractNameCheck {
    private boolean ignoreOverridden;
    private AccessModifier[] accessModifiers = new AccessModifier[]{AccessModifier.PUBLIC, AccessModifier.PROTECTED, AccessModifier.PACKAGE, AccessModifier.PRIVATE};

    public ParameterNameCheck() {
        super("^[a-z][a-zA-Z0-9]*$");
    }

    public void setIgnoreOverridden(boolean ignoreOverridden) {
        this.ignoreOverridden = ignoreOverridden;
    }

    public void setAccessModifiers(AccessModifier ... accessModifiers) {
        this.accessModifiers = Arrays.copyOf(accessModifiers, accessModifiers.length);
    }

    @Override
    public int[] getDefaultTokens() {
        return this.getAcceptableTokens();
    }

    @Override
    public int[] getAcceptableTokens() {
        return new int[]{21};
    }

    @Override
    public int[] getRequiredTokens() {
        return this.getAcceptableTokens();
    }

    @Override
    protected boolean mustCheckName(DetailAST ast) {
        boolean checkName = true;
        if (this.ignoreOverridden && ParameterNameCheck.isOverriddenMethod(ast) || ast.getParent().getType() == 96 || CheckUtils.isReceiverParameter(ast) || !this.matchAccessModifiers(ParameterNameCheck.getAccessModifier(ast))) {
            checkName = false;
        }
        return checkName;
    }

    private static AccessModifier getAccessModifier(DetailAST ast) {
        DetailAST params = ast.getParent();
        DetailAST meth = params.getParent();
        AccessModifier accessModifier = AccessModifier.PRIVATE;
        if (meth.getType() == 9 || meth.getType() == 8) {
            if (ScopeUtils.isInInterfaceOrAnnotationBlock(ast)) {
                accessModifier = AccessModifier.PUBLIC;
            } else {
                DetailAST modsToken = meth.findFirstToken(5);
                accessModifier = CheckUtils.getAccessModifierFromModifiersToken(modsToken);
            }
        }
        return accessModifier;
    }

    private boolean matchAccessModifiers(AccessModifier accessModifier) {
        return Arrays.stream(this.accessModifiers).anyMatch(el -> el == accessModifier);
    }

    private static boolean isOverriddenMethod(DetailAST ast) {
        Optional<DetailAST> overrideToken;
        boolean overridden = false;
        DetailAST parent = ast.getParent().getParent();
        Optional<DetailAST> annotation = Optional.ofNullable(parent.getFirstChild().getFirstChild());
        if (annotation.isPresent() && annotation.get().getType() == 159 && (overrideToken = Optional.ofNullable(annotation.get().findFirstToken(58))).isPresent() && "Override".equals(overrideToken.get().getText())) {
            overridden = true;
        }
        return overridden;
    }
}

