/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checks;

import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.source.formatter.BNDSettings;
import com.liferay.source.formatter.checks.BaseFileCheck;
import com.liferay.source.formatter.checks.util.BNDSourceUtil;
import com.liferay.source.formatter.checks.util.JavaSourceUtil;

public class JavaPackagePathCheck
extends BaseFileCheck {
    @Override
    protected String doProcess(String fileName, String absolutePath, String content) throws Exception {
        String packageName = JavaSourceUtil.getPackageName(content);
        if (Validator.isNull(packageName)) {
            this.addMessage(fileName, "Missing package");
            return content;
        }
        this._checkPackageName(fileName, packageName);
        if (!absolutePath.contains("/modules/private/apps/") && this.isModulesFile(absolutePath)) {
            this._checkModulePackageName(fileName, packageName);
        }
        return content;
    }

    private void _checkModulePackageName(String fileName, String packageName) throws Exception {
        if (!packageName.startsWith("com.liferay")) {
            return;
        }
        BNDSettings bndSettings = this.getBNDSettings(fileName);
        if (bndSettings == null) {
            return;
        }
        String bundleSymbolicName = BNDSourceUtil.getDefinitionValue(bndSettings.getContent(), "Bundle-SymbolicName");
        if (!bundleSymbolicName.startsWith("com.liferay")) {
            return;
        }
        if (packageName.contains(bundleSymbolicName = bundleSymbolicName.replaceAll("\\.(api|service|test)$", ""))) {
            return;
        }
        if (!packageName.contains(bundleSymbolicName = bundleSymbolicName.replaceAll("\\.impl$", ".internal"))) {
            this.addMessage(fileName, "Package should follow Bundle-SymbolicName specified in " + bndSettings.getFileName(), "package.markdown");
        }
    }

    private void _checkPackageName(String fileName, String packageName) {
        int pos = fileName.lastIndexOf(47);
        String filePath = StringUtil.replace(fileName.substring(0, pos), '/', '.');
        if (!filePath.endsWith(packageName)) {
            this.addMessage(fileName, "The declared package '" + packageName + "' does not match the expected package", "package.markdown");
            return;
        }
        if (packageName.matches(".*\\.internal\\.([\\w.]+\\.)?impl")) {
            this.addMessage(fileName, "Do not use 'impl' inside 'internal', see LPS-70113");
        }
    }
}

