/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checks;

import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.tools.JavaImportsFormatter;
import com.liferay.source.formatter.checks.BaseFileCheck;
import com.liferay.source.formatter.checks.util.JavaSourceUtil;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JavaImportsCheck
extends BaseFileCheck {
    private final Pattern _importMethodPattern = Pattern.compile("\nimport static ((.*\\.(Assert|(Power)?Mockito))\\.[a-z]\\w*);");

    @Override
    protected String doProcess(String fileName, String absolutePath, String content) throws Exception {
        JavaImportsFormatter importsFormatter = new JavaImportsFormatter();
        String className = JavaSourceUtil.getClassName(fileName);
        String packageName = JavaSourceUtil.getPackageName(content);
        content = importsFormatter.format(content, packageName, className);
        content = StringUtil.replace(content, ";\n/**", ";\n\n/**");
        Matcher matcher = this._importMethodPattern.matcher(content);
        while (matcher.find()) {
            StringBundler sb = new StringBundler();
            sb.append("Do not import method '");
            sb.append(matcher.group(1));
            sb.append("', import class '");
            sb.append(matcher.group(2));
            sb.append("' instead");
            this.addMessage(fileName, sb.toString(), this.getLineCount(content, matcher.end()));
        }
        return content;
    }
}

