/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checks;

import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.source.formatter.BNDSettings;
import com.liferay.source.formatter.checks.BaseSourceCheck;
import com.liferay.source.formatter.checks.FileCheck;
import com.liferay.source.formatter.checks.comparator.ElementComparator;
import com.liferay.source.formatter.util.FileUtil;
import java.io.File;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.Text;

public abstract class BaseFileCheck
extends BaseSourceCheck
implements FileCheck {
    protected static final String RUN_OUTSIDE_PORTAL_EXCLUDES = "run.outside.portal.excludes";
    private final Map<String, BNDSettings> _bndSettingsMap = new ConcurrentHashMap<String, BNDSettings>();

    @Override
    public String process(String fileName, String absolutePath, String content) throws Exception {
        this.clearSourceFormatterMessages(fileName);
        return this.doProcess(fileName, absolutePath, content);
    }

    protected void checkElementOrder(String fileName, Element rootElement, String elementName, String parentElementName, ElementComparator elementComparator) {
        if (rootElement == null) {
            return;
        }
        Node previousNode = null;
        Iterator iterator = rootElement.nodeIterator();
        while (iterator.hasNext()) {
            Node curNode = (Node)iterator.next();
            if (curNode instanceof Text) continue;
            if (previousNode == null) {
                previousNode = curNode;
                continue;
            }
            if (curNode instanceof Element && previousNode instanceof Element) {
                Element curElement = (Element)curNode;
                Element previousElement = (Element)previousNode;
                String curElementName = curElement.getName();
                String previousElementName = previousElement.getName();
                if (curElementName.equals(elementName) && previousElementName.equals(elementName) && elementComparator.compare(previousElement, curElement) > 0) {
                    StringBundler sb = new StringBundler(7);
                    sb.append("Incorrect order '");
                    sb.append(elementName);
                    sb.append("':");
                    if (Validator.isNotNull(parentElementName)) {
                        sb.append(" ");
                        sb.append(parentElementName);
                    }
                    sb.append(" ");
                    sb.append(elementComparator.getElementName(curElement));
                    this.addMessage(fileName, sb.toString());
                }
            }
            previousNode = curNode;
        }
    }

    protected abstract String doProcess(String var1, String var2, String var3) throws Exception;

    protected BNDSettings getBNDSettings(String fileName) throws Exception {
        for (Map.Entry<String, BNDSettings> entry : this._bndSettingsMap.entrySet()) {
            String bndFileLocation = entry.getKey();
            if (!fileName.startsWith(bndFileLocation)) continue;
            return entry.getValue();
        }
        String bndFileLocation = fileName;
        int pos;
        while ((pos = bndFileLocation.lastIndexOf("/")) != -1) {
            File file = new File((bndFileLocation = bndFileLocation.substring(0, pos + 1)) + "bnd.bnd");
            if (file.exists()) {
                return new BNDSettings(bndFileLocation + "bnd.bnd", FileUtil.read(file));
            }
            bndFileLocation = StringUtil.replaceLast(bndFileLocation, '/', "");
        }
        return null;
    }

    protected String getLine(String content, int lineCount) {
        int nextLineStartPos = this.getLineStartPos(content, lineCount);
        if (nextLineStartPos == -1) {
            return null;
        }
        int nextLineEndPos = content.indexOf(10, nextLineStartPos);
        if (nextLineEndPos == -1) {
            return content.substring(nextLineStartPos);
        }
        return content.substring(nextLineStartPos, nextLineEndPos);
    }

    protected int getLineLength(String line) {
        int lineLength = 0;
        int tabLength = 4;
        for (char c : line.toCharArray()) {
            if (c == '\t') {
                for (int i = 0; i < tabLength; ++i) {
                    ++lineLength;
                }
                tabLength = 4;
                continue;
            }
            ++lineLength;
            if (--tabLength > 0) continue;
            tabLength = 4;
        }
        return lineLength;
    }

    protected int getLineStartPos(String content, int lineCount) {
        int x = 0;
        for (int i = 1; i < lineCount; ++i) {
            if ((x = content.indexOf(10, x + 1)) != -1) continue;
            return x;
        }
        return x + 1;
    }

    protected void putBNDSettings(BNDSettings bndSettings) {
        this._bndSettingsMap.put(bndSettings.getFileLocation(), bndSettings);
    }
}

