/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.servlet.taglib.ui;

import com.liferay.portal.kernel.util.LocaleUtil;
import java.util.Locale;
import java.util.Set;

public class LanguageEntry {
    private final boolean _disabled;
    private final Set<String> _duplicateLanguages;
    private final String _languageId;
    private final Locale _locale;
    private final boolean _selected;
    private final String _url;

    public LanguageEntry(Set<String> duplicateLanguages, Locale currentLocale, Locale locale, String url, boolean disabled) {
        this._duplicateLanguages = duplicateLanguages;
        this._locale = locale;
        this._url = url;
        this._disabled = disabled;
        this._languageId = LocaleUtil.toLanguageId(locale);
        this._selected = LocaleUtil.equals(locale, currentLocale);
    }

    public String getLanguageId() {
        return this._languageId;
    }

    public Locale getLocale() {
        return this._locale;
    }

    public String getLongDisplayName() {
        return LocaleUtil.getLongDisplayName(this._locale, this._duplicateLanguages);
    }

    public String getShortDisplayName() {
        return LocaleUtil.getShortDisplayName(this._locale, this._duplicateLanguages);
    }

    public String getURL() {
        return this._url;
    }

    public String getW3cLanguageId() {
        return LocaleUtil.toW3cLanguageId(this._languageId);
    }

    public boolean isDisabled() {
        return this._disabled;
    }

    public boolean isSelected() {
        return this._selected;
    }
}

