/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.servlet;

import com.liferay.portal.kernel.servlet.BufferCacheServletResponse;
import com.liferay.portal.kernel.servlet.MetaInfoCacheServletResponse;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ObjectValuePair;
import java.util.Enumeration;
import javax.servlet.DispatcherType;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;

public class RequestDispatcherUtil {
    public static ObjectValuePair<String, Long> getContentAndLastModifiedTime(RequestDispatcher requestDispatcher, HttpServletRequest request, HttpServletResponse response) throws Exception {
        BufferCacheServletResponse bufferCacheServletResponse = new BufferCacheServletResponse(response);
        requestDispatcher.include((ServletRequest)new HttpServletRequestWrapper(request){

            public long getDateHeader(String name) {
                if (name.equals("If-Modified-Since")) {
                    return -1L;
                }
                return super.getDateHeader(name);
            }

            public String getHeader(String name) {
                if (name.equals("If-Modified-Since") || name.equals("If-None-Match") || name.equals("Last-Modified")) {
                    return null;
                }
                return super.getHeader(name);
            }

            public Enumeration<String> getHeaders(String name) {
                if (name.equals("If-Modified-Since") || name.equals("If-None-Match") || name.equals("Last-Modified")) {
                    return null;
                }
                return super.getHeaders(name);
            }

            public String getMethod() {
                return "GET";
            }
        }, (ServletResponse)bufferCacheServletResponse);
        return new ObjectValuePair<String, Long>(bufferCacheServletResponse.getString(), GetterUtil.getLong(bufferCacheServletResponse.getHeader("Last-Modified"), -1L));
    }

    public static String getEffectivePath(HttpServletRequest request) {
        DispatcherType dispatcherType = request.getDispatcherType();
        if (dispatcherType.equals((Object)DispatcherType.FORWARD)) {
            return (String)request.getAttribute("javax.servlet.forward.servlet_path");
        }
        if (dispatcherType.equals((Object)DispatcherType.INCLUDE)) {
            return (String)request.getAttribute("javax.servlet.include.servlet_path");
        }
        return request.getServletPath();
    }

    public static long getLastModifiedTime(RequestDispatcher requestDispatcher, HttpServletRequest request, HttpServletResponse response) throws Exception {
        MetaInfoCacheServletResponse metaInfoCacheServletResponse = new MetaInfoCacheServletResponse(response);
        requestDispatcher.include((ServletRequest)new HttpServletRequestWrapper(request){

            public String getMethod() {
                return "HEAD";
            }
        }, (ServletResponse)metaInfoCacheServletResponse);
        return GetterUtil.getLong(metaInfoCacheServletResponse.getHeader("Last-Modified"), -1L);
    }
}

