/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.service;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.security.auth.CompanyThreadLocal;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.security.auth.PrincipalThreadLocal;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.PermissionThreadLocal;
import com.liferay.portal.kernel.service.BaseService;
import com.liferay.portal.kernel.service.UserLocalServiceUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;

public abstract class BaseServiceImpl
implements BaseService {
    public static final String[] ANONYMOUS_NAMES = new String[]{"anonymous-guest", "guest", "ANONYMOUS", "<anonymous>"};
    public static final String JRUN_ANONYMOUS = "anonymous-guest";
    public static final String ORACLE_ANONYMOUS = "guest";
    public static final String SUN_ANONYMOUS = "ANONYMOUS";
    public static final String WEBLOGIC_ANONYMOUS = "<anonymous>";

    public User getGuestOrUser() throws PortalException {
        try {
            return this.getUser();
        }
        catch (PrincipalException pe) {
            try {
                return UserLocalServiceUtil.getDefaultUser(CompanyThreadLocal.getCompanyId());
            }
            catch (Exception e) {
                throw pe;
            }
        }
    }

    public long getGuestOrUserId() throws PrincipalException {
        try {
            return this.getUserId();
        }
        catch (PrincipalException pe) {
            try {
                return UserLocalServiceUtil.getDefaultUserId(CompanyThreadLocal.getCompanyId());
            }
            catch (Exception e) {
                throw pe;
            }
        }
    }

    public PermissionChecker getPermissionChecker() throws PrincipalException {
        PermissionChecker permissionChecker = PermissionThreadLocal.getPermissionChecker();
        if (permissionChecker == null) {
            throw new PrincipalException("PermissionChecker not initialized");
        }
        return permissionChecker;
    }

    public User getUser() throws PortalException {
        return UserLocalServiceUtil.getUserById(this.getUserId());
    }

    public long getUserId() throws PrincipalException {
        String name = PrincipalThreadLocal.getName();
        if (Validator.isNull(name)) {
            throw new PrincipalException("Principal is null");
        }
        for (int i = 0; i < ANONYMOUS_NAMES.length; ++i) {
            if (!StringUtil.equalsIgnoreCase(name, ANONYMOUS_NAMES[i])) continue;
            throw new PrincipalException("Principal cannot be " + ANONYMOUS_NAMES[i]);
        }
        return GetterUtil.getLong(name);
    }

    protected ClassLoader getClassLoader() {
        Class<?> clazz = this.getClass();
        return clazz.getClassLoader();
    }
}

