/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.security.permission;

import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.util.AutoResetThreadLocal;
import com.liferay.portal.kernel.util.StringBundler;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Supplier;

public class PermissionThreadLocal {
    private static final ThreadLocal<Boolean> _addResource = new AutoResetThreadLocal<Supplier<Boolean>>(PermissionThreadLocal.class + "._addResource", () -> Boolean.TRUE);
    private static final ThreadLocal<Set<String>> _flushResourceBlockEnabled = new AutoResetThreadLocal<Supplier<Set>>(PermissionThreadLocal.class + "._flushResourceBlockEnabled", HashSet::new);
    private static final ThreadLocal<Set<String>> _flushResourcePermissionEnabled = new AutoResetThreadLocal<Supplier<Set>>(PermissionThreadLocal.class + "._flushResourcePermissionEnabled", HashSet::new);
    private static final ThreadLocal<PermissionChecker> _permissionChecker = new AutoResetThreadLocal<PermissionChecker>(PermissionThreadLocal.class + "._permissionChecker"){

        @Override
        protected PermissionChecker copy(PermissionChecker permissionChecker) {
            return permissionChecker;
        }
    };

    public static PermissionChecker getPermissionChecker() {
        return _permissionChecker.get();
    }

    public static boolean isAddResource() {
        return _addResource.get();
    }

    public static boolean isFlushResourceBlockEnabled(long companyId, long groupId, String name) {
        Set<String> set = _flushResourceBlockEnabled.get();
        StringBundler sb = new StringBundler(5);
        sb.append(companyId);
        sb.append("_");
        sb.append(groupId);
        sb.append("_");
        sb.append(name);
        return !set.contains(sb.toString());
    }

    public static boolean isFlushResourcePermissionEnabled(String resourceName, String primKey) {
        Set<String> set = _flushResourcePermissionEnabled.get();
        return !set.contains(resourceName + "_" + primKey);
    }

    public static void setAddResource(boolean addResource) {
        _addResource.set(addResource);
    }

    public static void setFlushResourceBlockEnabled(long companyId, long groupId, String name, boolean enabled) {
        Set<String> set = _flushResourceBlockEnabled.get();
        StringBundler sb = new StringBundler(5);
        sb.append(companyId);
        sb.append("_");
        sb.append(groupId);
        sb.append("_");
        sb.append(name);
        if (enabled) {
            set.remove(sb.toString());
        } else {
            set.add(sb.toString());
        }
    }

    public static void setFlushResourcePermissionEnabled(String resourceName, String primKey, boolean enabled) {
        Set<String> set = _flushResourcePermissionEnabled.get();
        if (enabled) {
            set.remove(resourceName + "_" + primKey);
        } else {
            set.add(resourceName + "_" + primKey);
        }
    }

    public static void setPermissionChecker(PermissionChecker permissionChecker) {
        _permissionChecker.set(permissionChecker);
    }
}

