/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.search;

import com.liferay.portal.kernel.concurrent.CallerRunsPolicy;
import com.liferay.portal.kernel.concurrent.ThreadPoolExecutor;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.messaging.Destination;
import com.liferay.portal.kernel.messaging.DestinationConfiguration;
import com.liferay.portal.kernel.messaging.DestinationFactory;
import com.liferay.portal.kernel.messaging.DestinationFactoryUtil;
import com.liferay.portal.kernel.messaging.InvokerMessageListener;
import com.liferay.portal.kernel.messaging.MessageBus;
import com.liferay.portal.kernel.messaging.MessageListener;
import com.liferay.portal.kernel.search.IndexSearcher;
import com.liferay.portal.kernel.search.IndexWriter;
import com.liferay.portal.kernel.search.SearchEngine;
import com.liferay.portal.kernel.search.SearchEngineConfigurator;
import com.liferay.portal.kernel.search.SearchEngineHelper;
import com.liferay.portal.kernel.search.SearchEngineProxyWrapper;
import com.liferay.portal.kernel.search.messaging.BaseSearchEngineMessageListener;
import com.liferay.portal.kernel.search.messaging.SearchReaderMessageListener;
import com.liferay.portal.kernel.search.messaging.SearchWriterMessageListener;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.PortalRunMode;
import com.liferay.portal.kernel.util.PropsUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.registry.Registry;
import com.liferay.registry.RegistryUtil;
import com.liferay.registry.dependency.ServiceDependencyListener;
import com.liferay.registry.dependency.ServiceDependencyManager;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class AbstractSearchEngineConfigurator
implements SearchEngineConfigurator {
    private static final int _INDEX_SEARCH_WRITER_MAX_QUEUE_SIZE = GetterUtil.getInteger(PropsUtil.get("index.search.writer.max.queue.size"));
    private static final Log _log = LogFactoryUtil.getLog(AbstractSearchEngineConfigurator.class);
    private volatile MessageBus _messageBus;
    private String _originalSearchEngineId;
    private final List<SearchEngineRegistration> _searchEngineRegistrations = new ArrayList<SearchEngineRegistration>();
    private Map<String, SearchEngine> _searchEngines;

    @Override
    public void afterPropertiesSet() {
        ServiceDependencyManager serviceDependencyManager = new ServiceDependencyManager();
        serviceDependencyManager.addServiceDependencyListener(new ServiceDependencyListener(){

            public void dependenciesFulfilled() {
                Registry registry = RegistryUtil.getRegistry();
                AbstractSearchEngineConfigurator.this._messageBus = (MessageBus)registry.getService(MessageBus.class);
                AbstractSearchEngineConfigurator.this.initialize();
            }

            public void destroy() {
            }
        });
        serviceDependencyManager.registerDependencies(new Class[]{DestinationFactory.class, MessageBus.class});
    }

    @Override
    public void destroy() {
        for (SearchEngineRegistration searchEngineRegistration : this._searchEngineRegistrations) {
            this.destroySearchEngine(searchEngineRegistration);
        }
        this._searchEngineRegistrations.clear();
        if (Validator.isNotNull(this._originalSearchEngineId)) {
            SearchEngineHelper searchEngineHelper = this.getSearchEngineHelper();
            searchEngineHelper.setDefaultSearchEngineId(this._originalSearchEngineId);
            this._originalSearchEngineId = null;
        }
    }

    @Override
    public void setSearchEngines(Map<String, SearchEngine> searchEngines) {
        this._searchEngines = searchEngines;
    }

    protected void createSearchEngineListeners(String searchEngineId, SearchEngine searchEngine, Destination searchReaderDestination, Destination searchWriterDestination) {
        this.registerSearchEngineMessageListener(searchEngineId, searchEngine, searchReaderDestination, new SearchReaderMessageListener(), searchEngine.getIndexSearcher());
        this.registerSearchEngineMessageListener(searchEngineId, searchEngine, searchWriterDestination, new SearchWriterMessageListener(), searchEngine.getIndexWriter());
    }

    protected Destination createSearchReaderDestination(String searchReaderDestinationName) {
        DestinationConfiguration destinationConfiguration = DestinationConfiguration.createSynchronousDestinationConfiguration(searchReaderDestinationName);
        return DestinationFactoryUtil.createDestination(destinationConfiguration);
    }

    protected Destination createSearchWriterDestination(String searchWriterDestinationName) {
        DestinationConfiguration destinationConfiguration = null;
        destinationConfiguration = PortalRunMode.isTestMode() ? DestinationConfiguration.createSynchronousDestinationConfiguration(searchWriterDestinationName) : DestinationConfiguration.createParallelDestinationConfiguration(searchWriterDestinationName);
        if (_INDEX_SEARCH_WRITER_MAX_QUEUE_SIZE > 0) {
            destinationConfiguration.setMaximumQueueSize(_INDEX_SEARCH_WRITER_MAX_QUEUE_SIZE);
            CallerRunsPolicy rejectedExecutionHandler = new CallerRunsPolicy(){

                @Override
                public void rejectedExecution(Runnable runnable, ThreadPoolExecutor threadPoolExecutor) {
                    if (_log.isWarnEnabled()) {
                        StringBundler sb = new StringBundler(4);
                        sb.append("The search index writer's task queue ");
                        sb.append("is at its maximum capacity. The ");
                        sb.append("current thread will handle the ");
                        sb.append("request.");
                        _log.warn(sb.toString());
                    }
                    super.rejectedExecution(runnable, threadPoolExecutor);
                }
            };
            destinationConfiguration.setRejectedExecutionHandler(rejectedExecutionHandler);
        }
        return DestinationFactoryUtil.createDestination(destinationConfiguration);
    }

    protected void destroySearchEngine(SearchEngineRegistration searchEngineRegistration) {
        this._messageBus.removeDestination(searchEngineRegistration.getSearchReaderDestinationName());
        this._messageBus.removeDestination(searchEngineRegistration.getSearchWriterDestinationName());
        SearchEngineHelper searchEngineHelper = this.getSearchEngineHelper();
        searchEngineHelper.removeSearchEngine(searchEngineRegistration.getSearchEngineId());
        if (!searchEngineRegistration.isOverride()) {
            return;
        }
        SearchEngineProxyWrapper originalSearchEngineProxy = searchEngineRegistration.getOriginalSearchEngineProxyWrapper();
        Destination searchReaderDestination = this.getSearchReaderDestination(this._messageBus, searchEngineRegistration.getSearchEngineId());
        this.registerInvokerMessageListener(searchReaderDestination, searchEngineRegistration.getOriginalSearchReaderMessageListeners());
        Destination searchWriterDestination = this.getSearchWriterDestination(this._messageBus, searchEngineRegistration.getSearchEngineId());
        this.registerInvokerMessageListener(searchWriterDestination, searchEngineRegistration.getOriginalSearchWriterMessageListeners());
        this.setSearchEngine(searchEngineRegistration.getSearchEngineId(), originalSearchEngineProxy);
    }

    protected abstract String getDefaultSearchEngineId();

    protected abstract IndexSearcher getIndexSearcher();

    protected abstract IndexWriter getIndexWriter();

    protected abstract ClassLoader getOperatingClassloader();

    protected abstract SearchEngineHelper getSearchEngineHelper();

    protected Destination getSearchReaderDestination(MessageBus messageBus, String searchEngineId) {
        SearchEngineHelper searchEngineHelper = this.getSearchEngineHelper();
        String searchReaderDestinationName = searchEngineHelper.getSearchReaderDestinationName(searchEngineId);
        Destination searchReaderDestination = messageBus.getDestination(searchReaderDestinationName);
        if (searchReaderDestination == null) {
            searchReaderDestination = this.createSearchReaderDestination(searchReaderDestinationName);
            messageBus.addDestination(searchReaderDestination);
        }
        return searchReaderDestination;
    }

    protected Destination getSearchWriterDestination(MessageBus messageBus, String searchEngineId) {
        SearchEngineHelper searchEngineHelper = this.getSearchEngineHelper();
        String searchWriterDestinationName = searchEngineHelper.getSearchWriterDestinationName(searchEngineId);
        Destination searchWriterDestination = messageBus.getDestination(searchWriterDestinationName);
        if (searchWriterDestination == null) {
            searchWriterDestination = this.createSearchWriterDestination(searchWriterDestinationName);
            messageBus.addDestination(searchWriterDestination);
        }
        return searchWriterDestination;
    }

    protected void initialize() {
        Set<Map.Entry<String, SearchEngine>> entrySet = this._searchEngines.entrySet();
        for (Map.Entry<String, SearchEngine> entry : entrySet) {
            this.initSearchEngine(entry.getKey(), entry.getValue());
        }
        String defaultSearchEngineId = this.getDefaultSearchEngineId();
        if (Validator.isNotNull(defaultSearchEngineId)) {
            SearchEngineHelper searchEngineHelper = this.getSearchEngineHelper();
            this._originalSearchEngineId = searchEngineHelper.getDefaultSearchEngineId();
            searchEngineHelper.setDefaultSearchEngineId(defaultSearchEngineId);
        }
        this._searchEngines.clear();
    }

    protected void initSearchEngine(String searchEngineId, SearchEngine searchEngine) {
        SearchEngineRegistration searchEngineRegistration = new SearchEngineRegistration(searchEngineId);
        this._searchEngineRegistrations.add(searchEngineRegistration);
        Destination searchReaderDestination = this.getSearchReaderDestination(this._messageBus, searchEngineId);
        searchEngineRegistration.setSearchReaderDestinationName(searchReaderDestination.getName());
        Destination searchWriterDestination = this.getSearchWriterDestination(this._messageBus, searchEngineId);
        searchEngineRegistration.setSearchWriterDestinationName(searchWriterDestination.getName());
        SearchEngineHelper searchEngineHelper = this.getSearchEngineHelper();
        SearchEngine originalSearchEngine = searchEngineHelper.getSearchEngineSilent(searchEngineId);
        if (originalSearchEngine != null) {
            searchEngineRegistration.setOverride(true);
            searchEngineRegistration.setOriginalSearchEngineProxyWrapper((SearchEngineProxyWrapper)originalSearchEngine);
            this.savePreviousSearchEngineListeners(searchReaderDestination, searchWriterDestination, searchEngineRegistration);
            this._messageBus.removeDestination(searchReaderDestination.getName(), false);
            searchReaderDestination = this.getSearchReaderDestination(this._messageBus, searchEngineId);
            this._messageBus.removeDestination(searchWriterDestination.getName(), false);
            searchWriterDestination = this.getSearchWriterDestination(this._messageBus, searchEngineId);
        }
        this.createSearchEngineListeners(searchEngineId, searchEngine, searchReaderDestination, searchWriterDestination);
        SearchEngineProxyWrapper searchEngineProxyWrapper = new SearchEngineProxyWrapper(searchEngine, this.getIndexSearcher(), this.getIndexWriter());
        this.setSearchEngine(searchEngineId, searchEngineProxyWrapper);
    }

    protected void registerInvokerMessageListener(Destination destination, List<InvokerMessageListener> invokerMessageListeners) {
        for (InvokerMessageListener invokerMessageListener : invokerMessageListeners) {
            destination.register(invokerMessageListener.getMessageListener(), invokerMessageListener.getClassLoader());
        }
    }

    protected void registerSearchEngineMessageListener(String searchEngineId, SearchEngine searchEngine, Destination destination, BaseSearchEngineMessageListener baseSearchEngineMessageListener, Object manager) {
        baseSearchEngineMessageListener.setManager(manager);
        baseSearchEngineMessageListener.setMessageBus(this._messageBus);
        baseSearchEngineMessageListener.setSearchEngine(searchEngine);
        baseSearchEngineMessageListener.setSearchEngineId(searchEngineId);
        destination.register(baseSearchEngineMessageListener, this.getOperatingClassloader());
    }

    protected void savePreviousSearchEngineListeners(Destination searchReaderDestination, Destination searchWriterDestination, SearchEngineRegistration searchEngineRegistration) {
        Set<MessageListener> searchReaderMessageListeners = searchReaderDestination.getMessageListeners();
        for (MessageListener searchReaderMessageListener : searchReaderMessageListeners) {
            InvokerMessageListener invokerMessageListener = (InvokerMessageListener)searchReaderMessageListener;
            searchEngineRegistration.addOriginalSearchReaderMessageListener(invokerMessageListener);
        }
        Set<MessageListener> searchWriterMessageListeners = searchWriterDestination.getMessageListeners();
        for (MessageListener searchWriterMessageListener : searchWriterMessageListeners) {
            InvokerMessageListener invokerMessageListener = (InvokerMessageListener)searchWriterMessageListener;
            searchEngineRegistration.addOriginalSearchWriterMessageListener(invokerMessageListener);
        }
    }

    protected void setSearchEngine(String searchEngineId, SearchEngine searchEngine) {
        SearchEngineHelper searchEngineHelper = this.getSearchEngineHelper();
        searchEngineHelper.setSearchEngine(searchEngineId, searchEngine);
        searchEngine.initialize(0L);
    }

    private static class SearchEngineRegistration {
        private SearchEngineProxyWrapper _originalSearchEngineProxyWrapper;
        private final List<InvokerMessageListener> _originalSearchReaderMessageListeners = new ArrayList<InvokerMessageListener>();
        private final List<InvokerMessageListener> _originalSearchWriterMessageListeners = new ArrayList<InvokerMessageListener>();
        private boolean _override;
        private final String _searchEngineId;
        private String _searchReaderDestinationName;
        private String _searchWriterDestinationName;

        public void addOriginalSearchReaderMessageListener(InvokerMessageListener messageListener) {
            this._originalSearchReaderMessageListeners.add(messageListener);
        }

        public void addOriginalSearchWriterMessageListener(InvokerMessageListener messageListener) {
            this._originalSearchWriterMessageListeners.add(messageListener);
        }

        public SearchEngineProxyWrapper getOriginalSearchEngineProxyWrapper() {
            return this._originalSearchEngineProxyWrapper;
        }

        public List<InvokerMessageListener> getOriginalSearchReaderMessageListeners() {
            return this._originalSearchReaderMessageListeners;
        }

        public List<InvokerMessageListener> getOriginalSearchWriterMessageListeners() {
            return this._originalSearchWriterMessageListeners;
        }

        public String getSearchEngineId() {
            return this._searchEngineId;
        }

        public String getSearchReaderDestinationName() {
            return this._searchReaderDestinationName;
        }

        public String getSearchWriterDestinationName() {
            return this._searchWriterDestinationName;
        }

        public boolean isOverride() {
            return this._override;
        }

        public void setOriginalSearchEngineProxyWrapper(SearchEngineProxyWrapper searchEngineProxyWrapper) {
            this._originalSearchEngineProxyWrapper = searchEngineProxyWrapper;
        }

        public void setOverride(boolean override) {
            this._override = override;
        }

        public void setSearchReaderDestinationName(String searchReaderDestinationName) {
            this._searchReaderDestinationName = searchReaderDestinationName;
        }

        public void setSearchWriterDestinationName(String searchWriterDestinationName) {
            this._searchWriterDestinationName = searchWriterDestinationName;
        }

        private SearchEngineRegistration(String searchEngineId) {
            this._searchEngineId = searchEngineId;
        }
    }
}

