/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checks;

import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.source.formatter.checks.BaseFileCheck;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JavaStylingCheck
extends BaseFileCheck {
    private final Pattern _incorrectSynchronizedPattern = Pattern.compile("([\n\t])(synchronized) (private|public|protected)");

    @Override
    protected String doProcess(String fileName, String absolutePath, String content) {
        if (content.contains("$\n */")) {
            content = StringUtil.replace(content, "$\n */", "$\n *\n */");
        }
        if (content.contains(" * @author Raymond Aug") && !content.contains(" * @author Raymond Aug\u00e9")) {
            content = content.replaceFirst("Raymond Aug.++", "Raymond Aug\u00e9");
        }
        content = StringUtil.replace(content, " final static ", " static final ");
        content = StringUtil.replace(content, new String[]{";\n/**", "\t/*\n\t *", ";;\n", "\n/**\n *\n *", "\n */\npackage "}, new String[]{";\n\n/**", "\t/**\n\t *", ";\n", "\n/**\n *", "\n */\n\npackage "});
        content = StringUtil.replace(content, new String[]{"!Validator.isNotNull(", "!Validator.isNull("}, new String[]{"Validator.isNull(", "Validator.isNotNull("});
        content = StringUtil.replace(content, "\tfor (;;) {", "\twhile (true) {");
        Matcher matcher = this._incorrectSynchronizedPattern.matcher(content);
        content = matcher.replaceAll("$1$3 $2");
        return content;
    }
}

