/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checks;

import com.liferay.source.formatter.checks.BaseFileCheck;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JavaSeeAnnotationCheck
extends BaseFileCheck {
    private final Pattern _seeAnnotationPattern = Pattern.compile("[\n\t] ?\\* @see.*@");

    @Override
    protected String doProcess(String fileName, String absolutePath, String content) {
        Matcher matcher = this._seeAnnotationPattern.matcher(content);
        while (matcher.find()) {
            this.addMessage(fileName, "Do not use @see with another annotation", this.getLineCount(content, matcher.start() + 1));
        }
        return content;
    }
}

