/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.ratings.service.impl;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portlet.ratings.service.base.RatingsStatsLocalServiceBaseImpl;
import com.liferay.ratings.kernel.exception.NoSuchStatsException;
import com.liferay.ratings.kernel.model.RatingsStats;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class RatingsStatsLocalServiceImpl
extends RatingsStatsLocalServiceBaseImpl {
    private static final Log _log = LogFactoryUtil.getLog(RatingsStatsLocalServiceImpl.class);

    public RatingsStats addStats(long classNameId, long classPK) {
        RatingsStats stats;
        block3: {
            long statsId = this.counterLocalService.increment();
            stats = this.ratingsStatsPersistence.create(statsId);
            stats.setClassNameId(classNameId);
            stats.setClassPK(classPK);
            stats.setTotalEntries(0);
            stats.setTotalScore(0.0);
            stats.setAverageScore(0.0);
            try {
                this.ratingsStatsPersistence.update((BaseModel)stats);
            }
            catch (SystemException se) {
                if (_log.isWarnEnabled()) {
                    _log.warn((Object)("Add failed, fetch {classNameId=" + classNameId + ", classPK=" + classPK + "}"));
                }
                if ((stats = this.ratingsStatsPersistence.fetchByC_C(classNameId, classPK, false)) != null) break block3;
                throw se;
            }
        }
        return stats;
    }

    public void deleteStats(String className, long classPK) {
        long classNameId;
        block2: {
            classNameId = this.classNameLocalService.getClassNameId(className);
            try {
                this.ratingsStatsPersistence.removeByC_C(classNameId, classPK);
            }
            catch (NoSuchStatsException nsse) {
                if (!_log.isWarnEnabled()) break block2;
                _log.warn((Throwable)nsse);
            }
        }
        this.ratingsEntryPersistence.removeByC_C(classNameId, classPK);
    }

    public RatingsStats fetchStats(String className, long classPK) {
        long classNameId = this.classNameLocalService.getClassNameId(className);
        return this.ratingsStatsPersistence.fetchByC_C(classNameId, classPK);
    }

    public RatingsStats getStats(long statsId) throws PortalException {
        return this.ratingsStatsPersistence.findByPrimaryKey(statsId);
    }

    @Deprecated
    public List<RatingsStats> getStats(String className, List<Long> classPKs) {
        long classNameId = this.classNameLocalService.getClassNameId(className);
        return this.ratingsStatsFinder.findByC_C(classNameId, classPKs);
    }

    public RatingsStats getStats(String className, long classPK) throws PortalException {
        long classNameId = this.classNameLocalService.getClassNameId(className);
        return this.ratingsStatsPersistence.findByC_C(classNameId, classPK);
    }

    public Map<Long, RatingsStats> getStats(String className, long[] classPKs) {
        long classNameId = this.classNameLocalService.getClassNameId(className);
        HashMap<Long, RatingsStats> ratingsStats = new HashMap<Long, RatingsStats>();
        for (RatingsStats stats : this.ratingsStatsPersistence.findByC_C(classNameId, classPKs)) {
            ratingsStats.put(stats.getClassPK(), stats);
        }
        return ratingsStats;
    }
}

