/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.exportimport.service.impl;

import com.liferay.document.library.kernel.exception.NoSuchFileEntryException;
import com.liferay.document.library.kernel.exception.NoSuchFolderException;
import com.liferay.document.library.kernel.util.comparator.RepositoryModelTitleComparator;
import com.liferay.exportimport.kernel.configuration.ExportImportConfigurationParameterMapFactory;
import com.liferay.exportimport.kernel.exception.RemoteExportException;
import com.liferay.exportimport.kernel.lar.ExportImportDateUtil;
import com.liferay.exportimport.kernel.lar.ExportImportThreadLocal;
import com.liferay.exportimport.kernel.lar.MissingReferences;
import com.liferay.exportimport.kernel.model.ExportImportConfiguration;
import com.liferay.exportimport.kernel.staging.StagingUtil;
import com.liferay.portal.kernel.exception.NoSuchGroupException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.io.unsync.UnsyncByteArrayInputStream;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.LayoutRevision;
import com.liferay.portal.kernel.model.LayoutSetBranch;
import com.liferay.portal.kernel.model.PortletPreferences;
import com.liferay.portal.kernel.model.Repository;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.portletfilerepository.PortletFileRepositoryUtil;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.repository.model.Folder;
import com.liferay.portal.kernel.search.IndexStatusManagerThreadLocal;
import com.liferay.portal.kernel.security.auth.HttpPrincipal;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.security.auth.RemoteAuthException;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.PermissionThreadLocal;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.LocaleThreadLocal;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.PortalClassLoaderUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.PropertiesParamUtil;
import com.liferay.portal.kernel.util.StreamUtil;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.service.http.GroupServiceHttp;
import com.liferay.portlet.exportimport.service.base.StagingLocalServiceBaseImpl;
import com.liferay.portlet.exportimport.staging.StagingAdvicesThreadLocal;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.portlet.PortletRequest;

public class StagingLocalServiceImpl
extends StagingLocalServiceBaseImpl {
    private static final String _ASSEMBLED_LAR_PREFIX = "assembled_";
    private static final String _PORTLET_REPOSITORY_ID = "134";
    private static final Log _log = LogFactoryUtil.getLog(StagingLocalServiceImpl.class);

    public void checkDefaultLayoutSetBranches(long userId, Group liveGroup, boolean branchingPublic, boolean branchingPrivate, boolean remote, ServiceContext serviceContext) throws PortalException {
        long targetGroupId = 0L;
        if (remote) {
            targetGroupId = liveGroup.getGroupId();
        } else {
            Group stagingGroup = liveGroup.getStagingGroup();
            if (stagingGroup == null) {
                return;
            }
            targetGroupId = stagingGroup.getGroupId();
        }
        LayoutSetBranch layoutSetBranch = this.layoutSetBranchLocalService.fetchLayoutSetBranch(targetGroupId, false, "main-variation");
        if (branchingPublic && layoutSetBranch == null) {
            this.addDefaultLayoutSetBranch(userId, targetGroupId, liveGroup.getDescriptiveName(), false, serviceContext);
        } else if (!branchingPublic && layoutSetBranch != null) {
            this.deleteLayoutSetBranches(targetGroupId, false);
        } else if (layoutSetBranch != null) {
            ExportImportDateUtil.clearLastPublishDate((long)targetGroupId, (boolean)false);
        }
        layoutSetBranch = this.layoutSetBranchLocalService.fetchLayoutSetBranch(targetGroupId, true, "main-variation");
        if (branchingPrivate && layoutSetBranch == null) {
            this.addDefaultLayoutSetBranch(userId, targetGroupId, liveGroup.getDescriptiveName(), true, serviceContext);
        } else if (!branchingPrivate && layoutSetBranch != null) {
            this.deleteLayoutSetBranches(targetGroupId, true);
        } else if (layoutSetBranch != null) {
            ExportImportDateUtil.clearLastPublishDate((long)targetGroupId, (boolean)true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanUpStagingRequest(long stagingRequestId) throws PortalException {
        boolean indexReadOnly = IndexStatusManagerThreadLocal.isIndexReadOnly();
        IndexStatusManagerThreadLocal.setIndexReadOnly((boolean)true);
        try {
            PortletFileRepositoryUtil.deletePortletFolder((long)stagingRequestId);
        }
        catch (NoSuchFolderException nsfe) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Unable to clean up staging request " + stagingRequestId), (Throwable)nsfe);
            }
        }
        finally {
            IndexStatusManagerThreadLocal.setIndexReadOnly((boolean)indexReadOnly);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long createStagingRequest(long userId, long groupId, String checksum) throws PortalException {
        boolean indexReadOnly = IndexStatusManagerThreadLocal.isIndexReadOnly();
        IndexStatusManagerThreadLocal.setIndexReadOnly((boolean)true);
        try {
            ServiceContext serviceContext = new ServiceContext();
            Repository repository = PortletFileRepositoryUtil.addPortletRepository((long)groupId, (String)_PORTLET_REPOSITORY_ID, (ServiceContext)serviceContext);
            Folder folder = PortletFileRepositoryUtil.addPortletFolder((long)userId, (long)repository.getRepositoryId(), (long)0L, (String)checksum, (ServiceContext)serviceContext);
            long l = folder.getFolderId();
            return l;
        }
        finally {
            IndexStatusManagerThreadLocal.setIndexReadOnly((boolean)indexReadOnly);
        }
    }

    public void disableStaging(Group liveGroup, ServiceContext serviceContext) throws PortalException {
        this.disableStaging(null, liveGroup, serviceContext);
    }

    public void disableStaging(PortletRequest portletRequest, Group liveGroup, ServiceContext serviceContext) throws PortalException {
        UnicodeProperties typeSettingsProperties = liveGroup.getTypeSettingsProperties();
        boolean stagedLocally = GetterUtil.getBoolean((String)typeSettingsProperties.getProperty("staged"));
        boolean stagedRemotely = GetterUtil.getBoolean((String)typeSettingsProperties.getProperty("stagedRemotely"));
        if (!stagedLocally && !stagedRemotely) {
            return;
        }
        if (stagedRemotely) {
            String remoteURL = StagingUtil.buildRemoteURL((UnicodeProperties)typeSettingsProperties);
            long remoteGroupId = GetterUtil.getLong((String)typeSettingsProperties.getProperty("remoteGroupId"));
            boolean forceDisable = GetterUtil.getBoolean((Object)serviceContext.getAttribute("forceDisable"));
            this.disableRemoteStaging(remoteURL, remoteGroupId, forceDisable);
        }
        typeSettingsProperties.remove((Object)"branchingPrivate");
        typeSettingsProperties.remove((Object)"branchingPublic");
        typeSettingsProperties.remove((Object)"remoteAddress");
        typeSettingsProperties.remove((Object)"remoteGroupId");
        typeSettingsProperties.remove((Object)"remotePathContext");
        typeSettingsProperties.remove((Object)"remotePort");
        typeSettingsProperties.remove((Object)"secureConnection");
        typeSettingsProperties.remove((Object)"staged");
        typeSettingsProperties.remove((Object)"stagedRemotely");
        HashSet<String> keys = new HashSet<String>();
        for (String key : typeSettingsProperties.keySet()) {
            if (!key.startsWith("staged-portlet_")) continue;
            keys.add(key);
        }
        for (String key : keys) {
            typeSettingsProperties.remove((Object)key);
        }
        StagingUtil.deleteLastImportSettings((Group)liveGroup, (boolean)true);
        StagingUtil.deleteLastImportSettings((Group)liveGroup, (boolean)false);
        this.checkDefaultLayoutSetBranches(serviceContext.getUserId(), liveGroup, false, false, stagedRemotely, serviceContext);
        if (liveGroup.hasStagingGroup()) {
            Group stagingGroup = liveGroup.getStagingGroup();
            this.groupLocalService.deleteGroup(stagingGroup.getGroupId());
            liveGroup.clearStagingGroup();
        }
        this.groupLocalService.updateGroup(liveGroup.getGroupId(), typeSettingsProperties.toString());
    }

    public void enableLocalStaging(long userId, Group liveGroup, boolean branchingPublic, boolean branchingPrivate, ServiceContext serviceContext) throws PortalException {
        boolean hasStagingGroup;
        if (liveGroup.isStagedRemotely()) {
            this.disableStaging(liveGroup, serviceContext);
        }
        if (!(hasStagingGroup = liveGroup.hasStagingGroup())) {
            serviceContext.setAttribute("staging", (Serializable)((Object)String.valueOf(true)));
            this.addStagingGroup(userId, liveGroup, serviceContext);
        }
        this.checkDefaultLayoutSetBranches(userId, liveGroup, branchingPublic, branchingPrivate, false, serviceContext);
        UnicodeProperties typeSettingsProperties = liveGroup.getTypeSettingsProperties();
        typeSettingsProperties.setProperty("branchingPrivate", String.valueOf(branchingPrivate));
        typeSettingsProperties.setProperty("branchingPublic", String.valueOf(branchingPublic));
        if (!hasStagingGroup) {
            typeSettingsProperties.setProperty("staged", Boolean.TRUE.toString());
            typeSettingsProperties.setProperty("stagedRemotely", String.valueOf(false));
            this.setCommonStagingOptions(typeSettingsProperties, serviceContext);
        }
        this.groupLocalService.updateGroup(liveGroup.getGroupId(), typeSettingsProperties.toString());
        if (!hasStagingGroup) {
            Group stagingGroup = liveGroup.getStagingGroup();
            Map parameterMap = ExportImportConfigurationParameterMapFactory.buildParameterMap();
            if (liveGroup.hasPrivateLayouts()) {
                StagingUtil.publishLayouts((long)userId, (long)liveGroup.getGroupId(), (long)stagingGroup.getGroupId(), (boolean)true, (Map)parameterMap);
            }
            if (liveGroup.hasPublicLayouts() || !liveGroup.hasPrivateLayouts()) {
                StagingUtil.publishLayouts((long)userId, (long)liveGroup.getGroupId(), (long)stagingGroup.getGroupId(), (boolean)false, (Map)parameterMap);
            }
        }
    }

    public void enableRemoteStaging(long userId, Group stagingGroup, boolean branchingPublic, boolean branchingPrivate, String remoteAddress, int remotePort, String remotePathContext, boolean secureConnection, long remoteGroupId, ServiceContext serviceContext) throws PortalException {
        boolean stagedRemotely;
        StagingUtil.validateRemote((long)stagingGroup.getGroupId(), (String)remoteAddress, (int)remotePort, (String)remotePathContext, (boolean)secureConnection, (long)remoteGroupId);
        if (stagingGroup.hasStagingGroup()) {
            this.disableStaging(stagingGroup, serviceContext);
        }
        boolean oldStagedRemotely = stagedRemotely = stagingGroup.isStagedRemotely();
        UnicodeProperties typeSettingsProperties = stagingGroup.getTypeSettingsProperties();
        String remoteURL = StagingUtil.buildRemoteURL((String)remoteAddress, (int)remotePort, (String)remotePathContext, (boolean)secureConnection);
        if (stagedRemotely) {
            long oldRemoteGroupId = GetterUtil.getLong((String)typeSettingsProperties.getProperty("remoteGroupId"));
            String oldRemoteURL = StagingUtil.buildRemoteURL((UnicodeProperties)typeSettingsProperties);
            if (!remoteURL.equals(oldRemoteURL) || remoteGroupId != oldRemoteGroupId) {
                this.disableRemoteStaging(oldRemoteURL, oldRemoteGroupId, false);
                stagedRemotely = false;
            }
        }
        PermissionChecker permissionChecker = PermissionThreadLocal.getPermissionChecker();
        User user = permissionChecker.getUser();
        HttpPrincipal httpPrincipal = new HttpPrincipal(remoteURL, user.getLogin(), user.getPassword(), user.getPasswordEncrypted());
        if (!stagedRemotely) {
            this.enableRemoteStaging(httpPrincipal, remoteGroupId);
        }
        Group remoteGroup = this.fetchRemoteGroup(httpPrincipal, remoteGroupId);
        this.checkDefaultLayoutSetBranches(userId, stagingGroup, branchingPublic, branchingPrivate, true, serviceContext);
        typeSettingsProperties.setProperty("branchingPrivate", String.valueOf(branchingPrivate));
        typeSettingsProperties.setProperty("branchingPublic", String.valueOf(branchingPublic));
        typeSettingsProperties.setProperty("remoteAddress", remoteAddress);
        typeSettingsProperties.setProperty("remoteGroupId", String.valueOf(remoteGroupId));
        typeSettingsProperties.setProperty("remoteGroupUUID", remoteGroup.getUuid());
        typeSettingsProperties.setProperty("remotePathContext", remotePathContext);
        typeSettingsProperties.setProperty("remotePort", String.valueOf(remotePort));
        typeSettingsProperties.setProperty("secureConnection", String.valueOf(secureConnection));
        if (!oldStagedRemotely) {
            typeSettingsProperties.setProperty("staged", Boolean.TRUE.toString());
            typeSettingsProperties.setProperty("stagedRemotely", Boolean.TRUE.toString());
            this.setCommonStagingOptions(typeSettingsProperties, serviceContext);
        }
        this.groupLocalService.updateGroup(stagingGroup.getGroupId(), typeSettingsProperties.toString());
        this.updateStagedPortlets(remoteURL, remoteGroupId, typeSettingsProperties);
    }

    @Deprecated
    public MissingReferences publishStagingRequest(long userId, long stagingRequestId, boolean privateLayout, Map<String, String[]> parameterMap) throws PortalException {
        throw new UnsupportedOperationException();
    }

    public MissingReferences publishStagingRequest(long userId, long stagingRequestId, ExportImportConfiguration exportImportConfiguration) throws PortalException {
        File file = null;
        Locale siteDefaultLocale = LocaleThreadLocal.getSiteDefaultLocale();
        try {
            ExportImportThreadLocal.setLayoutImportInProcess((boolean)true);
            ExportImportThreadLocal.setLayoutStagingInProcess((boolean)true);
            Folder folder = PortletFileRepositoryUtil.getPortletFolder((long)stagingRequestId);
            FileEntry stagingRequestFileEntry = this.getStagingRequestFileEntry(userId, stagingRequestId, folder);
            file = FileUtil.createTempFile((String)"lar");
            FileUtil.write((File)file, (InputStream)stagingRequestFileEntry.getContentStream());
            Map settingsMap = exportImportConfiguration.getSettingsMap();
            settingsMap.put("userId", userId);
            long targetGroupId = MapUtil.getLong((Map)settingsMap, (String)"targetGroupId");
            LocaleThreadLocal.setSiteDefaultLocale((Locale)PortalUtil.getSiteDefaultLocale((long)targetGroupId));
            this.exportImportLocalService.importLayoutsDataDeletions(exportImportConfiguration, file);
            MissingReferences missingReferences = this.exportImportLocalService.validateImportLayoutsFile(exportImportConfiguration, file);
            this.exportImportLocalService.importLayouts(exportImportConfiguration, file);
            MissingReferences missingReferences2 = missingReferences;
            return missingReferences2;
        }
        catch (IOException ioe) {
            throw new SystemException("Unable to complete remote staging publication request " + stagingRequestId + " due to a file system error", (Throwable)ioe);
        }
        finally {
            ExportImportThreadLocal.setLayoutImportInProcess((boolean)false);
            ExportImportThreadLocal.setLayoutStagingInProcess((boolean)false);
            LocaleThreadLocal.setSiteDefaultLocale((Locale)siteDefaultLocale);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateStagingRequest(long userId, long stagingRequestId, String fileName, byte[] bytes) throws PortalException {
        Folder folder = PortletFileRepositoryUtil.getPortletFolder((long)stagingRequestId);
        boolean indexReadOnly = IndexStatusManagerThreadLocal.isIndexReadOnly();
        IndexStatusManagerThreadLocal.setIndexReadOnly((boolean)true);
        try {
            PortletFileRepositoryUtil.addPortletFileEntry((long)folder.getGroupId(), (long)userId, (String)Group.class.getName(), (long)folder.getGroupId(), (String)_PORTLET_REPOSITORY_ID, (long)folder.getFolderId(), (InputStream)new UnsyncByteArrayInputStream(bytes), (String)fileName, (String)"application/zip", (boolean)false);
        }
        finally {
            IndexStatusManagerThreadLocal.setIndexReadOnly((boolean)indexReadOnly);
        }
    }

    @Deprecated
    public MissingReferences validateStagingRequest(long userId, long stagingRequestId, boolean privateLayout, Map<String, String[]> parameterMap) {
        return new MissingReferences();
    }

    protected void addDefaultLayoutSetBranch(long userId, long groupId, String groupName, boolean privateLayout, ServiceContext serviceContext) throws PortalException {
        block4: {
            String masterBranchDescription = "main-site-pages-variation-of-x";
            if (privateLayout) {
                masterBranchDescription = "main-site-pages-variation-of-x";
            }
            String description = LanguageUtil.format((Locale)PortalUtil.getSiteDefaultLocale((long)groupId), (String)masterBranchDescription, (Object)groupName, (boolean)false);
            try {
                serviceContext.setWorkflowAction(0);
                LayoutSetBranch layoutSetBranch = this.layoutSetBranchLocalService.addLayoutSetBranch(userId, groupId, privateLayout, "main-variation", description, true, 0L, serviceContext);
                List layoutRevisions = this.layoutRevisionLocalService.getLayoutRevisions(layoutSetBranch.getLayoutSetBranchId(), false);
                for (LayoutRevision layoutRevision : layoutRevisions) {
                    this.layoutRevisionLocalService.updateStatus(userId, layoutRevision.getLayoutRevisionId(), 0, serviceContext);
                }
            }
            catch (PortalException pe) {
                if (!_log.isWarnEnabled()) break block4;
                _log.warn((Object)("Unable to create master branch for " + (privateLayout ? "private" : "public") + " layouts"), (Throwable)pe);
            }
        }
    }

    protected Group addStagingGroup(long userId, Group liveGroup, ServiceContext serviceContext) throws PortalException {
        long parentGroupId = liveGroup.getParentGroupId();
        Group stagingGroup = this.groupLocalService.addGroup(userId, parentGroupId, liveGroup.getClassName(), liveGroup.getClassPK(), liveGroup.getGroupId(), liveGroup.getNameMap(), liveGroup.getDescriptionMap(), liveGroup.getType(), liveGroup.isManualMembership(), liveGroup.getMembershipRestriction(), liveGroup.getFriendlyURL(), false, true, serviceContext);
        if (LanguageUtil.isInheritLocales((long)liveGroup.getGroupId())) {
            return stagingGroup;
        }
        UnicodeProperties liveTypeSettingsProperties = liveGroup.getTypeSettingsProperties();
        UnicodeProperties stagingTypeSettingsProperties = stagingGroup.getTypeSettingsProperties();
        stagingTypeSettingsProperties.setProperty("inheritLocales", Boolean.FALSE.toString());
        stagingTypeSettingsProperties.setProperty("locales", liveTypeSettingsProperties.getProperty("locales"));
        stagingTypeSettingsProperties.setProperty("languageId", liveTypeSettingsProperties.getProperty("languageId", LocaleUtil.toLanguageId((Locale)LocaleUtil.getDefault())));
        return this.groupLocalService.updateGroup(stagingGroup.getGroupId(), stagingTypeSettingsProperties.toString());
    }

    protected void deleteLayoutSetBranches(long groupId, boolean privateLayout) throws PortalException {
        String lastPublishDateString;
        HashMap<Long, LayoutRevision> layoutRevisions = new HashMap<Long, LayoutRevision>();
        List layoutSetBranches = this.layoutSetBranchLocalService.getLayoutSetBranches(groupId, privateLayout);
        boolean publishedToLive = false;
        for (LayoutSetBranch layoutSetBranch : layoutSetBranches) {
            lastPublishDateString = layoutSetBranch.getSettingsProperty("last-publish-date");
            if (!Validator.isNotNull((String)lastPublishDateString)) continue;
            publishedToLive = true;
            break;
        }
        for (LayoutSetBranch layoutSetBranch : layoutSetBranches) {
            lastPublishDateString = layoutSetBranch.getSettingsProperty("last-publish-date");
            if (Validator.isNull((String)lastPublishDateString) && publishedToLive) continue;
            Date lastPublishDate = null;
            if (Validator.isNotNull((String)lastPublishDateString)) {
                lastPublishDate = new Date(GetterUtil.getLong((String)lastPublishDateString));
            }
            List headLayoutRevisions = this.layoutRevisionLocalService.getLayoutRevisions(layoutSetBranch.getLayoutSetBranchId(), true);
            for (LayoutRevision headLayoutRevision : headLayoutRevisions) {
                LayoutRevision layoutRevision = (LayoutRevision)layoutRevisions.get(headLayoutRevision.getPlid());
                if (layoutRevision == null) {
                    layoutRevisions.put(headLayoutRevision.getPlid(), headLayoutRevision);
                    continue;
                }
                Date statusDate = headLayoutRevision.getStatusDate();
                if (!statusDate.after(layoutRevision.getStatusDate()) || lastPublishDate != null && !lastPublishDate.after(statusDate)) continue;
                layoutRevisions.put(headLayoutRevision.getPlid(), headLayoutRevision);
            }
        }
        for (LayoutRevision layoutRevision : layoutRevisions.values()) {
            this.updateLayoutWithLayoutRevision(layoutRevision);
        }
        this.layoutSetBranchLocalService.deleteLayoutSetBranches(groupId, privateLayout, true);
    }

    protected void disableRemoteStaging(String remoteURL, long remoteGroupId, boolean forceDisable) throws PortalException {
        block10: {
            PermissionChecker permissionChecker = PermissionThreadLocal.getPermissionChecker();
            User user = permissionChecker.getUser();
            HttpPrincipal httpPrincipal = new HttpPrincipal(remoteURL, user.getLogin(), user.getPassword(), user.getPasswordEncrypted());
            try {
                GroupServiceHttp.disableStaging(httpPrincipal, remoteGroupId);
            }
            catch (NoSuchGroupException nsge) {
                if (_log.isWarnEnabled()) {
                    _log.warn((Object)"Remote live group was already deleted", (Throwable)nsge);
                }
            }
            catch (PrincipalException pe) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)pe, (Throwable)pe);
                }
                RemoteExportException ree = new RemoteExportException(5);
                ree.setGroupId(remoteGroupId);
                throw ree;
            }
            catch (RemoteAuthException rae) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)rae, (Throwable)rae);
                }
                rae.setURL(remoteURL);
                throw rae;
            }
            catch (SystemException se) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)se, (Throwable)se);
                }
                if (!forceDisable) {
                    RemoteExportException ree = new RemoteExportException(1);
                    ree.setURL(remoteURL);
                    throw ree;
                }
                if (!_log.isWarnEnabled()) break block10;
                _log.warn((Object)"Forcibly disable remote staging");
            }
        }
    }

    protected void enableRemoteStaging(HttpPrincipal httpPrincipal, long remoteGroupId) throws PortalException {
        try {
            GroupServiceHttp.enableStaging(httpPrincipal, remoteGroupId);
        }
        catch (NoSuchGroupException nsge) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)nsge, (Throwable)nsge);
            }
            RemoteExportException ree = new RemoteExportException(3);
            ree.setGroupId(remoteGroupId);
            throw ree;
        }
        catch (PrincipalException pe) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)pe, (Throwable)pe);
            }
            RemoteExportException ree = new RemoteExportException(5);
            ree.setGroupId(remoteGroupId);
            throw ree;
        }
        catch (RemoteAuthException rae) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)rae, (Throwable)rae);
            }
            rae.setURL(httpPrincipal.getUrl());
            throw rae;
        }
        catch (SystemException se) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)se, (Throwable)se);
            }
            RemoteExportException ree = new RemoteExportException(1);
            ree.setURL(httpPrincipal.getUrl());
            throw ree;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Group fetchRemoteGroup(HttpPrincipal httpPrincipal, long groupId) throws PortalException {
        Thread currentThread = Thread.currentThread();
        ClassLoader contextClassLoader = currentThread.getContextClassLoader();
        try {
            currentThread.setContextClassLoader(PortalClassLoaderUtil.getClassLoader());
            Group group = GroupServiceHttp.getGroup(httpPrincipal, groupId);
            return group;
        }
        finally {
            currentThread.setContextClassLoader(contextClassLoader);
        }
    }

    protected FileEntry fetchStagingRequestFileEntry(long stagingRequestId, Folder folder) throws PortalException {
        try {
            return PortletFileRepositoryUtil.getPortletFileEntry((long)folder.getGroupId(), (long)folder.getFolderId(), (String)this.getAssembledFileName(stagingRequestId));
        }
        catch (NoSuchFileEntryException nsfee) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)nsfee, (Throwable)nsfee);
            }
            return null;
        }
    }

    protected String getAssembledFileName(long stagingRequestId) {
        return _ASSEMBLED_LAR_PREFIX + String.valueOf(stagingRequestId) + ".lar";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected FileEntry getStagingRequestFileEntry(long userId, long stagingRequestId, Folder folder) throws PortalException {
        FileEntry fileEntry;
        FileEntry stagingRequestFileEntry = this.fetchStagingRequestFileEntry(stagingRequestId, folder);
        if (stagingRequestFileEntry != null) {
            return stagingRequestFileEntry;
        }
        boolean indexReadOnly = IndexStatusManagerThreadLocal.isIndexReadOnly();
        IndexStatusManagerThreadLocal.setIndexReadOnly((boolean)true);
        FileOutputStream fileOutputStream = null;
        File tempFile = null;
        try {
            tempFile = FileUtil.createTempFile((String)"lar");
            fileOutputStream = new FileOutputStream(tempFile);
            List fileEntries = PortletFileRepositoryUtil.getPortletFileEntries((long)folder.getGroupId(), (long)folder.getFolderId(), (OrderByComparator)new RepositoryModelTitleComparator(true));
            for (FileEntry fileEntry2 : fileEntries) {
                try {
                    StreamUtil.transfer((InputStream)fileEntry2.getContentStream(), (OutputStream)StreamUtil.uncloseable((OutputStream)fileOutputStream));
                }
                finally {
                    PortletFileRepositoryUtil.deletePortletFileEntry((long)fileEntry2.getFileEntryId());
                }
            }
            String checksum = FileUtil.getMD5Checksum((File)tempFile);
            if (!checksum.equals(folder.getName())) {
                throw new SystemException("Unable to process LAR file pieces for remote staging publication because LAR file checksum is not " + checksum);
            }
            PortletFileRepositoryUtil.addPortletFileEntry((long)folder.getGroupId(), (long)userId, (String)Group.class.getName(), (long)folder.getGroupId(), (String)_PORTLET_REPOSITORY_ID, (long)folder.getFolderId(), (File)tempFile, (String)this.getAssembledFileName(stagingRequestId), (String)"application/zip", (boolean)false);
            stagingRequestFileEntry = this.fetchStagingRequestFileEntry(stagingRequestId, folder);
            if (stagingRequestFileEntry == null) {
                throw new SystemException("Unable to assemble LAR file for remote staging publication request " + stagingRequestId);
            }
            fileEntry = stagingRequestFileEntry;
        }
        catch (IOException ioe) {
            try {
                throw new SystemException("Unable to reassemble LAR file for remote staging publication request " + stagingRequestId, (Throwable)ioe);
            }
            catch (Throwable throwable) {
                IndexStatusManagerThreadLocal.setIndexReadOnly((boolean)indexReadOnly);
                StreamUtil.cleanUp((Closeable[])new Closeable[]{fileOutputStream});
                FileUtil.delete((File)tempFile);
                throw throwable;
            }
        }
        IndexStatusManagerThreadLocal.setIndexReadOnly((boolean)indexReadOnly);
        StreamUtil.cleanUp((Closeable[])new Closeable[]{fileOutputStream});
        FileUtil.delete((File)tempFile);
        return fileEntry;
    }

    protected void setCommonStagingOptions(UnicodeProperties typeSettingsProperties, ServiceContext serviceContext) {
        typeSettingsProperties.putAll((Map)PropertiesParamUtil.getProperties((ServiceContext)serviceContext, (String)"staged--"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Layout updateLayoutWithLayoutRevision(LayoutRevision layoutRevision) {
        Layout layout = null;
        boolean stagingAdvicesThreadLocalEnabled = StagingAdvicesThreadLocal.isEnabled();
        try {
            StagingAdvicesThreadLocal.setEnabled(false);
            layout = this.layoutLocalService.fetchLayout(layoutRevision.getPlid());
        }
        finally {
            StagingAdvicesThreadLocal.setEnabled(stagingAdvicesThreadLocalEnabled);
        }
        this.updatePortletPreferences(layoutRevision, layout);
        layout.setUserId(layoutRevision.getUserId());
        layout.setUserName(layoutRevision.getUserName());
        layout.setCreateDate(layoutRevision.getCreateDate());
        layout.setModifiedDate(layoutRevision.getModifiedDate());
        layout.setPrivateLayout(layoutRevision.getPrivateLayout());
        layout.setName(layoutRevision.getName());
        layout.setTitle(layoutRevision.getTitle());
        layout.setDescription(layoutRevision.getDescription());
        layout.setKeywords(layoutRevision.getKeywords());
        layout.setRobots(layoutRevision.getRobots());
        layout.setTypeSettings(layoutRevision.getTypeSettings());
        layout.setIconImageId(layoutRevision.getIconImageId());
        layout.setThemeId(layoutRevision.getThemeId());
        layout.setColorSchemeId(layoutRevision.getColorSchemeId());
        layout.setCss(layoutRevision.getCss());
        return this.layoutLocalService.updateLayout(layout);
    }

    protected void updatePortletPreferences(LayoutRevision layoutRevision, Layout layout) {
        this.portletPreferencesLocalService.deletePortletPreferencesByPlid(layout.getPlid());
        List portletPreferencesList = this.portletPreferencesLocalService.getPortletPreferencesByPlid(layoutRevision.getLayoutRevisionId());
        for (PortletPreferences portletPreferences : portletPreferencesList) {
            this.portletPreferencesLocalService.addPortletPreferences(layoutRevision.getCompanyId(), portletPreferences.getOwnerId(), portletPreferences.getOwnerType(), layout.getPlid(), portletPreferences.getPortletId(), null, portletPreferences.getPreferences());
        }
    }

    protected void updateStagedPortlets(String remoteURL, long remoteGroupId, UnicodeProperties typeSettingsProperties) throws PortalException {
        RemoteExportException ree;
        PermissionChecker permissionChecker = PermissionThreadLocal.getPermissionChecker();
        User user = permissionChecker.getUser();
        HttpPrincipal httpPrincipal = new HttpPrincipal(remoteURL, user.getLogin(), user.getPassword(), user.getPasswordEncrypted());
        HashMap<String, String> stagedPortletIds = new HashMap<String, String>();
        for (String key : typeSettingsProperties.keySet()) {
            if (!key.startsWith("staged-portlet_")) continue;
            stagedPortletIds.put(key, typeSettingsProperties.getProperty(key));
        }
        try {
            GroupServiceHttp.updateStagedPortlets(httpPrincipal, remoteGroupId, stagedPortletIds);
        }
        catch (NoSuchGroupException nsge) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)nsge, (Throwable)nsge);
            }
            ree = new RemoteExportException(3);
            ree.setGroupId(remoteGroupId);
            throw ree;
        }
        catch (PrincipalException pe) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)pe, (Throwable)pe);
            }
            ree = new RemoteExportException(5);
            ree.setGroupId(remoteGroupId);
            throw ree;
        }
        catch (RemoteAuthException rae) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)rae, (Throwable)rae);
            }
            rae.setURL(remoteURL);
            throw rae;
        }
        catch (SystemException se) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)se, (Throwable)se);
            }
            ree = new RemoteExportException(1);
            ree.setURL(remoteURL);
            throw ree;
        }
    }
}

