/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.asset.util;

import com.liferay.asset.kernel.model.AssetVocabulary;
import com.liferay.asset.kernel.service.AssetVocabularyLocalServiceUtil;
import com.liferay.portal.kernel.dao.orm.ActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.IndexableActionableDynamicQuery;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.search.BaseIndexer;
import com.liferay.portal.kernel.search.BooleanClauseOccur;
import com.liferay.portal.kernel.search.BooleanQuery;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.IndexWriterHelperUtil;
import com.liferay.portal.kernel.search.Query;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.Summary;
import com.liferay.portal.kernel.search.filter.BooleanFilter;
import com.liferay.portal.kernel.search.generic.BooleanQueryImpl;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portlet.asset.service.permission.AssetVocabularyPermission;
import java.util.Locale;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;

@Deprecated
public class AssetVocabularyIndexer
extends BaseIndexer<AssetVocabulary> {
    public static final String CLASS_NAME = AssetVocabulary.class.getName();
    private static final Log _log = LogFactoryUtil.getLog(AssetVocabularyIndexer.class);

    public AssetVocabularyIndexer() {
        this.setDefaultSelectedFieldNames(new String[]{"assetVocabularyId", "companyId", "groupId", "uid"});
        this.setFilterSearch(true);
        this.setPermissionAware(true);
    }

    public String getClassName() {
        return CLASS_NAME;
    }

    public boolean hasPermission(PermissionChecker permissionChecker, String entryClassName, long entryClassPK, String actionId) throws Exception {
        AssetVocabulary vocabulary = AssetVocabularyLocalServiceUtil.getVocabulary((long)entryClassPK);
        return AssetVocabularyPermission.contains(permissionChecker, vocabulary, "VIEW");
    }

    public void postProcessSearchQuery(BooleanQuery searchQuery, BooleanFilter fullQueryBooleanFilter, SearchContext searchContext) throws Exception {
        String title = (String)((Object)searchContext.getAttribute("title"));
        if (Validator.isNotNull((String)title)) {
            BooleanQueryImpl localizedQuery = new BooleanQueryImpl();
            this.addSearchLocalizedTerm((BooleanQuery)localizedQuery, searchContext, "title", true);
            searchQuery.add((Query)localizedQuery, BooleanClauseOccur.SHOULD);
        }
    }

    protected void doDelete(AssetVocabulary assetVocabulary) throws Exception {
        this.deleteDocument(assetVocabulary.getCompanyId(), assetVocabulary.getVocabularyId());
    }

    protected Document doGetDocument(AssetVocabulary assetVocabulary) throws Exception {
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Indexing asset vocabulary " + assetVocabulary));
        }
        Document document = this.getBaseModelDocument(CLASS_NAME, (BaseModel)assetVocabulary);
        document.addKeyword("assetVocabularyId", assetVocabulary.getVocabularyId());
        Locale siteDefaultLocale = PortalUtil.getSiteDefaultLocale((long)assetVocabulary.getGroupId());
        this.addLocalizedField(document, "description", siteDefaultLocale, assetVocabulary.getDescriptionMap());
        document.addText("name", assetVocabulary.getName());
        this.addLocalizedField(document, "title", siteDefaultLocale, assetVocabulary.getTitleMap());
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Document " + assetVocabulary + " indexed successfully"));
        }
        return document;
    }

    protected Summary doGetSummary(Document document, Locale locale, String snippet, PortletRequest portletRequest, PortletResponse portletResponse) {
        return null;
    }

    protected void doReindex(AssetVocabulary assetVocabulary) throws Exception {
        Document document = this.getDocument(assetVocabulary);
        IndexWriterHelperUtil.updateDocument((String)this.getSearchEngineId(), (long)assetVocabulary.getCompanyId(), (Document)document, (boolean)this.isCommitImmediately());
    }

    protected void doReindex(String className, long classPK) throws Exception {
        AssetVocabulary vocabulary = AssetVocabularyLocalServiceUtil.getVocabulary((long)classPK);
        this.doReindex(vocabulary);
    }

    protected void doReindex(String[] ids) throws Exception {
        long companyId = GetterUtil.getLong((String)ids[0]);
        this.reindexVocabularies(companyId);
    }

    protected void reindexVocabularies(long companyId) throws PortalException {
        final IndexableActionableDynamicQuery indexableActionableDynamicQuery = AssetVocabularyLocalServiceUtil.getIndexableActionableDynamicQuery();
        indexableActionableDynamicQuery.setCompanyId(companyId);
        indexableActionableDynamicQuery.setPerformActionMethod((ActionableDynamicQuery.PerformActionMethod)new ActionableDynamicQuery.PerformActionMethod<AssetVocabulary>(){

            public void performAction(AssetVocabulary assetVocabulary) {
                block2: {
                    try {
                        Document document = AssetVocabularyIndexer.this.getDocument(assetVocabulary);
                        indexableActionableDynamicQuery.addDocuments(new Document[]{document});
                    }
                    catch (PortalException pe) {
                        if (!_log.isWarnEnabled()) break block2;
                        _log.warn((Object)("Unable to index asset vocabulary " + assetVocabulary.getVocabularyId()), (Throwable)pe);
                    }
                }
            }
        });
        indexableActionableDynamicQuery.setSearchEngineId(this.getSearchEngineId());
        indexableActionableDynamicQuery.performActions();
    }
}

