/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.portlet.PortletQName;
import com.liferay.portal.kernel.security.pacl.DoPrivileged;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xml.Namespace;
import com.liferay.portal.kernel.xml.QName;
import com.liferay.portal.kernel.xml.SAXReaderUtil;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

@DoPrivileged
public class PortletQNameImpl
implements PortletQName {
    private static final String _KEY_SEPARATOR = "_KEY_";
    private static final Log _log = LogFactoryUtil.getLog(PortletQNameImpl.class);
    private final Map<String, String> _identifiers = new ConcurrentHashMap<String, String>();
    private final Map<String, QName> _qNames = new ConcurrentHashMap<String, QName>();
    private final Map<QName, String> _qNameStrings = new ConcurrentHashMap<QName, String>();

    public String getKey(QName qName) {
        return this.getKey(qName.getNamespaceURI(), qName.getLocalPart());
    }

    public String getKey(String uri, String localPart) {
        return uri.concat(_KEY_SEPARATOR).concat(localPart);
    }

    public String getPublicRenderParameterIdentifier(String publicRenderParameterName) {
        if (!publicRenderParameterName.startsWith("p_r_p_") && !publicRenderParameterName.startsWith("r_p_r_p_")) {
            return null;
        }
        return this._identifiers.get(publicRenderParameterName);
    }

    public String getPublicRenderParameterName(QName qName) {
        String publicRenderParameterName = this._qNameStrings.get(qName);
        if (publicRenderParameterName == null) {
            publicRenderParameterName = this._toString("p_r_p_", qName);
            this._qNames.put(publicRenderParameterName, qName);
            this._qNameStrings.put(qName, publicRenderParameterName);
        }
        return publicRenderParameterName;
    }

    public QName getQName(Element qNameEl, Element nameEl, String defaultNamespace) {
        if (qNameEl == null && nameEl == null) {
            _log.error((Object)"both qname and name elements are null");
            return null;
        }
        if (qNameEl == null) {
            return SAXReaderUtil.createQName((String)nameEl.getTextTrim(), (Namespace)SAXReaderUtil.createNamespace((String)defaultNamespace));
        }
        String localPart = qNameEl.getTextTrim();
        int pos = localPart.indexOf(58);
        if (pos == -1) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("qname " + localPart + " does not have a prefix"));
            }
            return SAXReaderUtil.createQName((String)localPart);
        }
        String prefix = localPart.substring(0, pos);
        Namespace namespace = qNameEl.getNamespaceForPrefix(prefix);
        if (namespace == null) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)("qname " + localPart + " does not have a valid namespace"));
            }
            return null;
        }
        localPart = localPart.substring(prefix.length() + 1);
        return SAXReaderUtil.createQName((String)localPart, (Namespace)namespace);
    }

    public QName getQName(String publicRenderParameterName) {
        if (!publicRenderParameterName.startsWith("p_r_p_") && !publicRenderParameterName.startsWith("r_p_r_p_")) {
            return null;
        }
        return this._qNames.get(publicRenderParameterName);
    }

    public String getRemovePublicRenderParameterName(QName qName) {
        String removePublicRenderParameterName = this._qNameStrings.get(qName);
        if (removePublicRenderParameterName == null) {
            removePublicRenderParameterName = this._toString("r_p_r_p_", qName);
            this._qNames.put(removePublicRenderParameterName, qName);
            this._qNameStrings.put(qName, removePublicRenderParameterName);
        }
        return removePublicRenderParameterName;
    }

    public void setPublicRenderParameterIdentifier(String publicRenderParameterName, String identifier) {
        this._identifiers.put(publicRenderParameterName, identifier);
    }

    private String _toString(String prefix, QName qName) {
        String namespaceURI;
        StringBundler sb = new StringBundler(6);
        sb.append(prefix);
        String namespacePrefix = qName.getNamespacePrefix();
        if (!Validator.isBlank((String)namespacePrefix)) {
            sb.append(namespacePrefix);
            sb.append("_");
        }
        if (!Validator.isBlank((String)(namespaceURI = qName.getNamespaceURI()))) {
            sb.append(qName.getNamespaceURI());
            sb.append("_");
        }
        sb.append(qName.getLocalPart());
        return sb.toString();
    }
}

