/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.upgrade.v7_0_0;

import com.liferay.portal.kernel.configuration.Filter;
import com.liferay.portal.kernel.dao.jdbc.AutoBatchPreparedStatementUtil;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.LoggingTimer;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.util.PropsUtil;
import com.liferay.portal.util.PropsValues;
import java.sql.PreparedStatement;
import java.sql.ResultSet;

public class UpgradeRatings
extends UpgradeProcess {
    protected void doUpgrade() throws Exception {
        this.upgradeRatingsEntry();
        this.upgradeRatingsStats();
    }

    protected void upgradeRatingsEntry() throws Exception {
        try (LoggingTimer loggingTimer = new LoggingTimer();
             PreparedStatement ps = this.connection.prepareStatement("select distinct classNameId from RatingsEntry");
             ResultSet rs = ps.executeQuery();){
            while (rs.next()) {
                this.upgradeRatingsEntry(rs.getLong("classNameId"));
            }
        }
    }

    protected void upgradeRatingsEntry(long classNameId) throws Exception {
        String className = PortalUtil.getClassName((long)classNameId);
        if (ArrayUtil.contains((Object[])PropsValues.RATINGS_UPGRADE_THUMBS_CLASS_NAMES, (Object)className)) {
            this.upgradeRatingsEntryThumbs(classNameId);
        } else {
            int defaultRatingsStarsNormalizationFactor = GetterUtil.getInteger((String)PropsUtil.get("ratings.upgrade.stars.normalization.factor", new Filter("default")), (int)5);
            int ratingsStarsNormalizationFactor = GetterUtil.getInteger((String)PropsUtil.get("ratings.upgrade.stars.normalization.factor", new Filter(className)), (int)defaultRatingsStarsNormalizationFactor);
            this.upgradeRatingsEntryStars(classNameId, ratingsStarsNormalizationFactor);
        }
    }

    protected void upgradeRatingsEntryStars(long classNameId, int normalizationFactor) throws Exception {
        try (PreparedStatement ps = this.connection.prepareStatement("update RatingsEntry set score = score / ? where classNameId = ?");){
            ps.setInt(1, normalizationFactor);
            ps.setLong(2, classNameId);
            ps.executeUpdate();
        }
    }

    protected void upgradeRatingsEntryThumbs(long classNameId) throws Exception {
        try (PreparedStatement ps = this.connection.prepareStatement("update RatingsEntry set score = ? where score = ? and classNameId = ?");){
            ps.setDouble(1, 0.0);
            ps.setDouble(2, -1.0);
            ps.setLong(3, classNameId);
            ps.executeUpdate();
        }
    }

    protected void upgradeRatingsStats() throws Exception {
        try (LoggingTimer loggingTimer = new LoggingTimer();){
            StringBundler sb = new StringBundler(4);
            sb.append("select classNameId, classPK, count(1) as ");
            sb.append("totalEntries, sum(RatingsEntry.score) as totalScore, ");
            sb.append("sum(RatingsEntry.score) / count(1) as averageScore ");
            sb.append("from RatingsEntry group by classNameId, classPK");
            String selectSQL = sb.toString();
            String updateSQL = "update RatingsStats set totalEntries = ?, totalScore = ?, averageScore = ? where classNameId = ? and classPK = ?";
            try (PreparedStatement ps1 = this.connection.prepareStatement(selectSQL);
                 ResultSet rs = ps1.executeQuery();
                 PreparedStatement ps2 = AutoBatchPreparedStatementUtil.autoBatch((PreparedStatement)this.connection.prepareStatement(updateSQL));){
                while (rs.next()) {
                    ps2.setInt(1, rs.getInt("totalEntries"));
                    ps2.setDouble(2, rs.getDouble("totalScore"));
                    ps2.setDouble(3, rs.getDouble("averageScore"));
                    ps2.setLong(4, rs.getLong("classNameId"));
                    ps2.setLong(5, rs.getLong("classPK"));
                    ps2.addBatch();
                }
                ps2.executeBatch();
            }
        }
    }
}

