/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.upgrade.v6_1_0;

import com.liferay.portal.kernel.bean.PortalBeanLocatorUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.PermissionedModel;
import com.liferay.portal.kernel.model.ResourceBlock;
import com.liferay.portal.kernel.model.ResourceBlockPermissionsContainer;
import com.liferay.portal.kernel.model.ResourcePermission;
import com.liferay.portal.kernel.model.Role;
import com.liferay.portal.kernel.model.RoleWrapper;
import com.liferay.portal.kernel.security.permission.ResourceActionsUtil;
import com.liferay.portal.kernel.service.ResourceActionLocalServiceUtil;
import com.liferay.portal.kernel.service.ResourceBlockLocalServiceUtil;
import com.liferay.portal.kernel.service.ResourceLocalService;
import com.liferay.portal.kernel.service.ResourceLocalServiceWrapper;
import com.liferay.portal.kernel.service.ResourcePermissionLocalService;
import com.liferay.portal.kernel.service.ResourcePermissionLocalServiceUtil;
import com.liferay.portal.kernel.service.ResourcePermissionLocalServiceWrapper;
import com.liferay.portal.kernel.service.RoleLocalService;
import com.liferay.portal.kernel.service.RoleLocalServiceUtil;
import com.liferay.portal.kernel.service.RoleLocalServiceWrapper;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.LoggingTimer;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.spring.aop.ServiceWrapperProxyUtil;
import java.io.Closeable;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.List;

public class UpgradePermission
extends UpgradeProcess {
    private static final int[] _SCOPES = new int[]{1, 2, 3};
    private static final Log _log = LogFactoryUtil.getLog(UpgradePermission.class);

    protected ResourceBlock convertResourcePermissions(String tableName, String pkColumnName, long companyId, long groupId, String name, long primKey) {
        UpgradePermissionedModel permissionedModel = new UpgradePermissionedModel(tableName, pkColumnName, primKey);
        ResourceBlockPermissionsContainer resourceBlockPermissionsContainer = this.getResourceBlockPermissionsContainer(companyId, groupId, name, primKey);
        String permissionsHash = resourceBlockPermissionsContainer.getPermissionsHash();
        ResourceBlock resourceBlock = ResourceBlockLocalServiceUtil.updateResourceBlockId((long)companyId, (long)groupId, (String)name, (PermissionedModel)permissionedModel, (String)permissionsHash, (ResourceBlockPermissionsContainer)resourceBlockPermissionsContainer);
        return resourceBlock;
    }

    protected void convertResourcePermissions(String name, String tableName, String pkColumnName) throws Exception {
        try (LoggingTimer loggingTimer = new LoggingTimer(name);){
            PreparedStatement ps = this.connection.prepareStatement("select " + pkColumnName + ", groupId, companyId from " + tableName);
            Object object = null;
            try (ResultSet rs2 = ps.executeQuery();){
                while (rs2.next()) {
                    long primKey = rs2.getLong(pkColumnName);
                    long groupId = rs2.getLong("groupId");
                    long companyId = rs2.getLong("companyId");
                    ResourceBlock resourceBlock = this.convertResourcePermissions(tableName, pkColumnName, companyId, groupId, name, primKey);
                    if (!_log.isInfoEnabled() || resourceBlock.getResourceBlockId() % 100L != 0L) continue;
                    _log.info((Object)("Processed 100 resource blocks for " + name));
                }
            }
            catch (Throwable rs2) {
                object = rs2;
                throw rs2;
            }
            finally {
                if (ps != null) {
                    if (object != null) {
                        try {
                            ps.close();
                        }
                        catch (Throwable rs2) {
                            ((Throwable)object).addSuppressed(rs2);
                        }
                    } else {
                        ps.close();
                    }
                }
            }
            List resourcePermissions = ResourcePermissionLocalServiceUtil.getScopeResourcePermissions((int[])_SCOPES);
            for (ResourcePermission resourcePermission : resourcePermissions) {
                int scope = resourcePermission.getScope();
                if (!name.equals(resourcePermission.getName())) continue;
                if (scope == 1 || scope == 3) {
                    ResourceBlockLocalServiceUtil.setCompanyScopePermissions((long)resourcePermission.getCompanyId(), (String)name, (long)resourcePermission.getRoleId(), (long)resourcePermission.getActionIds());
                    continue;
                }
                if (scope != 2) continue;
                ResourceBlockLocalServiceUtil.setGroupScopePermissions((long)resourcePermission.getCompanyId(), (long)GetterUtil.getLong((String)resourcePermission.getPrimKey()), (String)name, (long)resourcePermission.getRoleId(), (long)resourcePermission.getActionIds());
            }
        }
    }

    protected void doUpgrade() throws Exception {
        try (Closeable closeable1 = ServiceWrapperProxyUtil.createProxy(PortalBeanLocatorUtil.locate((String)ResourceLocalService.class.getName()), Pre7ResourceLocalServiceImpl.class);
             Closeable closeable2 = ServiceWrapperProxyUtil.createProxy(PortalBeanLocatorUtil.locate((String)ResourcePermissionLocalService.class.getName()), Pre7ResourcePermissionLocalServiceImpl.class);
             Closeable closeable3 = ServiceWrapperProxyUtil.createProxy(PortalBeanLocatorUtil.locate((String)RoleLocalService.class.getName()), Pre7RoleLocalServiceImpl.class);){
            Class<?> upgradePermissionClass = ((Object)((Object)this)).getClass();
            ResourceActionsUtil.readAndCheck(null, (ClassLoader)upgradePermissionClass.getClassLoader(), (String[])new String[]{"com/liferay/portal/upgrade/v6_1_0/dependencies/resource-actions.xml"});
            RoleLocalServiceUtil.checkSystemRoles();
            this.updatePermissions("com.liferay.portlet.bookmarks", true, true);
            this.updatePermissions("com.liferay.portlet.documentlibrary", false, true);
            this.updatePermissions("com.liferay.portlet.imagegallery", true, true);
            this.updatePermissions("com.liferay.portlet.messageboards", true, true);
            this.updatePermissions("com.liferay.portlet.shopping", true, true);
            this.convertResourcePermissions("com.liferay.portlet.bookmarks.model.BookmarksEntry", "BookmarksEntry", "entryId");
            this.convertResourcePermissions("com.liferay.portlet.bookmarks.model.BookmarksFolder", "BookmarksFolder", "folderId");
        }
    }

    protected ResourceBlockPermissionsContainer getResourceBlockPermissionsContainer(long companyId, long groupId, String name, long primKey) {
        ResourceBlockPermissionsContainer resourceBlockPermissionContainer = new ResourceBlockPermissionsContainer();
        List resourcePermissions = ResourcePermissionLocalServiceUtil.getResourceResourcePermissions((long)companyId, (long)groupId, (String)name, (String)String.valueOf(primKey));
        for (ResourcePermission resourcePermission : resourcePermissions) {
            resourceBlockPermissionContainer.addPermission(resourcePermission.getRoleId(), resourcePermission.getActionIds());
        }
        return resourceBlockPermissionContainer;
    }

    protected void updatePermissions(String name, boolean community, boolean guest) throws Exception {
        try (LoggingTimer loggingTimer = new LoggingTimer(name);){
            List modelActions = ResourceActionsUtil.getModelResourceActions((String)name);
            ResourceActionLocalServiceUtil.checkResourceActions((String)name, (List)modelActions);
            int scope = 4;
            long actionIdsLong = 1L;
            if (community) {
                ResourcePermissionLocalServiceUtil.addResourcePermissions((String)name, (String)"Organization User", (int)scope, (long)actionIdsLong);
                ResourcePermissionLocalServiceUtil.addResourcePermissions((String)name, (String)"Site Member", (int)scope, (long)actionIdsLong);
            }
            if (guest) {
                ResourcePermissionLocalServiceUtil.addResourcePermissions((String)name, (String)"Guest", (int)scope, (long)actionIdsLong);
            }
            ResourcePermissionLocalServiceUtil.addResourcePermissions((String)name, (String)"Owner", (int)scope, (long)actionIdsLong);
        }
    }

    private class UpgradePermissionedModel
    implements PermissionedModel {
        private final String _pkColumnName;
        private final long _primKey;
        private long _resourceBlockId;
        private final String _tableName;

        public UpgradePermissionedModel(String tableName, String pkColumnName, long primKey) {
            this._tableName = tableName;
            this._pkColumnName = pkColumnName;
            this._primKey = primKey;
        }

        public long getResourceBlockId() {
            return this._resourceBlockId;
        }

        public void persist() {
            try {
                StringBundler sb = new StringBundler(8);
                sb.append("update ");
                sb.append(this._tableName);
                sb.append(" set resourceBlockId = ");
                sb.append(this._resourceBlockId);
                sb.append(" where ");
                sb.append(this._pkColumnName);
                sb.append(" = ");
                sb.append(this._primKey);
                UpgradePermission.this.runSQL(sb.toString());
            }
            catch (Exception e) {
                throw new SystemException((Throwable)e);
            }
        }

        public void setResourceBlockId(long resourceBlockId) {
            this._resourceBlockId = resourceBlockId;
        }
    }

    private static class Pre7RoleLocalServiceImpl
    extends RoleLocalServiceWrapper {
        public Role deleteRole(Role role) throws PortalException {
            String className = role.getClassName();
            if (className.equals(Role.class.getName())) {
                return new RoleWrapper(role){

                    public String getClassName() {
                        String className = super.getClassName();
                        if (className.equals(Role.class.getName())) {
                            className = "com.liferay.portal.model.Role";
                        }
                        return className;
                    }
                };
            }
            return super.deleteRole(role);
        }

        private Pre7RoleLocalServiceImpl(RoleLocalService roleLocalService) {
            super(roleLocalService);
        }
    }

    private static class Pre7ResourcePermissionLocalServiceImpl
    extends ResourcePermissionLocalServiceWrapper {
        public void setResourcePermissions(long companyId, String name, int scope, String primKey, long roleId, String[] actionIds) throws PortalException {
            if (name.equals(Role.class.getName())) {
                name = "com.liferay.portal.model.Role";
            }
            super.setResourcePermissions(companyId, name, scope, primKey, roleId, actionIds);
        }

        private Pre7ResourcePermissionLocalServiceImpl(ResourcePermissionLocalService resourcePermissionLocalService) {
            super(resourcePermissionLocalService);
        }
    }

    private static class Pre7ResourceLocalServiceImpl
    extends ResourceLocalServiceWrapper {
        public void addResources(long companyId, long groupId, long userId, String name, long primKey, boolean portletActions, boolean addGroupPermissions, boolean addGuestPermissions) throws PortalException {
            if (name.equals(Role.class.getName())) {
                name = "com.liferay.portal.model.Role";
            }
            super.addResources(companyId, groupId, userId, name, primKey, portletActions, addGroupPermissions, addGuestPermissions);
        }

        private Pre7ResourceLocalServiceImpl(ResourceLocalService resourceLocalService) {
            super(resourceLocalService);
        }
    }
}

