/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.upgrade.util;

import com.liferay.portal.dao.jdbc.postgresql.PostgreSQLJDBCUtil;
import com.liferay.portal.kernel.dao.db.DB;
import com.liferay.portal.kernel.dao.db.DBManagerUtil;
import com.liferay.portal.kernel.dao.db.DBType;
import com.liferay.portal.kernel.dao.jdbc.AutoBatchPreparedStatementUtil;
import com.liferay.portal.kernel.dao.jdbc.DataAccess;
import com.liferay.portal.kernel.io.unsync.UnsyncBufferedReader;
import com.liferay.portal.kernel.io.unsync.UnsyncBufferedWriter;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.upgrade.StagnantRowException;
import com.liferay.portal.kernel.upgrade.UpgradeException;
import com.liferay.portal.kernel.util.Base64;
import com.liferay.portal.kernel.util.DateUtil;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.SystemProperties;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.uuid.PortalUUIDUtil;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.util.Date;
import org.apache.commons.lang.time.StopWatch;

public class Table {
    private static final String[][] _SAFE_TABLE_CHARS = new String[][]{{",", "\n", "\r"}, {"_SAFE_TABLE_COMMA_CHARACTER_", "_SAFE_TABLE_NEWLINE_CHARACTER_", "_SAFE_TABLE_RETURN_CHARACTER_"}};
    private static final String _SAFE_TABLE_COMMA_CHARACTER = "_SAFE_TABLE_COMMA_CHARACTER_";
    private static final String _SAFE_TABLE_NEWLINE_CHARACTER = "_SAFE_TABLE_NEWLINE_CHARACTER_";
    private static final String _SAFE_TABLE_RETURN_CHARACTER = "_SAFE_TABLE_RETURN_CHARACTER_";
    private static final Log _log = LogFactoryUtil.getLog(Table.class);
    private Object[][] _columns;
    private String _createSQL;
    private int[] _order;
    private String _selectSQL;
    private final String _tableName;
    private String _tempFileName;
    private long _totalRows;

    public Table(String tableName) {
        this._tableName = tableName;
    }

    public Table(String tableName, Object[][] columns) {
        this._tableName = tableName;
        this.setColumns(columns);
    }

    public void appendColumn(StringBuilder sb, Object value, boolean last) throws Exception {
        if (value == null) {
            throw new UpgradeException("Nulls should never be inserted into the database. Attempted to append column to " + sb.toString() + ".");
        }
        if (value instanceof byte[]) {
            sb.append(Base64.encode((byte[])((byte[])value)));
        } else if (value instanceof Clob || value instanceof String) {
            value = StringUtil.replace((String)((String)value), (String[])_SAFE_TABLE_CHARS[0], (String[])_SAFE_TABLE_CHARS[1]);
            sb.append(value);
        } else if (value instanceof Date) {
            DateFormat df = DateUtil.getISOFormat();
            sb.append(df.format(value));
        } else {
            sb.append(value);
        }
        sb.append(",");
        if (last) {
            sb.append("\n");
        }
    }

    public void appendColumn(StringBuilder sb, ResultSet rs, String name, Integer type, boolean last) throws Exception {
        Object value = null;
        try {
            value = this.getValue(rs, name, type);
        }
        catch (SQLException sqle) {
            if (name.equals("uuid_")) {
                sb.append(PortalUUIDUtil.generate());
            }
            sb.append(",");
            if (last) {
                sb.append("\n");
            }
            return;
        }
        this.appendColumn(sb, value, last);
    }

    public void generateTempFile() throws Exception {
        Connection con = DataAccess.getUpgradeOptimizedConnection();
        try {
            this.generateTempFile(con);
        }
        finally {
            DataAccess.cleanUp((Connection)con);
        }
    }

    public void generateTempFile(Connection con) throws Exception {
        PreparedStatement ps = null;
        ResultSet rs = null;
        boolean empty = true;
        Path tempFilePath = Files.createTempFile(Paths.get(SystemProperties.get((String)"java.io.tmpdir"), new String[0]), "temp-db-" + this._tableName + "-", null, new FileAttribute[0]);
        String tempFileName = tempFilePath.toString();
        StopWatch stopWatch = new StopWatch();
        stopWatch.start();
        if (_log.isInfoEnabled()) {
            _log.info((Object)("Starting backup of " + this._tableName + " to " + tempFileName));
        }
        UnsyncBufferedWriter unsyncBufferedWriter = new UnsyncBufferedWriter((Writer)new FileWriter(tempFileName));
        try {
            ps = this.getSelectPreparedStatement(con);
            rs = ps.executeQuery();
            while (rs.next()) {
                String data = null;
                try {
                    data = this.getExportedData(rs);
                    unsyncBufferedWriter.write(data);
                    ++this._totalRows;
                    empty = false;
                }
                catch (StagnantRowException sre) {
                    if (!_log.isWarnEnabled()) continue;
                    _log.warn((Object)("Skipping stagnant data in " + this._tableName + ": " + sre.getMessage()));
                }
            }
            if (_log.isInfoEnabled()) {
                _log.info((Object)("Finished backup of " + this._tableName + " to " + tempFileName + " in " + stopWatch.getTime() + " ms"));
            }
        }
        catch (Exception e) {
            try {
                FileUtil.delete((String)tempFileName);
                throw e;
            }
            catch (Throwable throwable) {
                DataAccess.cleanUp((Statement)ps, rs);
                unsyncBufferedWriter.close();
                throw throwable;
            }
        }
        DataAccess.cleanUp((Statement)ps, (ResultSet)rs);
        unsyncBufferedWriter.close();
        if (!empty) {
            this._tempFileName = tempFileName;
            return;
        }
        FileUtil.delete((String)tempFileName);
    }

    public Object[][] getColumns() {
        return this._columns;
    }

    public String getCreateSQL() throws Exception {
        return this._createSQL;
    }

    public String getDeleteSQL() throws Exception {
        return "DELETE FROM " + this._tableName;
    }

    public String getExportedData(ResultSet rs) throws Exception {
        StringBuilder sb = new StringBuilder();
        Object[][] columns = this.getColumns();
        for (int i = 0; i < columns.length; ++i) {
            boolean last = false;
            if (i + 1 == columns.length) {
                last = true;
            }
            this.appendColumn(sb, rs, (String)columns[i][0], (Integer)columns[i][1], last);
        }
        return sb.toString();
    }

    public String getInsertSQL() throws Exception {
        int i;
        String sql = "INSERT INTO " + this.getInsertTableName() + " (";
        for (i = 0; i < this._order.length; ++i) {
            int pos = this._order[i];
            sql = sql + this._columns[pos][0];
            sql = i + 1 < this._columns.length ? sql + ", " : sql + ") VALUES (";
        }
        for (i = 0; i < this._columns.length; ++i) {
            sql = sql + "?";
            sql = i + 1 < this._columns.length ? sql + ", " : sql + ")";
        }
        return sql;
    }

    public String getInsertTableName() throws Exception {
        String createSQL = this.getCreateSQL();
        if (Validator.isNotNull((String)createSQL)) {
            String createSQLLowerCase = StringUtil.toLowerCase((String)createSQL);
            int x = createSQLLowerCase.indexOf("create table ");
            if (x == -1) {
                return this._tableName;
            }
            int y = createSQL.indexOf(" ", x += 13);
            return createSQL.substring(x, y).trim();
        }
        return this._tableName;
    }

    public int[] getOrder() {
        return this._order;
    }

    public PreparedStatement getSelectPreparedStatement(Connection con) throws Exception {
        return con.prepareStatement(this.getSelectSQL());
    }

    public String getSelectSQL() throws Exception {
        if (this._selectSQL == null) {
            return "select * from " + this._tableName;
        }
        return this._selectSQL;
    }

    public String getTableName() {
        return this._tableName;
    }

    public String getTempFileName() {
        return this._tempFileName;
    }

    public long getTotalRows() {
        return this._totalRows;
    }

    public Object getValue(ResultSet rs, String name, Integer type) throws Exception {
        Object value;
        block63: {
            value = null;
            int t = type;
            if (t == -5) {
                try {
                    value = GetterUtil.getLong((Object)rs.getLong(name));
                }
                catch (SQLException sqle) {
                    value = GetterUtil.getLong((String)rs.getString(name));
                }
            } else if (t == -7) {
                value = GetterUtil.getBoolean((Object)rs.getBoolean(name));
            } else if (t == 2004 || t == -4) {
                DB db = DBManagerUtil.getDB();
                DBType dbType = db.getDBType();
                value = dbType.equals((Object)DBType.POSTGRESQL) && PostgreSQLJDBCUtil.isPGStatement(rs.getStatement()) ? (Object)PostgreSQLJDBCUtil.getLargeObject(rs, name) : (Object)rs.getBytes(name);
                if (value == null) {
                    value = new byte[0];
                }
            } else if (t == 16) {
                value = GetterUtil.getBoolean((Object)rs.getBoolean(name));
            } else if (t == 2005) {
                try {
                    Clob clob = rs.getClob(name);
                    if (clob == null) {
                        value = "";
                        break block63;
                    }
                    try (Reader reader = clob.getCharacterStream();
                         UnsyncBufferedReader unsyncBufferedReader = new UnsyncBufferedReader(reader);){
                        StringBundler sb = new StringBundler();
                        String line = null;
                        while ((line = unsyncBufferedReader.readLine()) != null) {
                            if (sb.length() != 0) {
                                sb.append(_SAFE_TABLE_NEWLINE_CHARACTER);
                            }
                            sb.append(line);
                        }
                        value = sb.toString();
                    }
                }
                catch (Exception e) {
                    value = GetterUtil.getString((String)rs.getString(name));
                }
            } else if (t == 8) {
                value = GetterUtil.getDouble((Object)rs.getDouble(name));
            } else if (t == 6) {
                value = Float.valueOf(GetterUtil.getFloat((Object)Float.valueOf(rs.getFloat(name))));
            } else if (t == 4) {
                value = GetterUtil.getInteger((Object)rs.getInt(name));
            } else if (t == -1) {
                value = GetterUtil.getString((String)rs.getString(name));
            } else if (t == 2) {
                value = GetterUtil.getLong((Object)rs.getLong(name));
            } else if (t == 5) {
                value = GetterUtil.getShort((Object)rs.getShort(name));
            } else if (t == 93) {
                try {
                    value = rs.getTimestamp(name);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (value == null) {
                    value = "null";
                }
            } else if (t == -6) {
                value = GetterUtil.getShort((Object)rs.getShort(name));
            } else if (t == 12) {
                value = GetterUtil.getString((String)rs.getString(name));
            } else {
                throw new UpgradeException("Upgrade code using unsupported class type " + type);
            }
        }
        return value;
    }

    public void populateTable() throws Exception {
        Connection con = DataAccess.getUpgradeOptimizedConnection();
        try {
            this.populateTable(con);
        }
        finally {
            DataAccess.cleanUp((Connection)con);
        }
    }

    public void populateTable(Connection con) throws Exception {
        if (this._tempFileName == null) {
            return;
        }
        try (PreparedStatement ps = AutoBatchPreparedStatementUtil.autoBatch((PreparedStatement)con.prepareStatement(this.getInsertSQL()));
             UnsyncBufferedReader unsyncBufferedReader = new UnsyncBufferedReader((Reader)new FileReader(this._tempFileName));){
            String line = null;
            while ((line = unsyncBufferedReader.readLine()) != null) {
                Object[][] columns;
                String[] values = StringUtil.split((String)line);
                if (values.length != (columns = this.getColumns()).length) {
                    throw new UpgradeException("Column lengths differ between temp file and schema. Attempted to insert row " + line + ".");
                }
                int[] order = this.getOrder();
                for (int i = 0; i < order.length; ++i) {
                    int pos = order[i];
                    this.setColumn(ps, i, (Integer)columns[pos][1], values[pos]);
                }
                ps.addBatch();
            }
            ps.executeBatch();
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)(this.getTableName() + " table populated with data"));
        }
    }

    public void populateTableRows(PreparedStatement ps, boolean batch) throws Exception {
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Updating rows for " + this.getTableName()));
        }
        if (batch) {
            ps.executeBatch();
        } else {
            ps.executeUpdate();
        }
        ps.close();
    }

    public void setColumn(PreparedStatement ps, int index, Integer type, String value) throws Exception {
        int t = type;
        int paramIndex = index + 1;
        if (t == -5) {
            ps.setLong(paramIndex, GetterUtil.getLong((String)value));
        } else if (t == 2004 || t == -4) {
            if (PostgreSQLJDBCUtil.isPGStatement(ps)) {
                PostgreSQLJDBCUtil.setLargeObject(ps, paramIndex, Base64.decode((String)value));
            } else {
                ps.setBytes(paramIndex, Base64.decode((String)value));
            }
        } else if (t == 16) {
            ps.setBoolean(paramIndex, GetterUtil.getBoolean((String)value));
        } else if (t == 2005 || t == -1 || t == 12) {
            value = StringUtil.replace((String)value, (String[])_SAFE_TABLE_CHARS[1], (String[])_SAFE_TABLE_CHARS[0]);
            ps.setString(paramIndex, value);
        } else if (t == 8) {
            ps.setDouble(paramIndex, GetterUtil.getDouble((String)value));
        } else if (t == 6) {
            ps.setFloat(paramIndex, GetterUtil.getFloat((String)value));
        } else if (t == 4) {
            ps.setInt(paramIndex, GetterUtil.getInteger((String)value));
        } else if (t == 5) {
            ps.setShort(paramIndex, GetterUtil.getShort((String)value));
        } else if (t == 93) {
            if ("null".equals(value)) {
                ps.setTimestamp(paramIndex, null);
            } else {
                DateFormat df = DateUtil.getISOFormat();
                ps.setTimestamp(paramIndex, new Timestamp(df.parse(value).getTime()));
            }
        } else if (t == -6) {
            ps.setShort(paramIndex, GetterUtil.getShort((String)value));
        } else {
            throw new UpgradeException("Upgrade code using unsupported class type " + type);
        }
    }

    public void setColumns(Object[][] columns) {
        this._columns = columns;
        this._order = new int[this._columns.length];
        int clobCount = 0;
        for (int i = 0; i < this._columns.length; ++i) {
            int pos;
            Integer type = (Integer)columns[i][1];
            if (type == 2005) {
                pos = this._columns.length - ++clobCount;
                this._order[pos] = i;
                continue;
            }
            pos = i - clobCount;
            this._order[pos] = i;
        }
    }

    public void setCreateSQL(String createSQL) throws Exception {
        this._createSQL = createSQL;
    }

    public void setSelectSQL(String selectSQL) throws Exception {
        this._selectSQL = selectSQL;
    }

    public void updateColumnValue(String columnName, String oldValue, String newValue) {
        Connection con = null;
        PreparedStatement ps = null;
        StringBundler sb = new StringBundler(7);
        sb.append("update ");
        sb.append(this._tableName);
        sb.append(" set ");
        sb.append(columnName);
        sb.append(" = ? where ");
        sb.append(columnName);
        sb.append(" = ?");
        String sql = sb.toString();
        try {
            con = DataAccess.getUpgradeOptimizedConnection();
            ps = con.prepareStatement(sql);
            ps.setString(1, newValue);
            ps.setString(2, oldValue);
            ps.executeUpdate();
        }
        catch (SQLException sqle) {
            try {
                _log.error((Object)sqle, (Throwable)sqle);
                throw new RuntimeException("Unable to execute " + sql, sqle);
            }
            catch (Throwable throwable) {
                DataAccess.cleanUp((Connection)con, ps);
                throw throwable;
            }
        }
        DataAccess.cleanUp((Connection)con, (Statement)ps);
    }
}

