/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.convert.documentlibrary;

import com.liferay.document.library.kernel.model.DLFileEntry;
import com.liferay.document.library.kernel.service.DLFileEntryLocalServiceUtil;
import com.liferay.document.library.kernel.store.Store;
import com.liferay.document.library.kernel.util.DLPreviewableProcessor;
import com.liferay.document.library.kernel.util.comparator.FileVersionVersionComparator;
import com.liferay.portal.convert.BaseConvertProcess;
import com.liferay.portal.convert.documentlibrary.DLStoreConvertProcess;
import com.liferay.portal.convert.documentlibrary.DLStoreConverter;
import com.liferay.portal.kernel.dao.orm.ActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.DynamicQuery;
import com.liferay.portal.kernel.dao.orm.Property;
import com.liferay.portal.kernel.dao.orm.PropertyFactoryUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Image;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.repository.model.FileVersion;
import com.liferay.portal.kernel.service.ImageLocalServiceUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.repository.liferayrepository.model.LiferayFileEntry;
import com.liferay.portal.util.MaintenanceUtil;
import com.liferay.portal.util.PropsValues;
import com.liferay.portlet.documentlibrary.store.StoreFactory;
import com.liferay.registry.Registry;
import com.liferay.registry.RegistryUtil;
import java.io.InputStream;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;

public class DocumentLibraryConvertProcess
extends BaseConvertProcess
implements DLStoreConverter {
    private static final String _FILE_SYSTEM_STORE_SUFFIX = "FileSystemStore";
    private static final Log _log = LogFactoryUtil.getLog(DocumentLibraryConvertProcess.class);
    private Store _sourceStore;
    private Store _targetStore;

    @Override
    public String getConfigurationErrorMessage() {
        return "there-are-no-stores-configured";
    }

    @Override
    public String getDescription() {
        return "migrate-documents-from-one-repository-to-another";
    }

    @Override
    public String getParameterDescription() {
        return "please-select-a-new-repository-hook";
    }

    @Override
    public String[] getParameterNames() {
        StoreFactory storeFactory = StoreFactory.getInstance();
        Store store = storeFactory.getStore();
        if (store == null) {
            return null;
        }
        String[] storeTypes = storeFactory.getStoreTypes();
        StringBundler sb = new StringBundler(storeTypes.length * 2 + 2);
        sb.append("dl.store.impl");
        sb.append("=");
        for (String storeType : storeTypes) {
            Class<?> clazz = store.getClass();
            if (storeType.equals(clazz.getName())) continue;
            sb.append(storeType);
            sb.append(";");
        }
        return new String[]{sb.toString(), "delete-files-from-previous-repository=checkbox"};
    }

    @Override
    public boolean isEnabled() {
        return true;
    }

    @Override
    public void migrateDLFileEntry(long companyId, long repositoryId, FileEntry fileEntry) {
        Object model = fileEntry.getModel();
        if (!(model instanceof DLFileEntry)) {
            throw new IllegalArgumentException("Unsupported file entry model " + model.getClass());
        }
        String fileName = ((DLFileEntry)model).getName();
        List<FileVersion> fileVersions = this.getFileVersions(fileEntry);
        if (fileVersions.isEmpty()) {
            String versionNumber = "1.0";
            this.migrateFile(companyId, repositoryId, fileName, versionNumber);
            return;
        }
        for (FileVersion fileVersion : fileVersions) {
            String versionNumber = fileVersion.getVersion();
            this.migrateFile(companyId, repositoryId, fileName, versionNumber);
        }
    }

    @Override
    public void validate() {
        String sourceStoreClassName = this.getSourceStoreClassName();
        if (!sourceStoreClassName.endsWith(_FILE_SYSTEM_STORE_SUFFIX)) {
            return;
        }
        String targetStoreClassName = this.getTargetStoreClassName();
        if (!targetStoreClassName.endsWith(_FILE_SYSTEM_STORE_SUFFIX)) {
            return;
        }
    }

    @Override
    protected void doConvert() throws Exception {
        StoreFactory storeFactory = StoreFactory.getInstance();
        this._sourceStore = storeFactory.getStore();
        String targetStoreClassName = this.getTargetStoreClassName();
        this._targetStore = storeFactory.getStore(targetStoreClassName);
        this.migratePortlets();
        storeFactory.setStore(targetStoreClassName);
        MaintenanceUtil.appendStatus("Please set dl.store.impl in your portal-ext.properties to use " + targetStoreClassName);
        PropsValues.DL_STORE_IMPL = targetStoreClassName;
    }

    protected List<FileVersion> getFileVersions(FileEntry fileEntry) {
        List fileVersions = fileEntry.getFileVersions(-1);
        return ListUtil.sort((List)fileVersions, (Comparator)new FileVersionVersionComparator(true));
    }

    protected String getSourceStoreClassName() {
        StoreFactory storeFactory = StoreFactory.getInstance();
        Store sourceStore = storeFactory.getStore();
        Class<?> clazz = sourceStore.getClass();
        return clazz.getName();
    }

    protected String getTargetStoreClassName() {
        String[] values = this.getParameterValues();
        return values[0];
    }

    protected boolean isDeleteFilesFromSourceStore() {
        String[] values = this.getParameterValues();
        return GetterUtil.getBoolean((String)values[1]);
    }

    protected void migrateDL() throws PortalException {
        int count = DLFileEntryLocalServiceUtil.getFileEntriesCount();
        MaintenanceUtil.appendStatus("Migrating " + count + " documents and media files");
        ActionableDynamicQuery actionableDynamicQuery = DLFileEntryLocalServiceUtil.getActionableDynamicQuery();
        actionableDynamicQuery.setAddCriteriaMethod(new ActionableDynamicQuery.AddCriteriaMethod(){

            public void addCriteria(DynamicQuery dynamicQuery) {
                Property classNameIdProperty = PropertyFactoryUtil.forName((String)"classNameId");
                dynamicQuery.add(classNameIdProperty.eq((Object)0L));
            }
        });
        actionableDynamicQuery.setPerformActionMethod((ActionableDynamicQuery.PerformActionMethod)new ActionableDynamicQuery.PerformActionMethod<DLFileEntry>(){

            public void performAction(DLFileEntry dlFileEntry) {
                DocumentLibraryConvertProcess.this.migrateDLFileEntry(dlFileEntry.getCompanyId(), dlFileEntry.getDataRepositoryId(), new LiferayFileEntry(dlFileEntry));
            }
        });
        actionableDynamicQuery.performActions();
        if (this.isDeleteFilesFromSourceStore()) {
            DLPreviewableProcessor.deleteFiles();
        }
    }

    protected void migrateFile(long companyId, long repositoryId, String fileName, String versionNumber) {
        try {
            InputStream is = this._sourceStore.getFileAsStream(companyId, repositoryId, fileName, versionNumber);
            if (versionNumber.equals("1.0")) {
                this._targetStore.addFile(companyId, repositoryId, fileName, is);
            } else {
                this._targetStore.updateFile(companyId, repositoryId, fileName, versionNumber, is);
            }
            if (this.isDeleteFilesFromSourceStore()) {
                this._sourceStore.deleteFile(companyId, repositoryId, fileName, versionNumber);
            }
        }
        catch (Exception e) {
            _log.error((Object)("Migration failed for " + fileName), (Throwable)e);
        }
    }

    protected void migrateImages() throws PortalException {
        int count = ImageLocalServiceUtil.getImagesCount();
        MaintenanceUtil.appendStatus("Migrating " + count + " images");
        ActionableDynamicQuery actionableDynamicQuery = ImageLocalServiceUtil.getActionableDynamicQuery();
        actionableDynamicQuery.setPerformActionMethod((ActionableDynamicQuery.PerformActionMethod)new ActionableDynamicQuery.PerformActionMethod<Image>(){

            public void performAction(Image image) {
                String fileName = image.getImageId() + "." + image.getType();
                DocumentLibraryConvertProcess.this.migrateFile(0L, 0L, fileName, "1.0");
            }
        });
        actionableDynamicQuery.performActions();
    }

    protected void migratePortlets() throws Exception {
        this.migrateImages();
        this.migrateDL();
        Collection<DLStoreConvertProcess> dlStoreConvertProcesses = this._getDLStoreConvertProcesses();
        for (DLStoreConvertProcess dlStoreConvertProcess : dlStoreConvertProcesses) {
            dlStoreConvertProcess.migrate(this);
        }
    }

    private Collection<DLStoreConvertProcess> _getDLStoreConvertProcesses() {
        try {
            Registry registry = RegistryUtil.getRegistry();
            return registry.getServices(DLStoreConvertProcess.class, null);
        }
        catch (Exception e) {
            throw new SystemException((Throwable)e);
        }
    }
}

