/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.blogs.service.persistence.impl;

import com.liferay.blogs.kernel.model.BlogsEntry;
import com.liferay.blogs.kernel.service.persistence.BlogsEntryFinder;
import com.liferay.portal.kernel.dao.orm.Dialect;
import com.liferay.portal.kernel.dao.orm.Query;
import com.liferay.portal.kernel.dao.orm.QueryDefinition;
import com.liferay.portal.kernel.dao.orm.QueryPos;
import com.liferay.portal.kernel.dao.orm.QueryUtil;
import com.liferay.portal.kernel.dao.orm.SQLQuery;
import com.liferay.portal.kernel.dao.orm.Session;
import com.liferay.portal.kernel.dao.orm.Type;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.util.CalendarUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portlet.blogs.model.impl.BlogsEntryImpl;
import com.liferay.portlet.blogs.service.persistence.impl.BlogsEntryFinderBaseImpl;
import com.liferay.util.dao.orm.CustomSQLUtil;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;

public class BlogsEntryFinderImpl
extends BlogsEntryFinderBaseImpl
implements BlogsEntryFinder {
    public static final String COUNT_BY_ORGANIZATION_IDS = BlogsEntryFinder.class.getName() + ".countByOrganizationIds";
    public static final String FIND_BY_GROUP_IDS = BlogsEntryFinder.class.getName() + ".findByGroupIds";
    public static final String FIND_BY_ORGANIZATION_IDS = BlogsEntryFinder.class.getName() + ".findByOrganizationIds";
    public static final String FIND_BY_NO_ASSETS = BlogsEntryFinder.class.getName() + ".findByNoAssets";

    public int countByOrganizationId(long organizationId, Date displayDate, QueryDefinition<BlogsEntry> queryDefinition) {
        ArrayList<Long> organizationIds = new ArrayList<Long>();
        organizationIds.add(organizationId);
        return this.countByOrganizationIds(organizationIds, displayDate, queryDefinition);
    }

    public int countByOrganizationIds(List<Long> organizationIds, Date displayDate, QueryDefinition<BlogsEntry> queryDefinition) {
        Timestamp displayDate_TS = CalendarUtil.getTimestamp((Date)displayDate);
        Session session = null;
        try {
            Long count;
            Iterator itr;
            session = this.openSession();
            String sql = CustomSQLUtil.get((String)COUNT_BY_ORGANIZATION_IDS);
            if (queryDefinition.getStatus() != -1) {
                sql = queryDefinition.isExcludeStatus() ? CustomSQLUtil.appendCriteria((String)sql, (String)"AND (BlogsEntry.status != ?)") : CustomSQLUtil.appendCriteria((String)sql, (String)"AND (BlogsEntry.status = ?)");
            }
            sql = StringUtil.replace((String)sql, (String)"[$ORGANIZATION_ID$]", (String)this.getOrganizationIds(organizationIds));
            SQLQuery q = session.createSynchronizedSQLQuery(sql);
            q.addScalar("COUNT_VALUE", Type.LONG);
            QueryPos qPos = QueryPos.getInstance((Query)q);
            for (int i = 0; i < organizationIds.size(); ++i) {
                Long organizationId = organizationIds.get(i);
                qPos.add(organizationId);
            }
            qPos.add(displayDate_TS);
            if (queryDefinition.getStatus() != -1) {
                qPos.add(queryDefinition.getStatus());
            }
            if ((itr = q.iterate()).hasNext() && (count = (Long)itr.next()) != null) {
                int n = count.intValue();
                return n;
            }
            int n = 0;
            return n;
        }
        catch (Exception e) {
            throw new SystemException((Throwable)e);
        }
        finally {
            this.closeSession(session);
        }
    }

    public List<BlogsEntry> findByGroupIds(long companyId, long groupId, Date displayDate, QueryDefinition<BlogsEntry> queryDefinition) {
        Session session = null;
        try {
            session = this.openSession();
            String sql = CustomSQLUtil.get((String)FIND_BY_GROUP_IDS);
            if (queryDefinition.getStatus() != -1) {
                sql = queryDefinition.isExcludeStatus() ? CustomSQLUtil.appendCriteria((String)sql, (String)"AND (BlogsEntry.status != ?)") : CustomSQLUtil.appendCriteria((String)sql, (String)"AND (BlogsEntry.status = ?)");
            }
            SQLQuery q = session.createSynchronizedSQLQuery(sql);
            q.addEntity("BlogsEntry", BlogsEntryImpl.class);
            QueryPos qPos = QueryPos.getInstance((Query)q);
            qPos.add(companyId);
            qPos.add(groupId);
            qPos.add(groupId);
            qPos.add(groupId);
            qPos.add(displayDate);
            if (queryDefinition.getStatus() != -1) {
                qPos.add(queryDefinition.getStatus());
            }
            List list = QueryUtil.list((Query)q, (Dialect)this.getDialect(), (int)queryDefinition.getStart(), (int)queryDefinition.getEnd());
            return list;
        }
        catch (Exception e) {
            throw new SystemException((Throwable)e);
        }
        finally {
            this.closeSession(session);
        }
    }

    public List<BlogsEntry> findByOrganizationId(long organizationId, Date displayDate, QueryDefinition<BlogsEntry> queryDefinition) {
        ArrayList<Long> organizationIds = new ArrayList<Long>();
        organizationIds.add(organizationId);
        return this.findByOrganizationIds(organizationIds, displayDate, queryDefinition);
    }

    public List<BlogsEntry> findByOrganizationIds(List<Long> organizationIds, Date displayDate, QueryDefinition<BlogsEntry> queryDefinition) {
        Timestamp displayDate_TS = CalendarUtil.getTimestamp((Date)displayDate);
        Session session = null;
        try {
            session = this.openSession();
            String sql = CustomSQLUtil.get((String)FIND_BY_ORGANIZATION_IDS);
            if (queryDefinition.getStatus() != -1) {
                sql = queryDefinition.isExcludeStatus() ? CustomSQLUtil.appendCriteria((String)sql, (String)"AND (BlogsEntry.status != ?)") : CustomSQLUtil.appendCriteria((String)sql, (String)"AND (BlogsEntry.status = ?)");
            }
            sql = StringUtil.replace((String)sql, (String)"[$ORGANIZATION_ID$]", (String)this.getOrganizationIds(organizationIds));
            sql = CustomSQLUtil.replaceOrderBy((String)sql, (OrderByComparator)queryDefinition.getOrderByComparator());
            SQLQuery q = session.createSynchronizedSQLQuery(sql);
            q.addEntity("BlogsEntry", BlogsEntryImpl.class);
            QueryPos qPos = QueryPos.getInstance((Query)q);
            for (int i = 0; i < organizationIds.size(); ++i) {
                Long organizationId = organizationIds.get(i);
                qPos.add(organizationId);
            }
            qPos.add(displayDate_TS);
            if (queryDefinition.getStatus() != -1) {
                qPos.add(queryDefinition.getStatus());
            }
            List list = QueryUtil.list((Query)q, (Dialect)this.getDialect(), (int)queryDefinition.getStart(), (int)queryDefinition.getEnd());
            return list;
        }
        catch (Exception e) {
            throw new SystemException((Throwable)e);
        }
        finally {
            this.closeSession(session);
        }
    }

    public List<BlogsEntry> findByNoAssets() {
        Session session = null;
        try {
            session = this.openSession();
            String sql = CustomSQLUtil.get((String)FIND_BY_NO_ASSETS);
            SQLQuery q = session.createSynchronizedSQLQuery(sql);
            q.addEntity("BlogsEntry", BlogsEntryImpl.class);
            QueryPos qPos = QueryPos.getInstance((Query)q);
            qPos.add(PortalUtil.getClassNameId(BlogsEntry.class));
            List list = q.list(true);
            return list;
        }
        catch (Exception e) {
            throw new SystemException((Throwable)e);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected String getOrganizationIds(List<Long> organizationIds) {
        if (organizationIds.isEmpty()) {
            return "";
        }
        StringBundler sb = new StringBundler(organizationIds.size() * 2 - 1);
        for (int i = 0; i < organizationIds.size(); ++i) {
            sb.append("Users_Orgs.organizationId = ? ");
            if (i + 1 == organizationIds.size()) continue;
            sb.append("OR ");
        }
        return sb.toString();
    }
}

