/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.upgrade.v6_2_0;

import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.util.Base64;
import com.liferay.portal.kernel.util.LoggingTimer;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.util.Encryptor;
import java.security.Key;
import java.sql.PreparedStatement;
import java.sql.ResultSet;

public class UpgradeCompany
extends UpgradeProcess {
    protected void doUpgrade() throws Exception {
        String keyAlgorithm = Encryptor.KEY_ALGORITHM;
        if (keyAlgorithm.equals("DES")) {
            return;
        }
        this.upgradeKey();
    }

    protected void upgradeKey() throws Exception {
        try (LoggingTimer loggingTimer = new LoggingTimer();
             PreparedStatement ps = this.connection.prepareStatement("select companyId, key_ from Company");
             ResultSet rs = ps.executeQuery();){
            while (rs.next()) {
                long companyId = rs.getLong("companyId");
                String key = rs.getString("key_");
                this.upgradeKey(companyId, key);
            }
        }
    }

    protected void upgradeKey(long companyId, String key) throws Exception {
        String algorithm;
        Key keyObj = null;
        if (Validator.isNotNull((String)key)) {
            keyObj = (Key)Base64.stringToObjectSilent((String)key);
        }
        if (keyObj != null && !(algorithm = keyObj.getAlgorithm()).equals("DES")) {
            return;
        }
        try (PreparedStatement ps = this.connection.prepareStatement("update Company set key_ = ? where companyId = ?");){
            ps.setString(1, Base64.objectToString((Object)Encryptor.generateKey()));
            ps.setLong(2, companyId);
            ps.executeUpdate();
        }
    }
}

