/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.tools;

import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.security.xml.SecureXMLFactoryProviderImpl;
import java.io.File;
import java.io.FileOutputStream;
import java.util.TreeMap;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XSLTBuilder {
    public static void main(String[] args) {
        if (args.length != 3) {
            throw new IllegalArgumentException();
        }
        new XSLTBuilder(StringUtil.split((String)args[0]), args[1], args[2]);
    }

    public XSLTBuilder(String xml, String xsl, String html) {
        this(new String[]{xml}, xsl, html);
    }

    public XSLTBuilder(String[] xmls, String xsl, String html) {
        try {
            System.setProperty("line.separator", "\n");
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer(new StreamSource(xsl));
            transformer.transform(this._combineAndSortXMLs(xmls), new StreamResult(new FileOutputStream(html)));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private Source _combineAndSortXMLs(String[] xmls) throws Exception {
        SecureXMLFactoryProviderImpl secureXMLFactoryProvider = new SecureXMLFactoryProviderImpl();
        DocumentBuilderFactory documentBuilderFactory = secureXMLFactoryProvider.newDocumentBuilderFactory();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        TreeMap<String, Node> nodeMap = new TreeMap<String, Node>();
        for (String xml : xmls) {
            Document document = documentBuilder.parse(new File(xml));
            NodeList nodeList = document.getElementsByTagName("file-name");
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node = nodeList.item(i);
                nodeMap.put(node.getTextContent(), node.getParentNode());
            }
        }
        Document document = documentBuilder.newDocument();
        Element versionsElement = document.createElement("versions");
        document.appendChild(versionsElement);
        Element versionElement = document.createElement("version");
        versionsElement.appendChild(versionElement);
        Element librariesElement = document.createElement("libraries");
        versionElement.appendChild(librariesElement);
        for (Node node : nodeMap.values()) {
            librariesElement.appendChild(document.importNode(node, true));
        }
        return new DOMSource(document);
    }
}

