/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.servlet.filters.dynamiccss;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.servlet.BufferCacheServletResponse;
import com.liferay.portal.kernel.servlet.DynamicResourceIncludeUtil;
import com.liferay.portal.kernel.servlet.PortalWebResourcesUtil;
import com.liferay.portal.kernel.servlet.PortletResourcesUtil;
import com.liferay.portal.kernel.servlet.ServletResponseUtil;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.URLUtil;
import com.liferay.portal.servlet.filters.IgnoreModuleRequestFilter;
import com.liferay.portal.servlet.filters.dynamiccss.DynamicCSSUtil;
import com.liferay.portal.servlet.filters.util.CacheFileNameGenerator;
import com.liferay.portal.util.PropsUtil;
import java.io.File;
import java.io.InputStream;
import java.net.URL;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class DynamicCSSFilter
extends IgnoreModuleRequestFilter {
    public static final boolean ENABLED = GetterUtil.getBoolean((String)PropsUtil.get(DynamicCSSFilter.class.getName()));
    private static final String _CACHE_FILE_NAME_RTL = "_rtl";
    private static final String _CSS_EXTENSION = ".css";
    private static final String _JSP_EXTENSION = ".jsp";
    private static final String _TEMP_DIR = "css";
    private static final Log _log = LogFactoryUtil.getLog(DynamicCSSFilter.class);
    private ServletContext _servletContext;
    private File _tempDir;

    public void init(FilterConfig filterConfig) {
        super.init(filterConfig);
        this._servletContext = filterConfig.getServletContext();
        File tempDir = (File)this._servletContext.getAttribute("javax.servlet.context.tempdir");
        this._tempDir = new File(tempDir, _TEMP_DIR);
        this._tempDir.mkdirs();
    }

    protected String getCacheFileName(HttpServletRequest request) {
        String cacheFileName = CacheFileNameGenerator.getCacheFileName(request, DynamicCSSFilter.class.getName());
        if (PortalUtil.isRightToLeft((HttpServletRequest)request)) {
            return cacheFileName + _CACHE_FILE_NAME_RTL;
        }
        return cacheFileName;
    }

    protected Object getDynamicContent(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws Exception {
        String content;
        String dynamicContent;
        File cacheDataFile;
        block17: {
            ServletContext servletContext = this._servletContext;
            String requestPath = this.getRequestPath(request);
            URL resourceURL = this._servletContext.getResource(requestPath);
            String originalRequestPath = request.getRequestURI();
            if (originalRequestPath.endsWith(_CSS_EXTENSION) && PortalUtil.isRightToLeft((HttpServletRequest)request)) {
                int pos = originalRequestPath.lastIndexOf(".");
                originalRequestPath = originalRequestPath.substring(0, pos) + _CACHE_FILE_NAME_RTL + originalRequestPath.substring(pos);
            }
            if (resourceURL == null) {
                ServletContext resourceServletContext = PortalWebResourcesUtil.getPathServletContext((String)originalRequestPath);
                if (resourceServletContext != null) {
                    resourceURL = PortalWebResourcesUtil.getResource((ServletContext)resourceServletContext, (String)originalRequestPath);
                }
                if (resourceURL == null && (resourceServletContext = PortletResourcesUtil.getPathServletContext((String)originalRequestPath)) != null) {
                    resourceURL = PortletResourcesUtil.getResource((ServletContext)resourceServletContext, (String)originalRequestPath);
                }
                if (resourceURL == null && (resourceServletContext = DynamicResourceIncludeUtil.getPathServletContext((String)originalRequestPath)) != null) {
                    resourceURL = DynamicResourceIncludeUtil.getResource((ServletContext)resourceServletContext, (String)originalRequestPath);
                }
                if (resourceURL == null) {
                    return null;
                }
                servletContext = resourceServletContext;
            }
            String cacheCommonFileName = this.getCacheFileName(request);
            File cacheContentTypeFile = new File(this._tempDir, cacheCommonFileName + "_E_CTYPE");
            cacheDataFile = new File(this._tempDir, cacheCommonFileName + "_E_DATA");
            if (cacheDataFile.exists() && cacheDataFile.lastModified() >= this.getLastModified(request, resourceURL)) {
                if (cacheContentTypeFile.exists()) {
                    String contentType = FileUtil.read((File)cacheContentTypeFile);
                    response.setContentType(contentType);
                }
                return cacheDataFile;
            }
            dynamicContent = null;
            content = null;
            try {
                if (originalRequestPath.endsWith(_CSS_EXTENSION)) {
                    if (_log.isInfoEnabled()) {
                        _log.info((Object)("Replacing tokens on CSS " + originalRequestPath));
                    }
                    content = StringUtil.read((InputStream)resourceURL.openStream());
                    dynamicContent = DynamicCSSUtil.replaceToken(servletContext, request, content);
                    response.setContentType("text/css");
                    FileUtil.write((File)cacheContentTypeFile, (String)"text/css");
                    break block17;
                }
                if (originalRequestPath.endsWith(_JSP_EXTENSION)) {
                    if (_log.isInfoEnabled()) {
                        _log.info((Object)("Replacing tokens on JSP or servlet " + originalRequestPath));
                    }
                    BufferCacheServletResponse bufferCacheServletResponse = new BufferCacheServletResponse(response);
                    this.processFilter(DynamicCSSFilter.class.getName(), request, (HttpServletResponse)bufferCacheServletResponse, filterChain);
                    content = bufferCacheServletResponse.getString();
                    dynamicContent = DynamicCSSUtil.replaceToken(servletContext, request, content);
                    FileUtil.write((File)cacheContentTypeFile, (String)bufferCacheServletResponse.getContentType());
                    break block17;
                }
                return null;
            }
            catch (Exception e) {
                _log.error((Object)("Unable to replace tokens in CSS " + originalRequestPath), (Throwable)e);
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)content);
                }
                response.setHeader("Cache-Control", "private, no-cache, no-store, must-revalidate");
            }
        }
        if (dynamicContent != null) {
            FileUtil.write((File)cacheDataFile, (String)dynamicContent);
        } else {
            dynamicContent = content;
        }
        return dynamicContent;
    }

    protected long getLastModified(HttpServletRequest request, URL resourceURL) throws Exception {
        long resourceLastModified = URLUtil.getLastModifiedTime((URL)resourceURL);
        long requestLastModified = ParamUtil.getLong((HttpServletRequest)request, (String)"t", (long)-1L);
        return Math.max(resourceLastModified, requestLastModified);
    }

    protected String getRequestPath(HttpServletRequest request) {
        String requestPath = request.getRequestURI();
        String contextPath = request.getContextPath();
        if (!contextPath.equals("/")) {
            requestPath = requestPath.substring(contextPath.length());
        }
        return requestPath;
    }

    @Override
    protected boolean isModuleRequest(HttpServletRequest request) {
        String requestURI = request.getRequestURI();
        if (PortalWebResourcesUtil.hasContextPath((String)requestURI)) {
            return false;
        }
        return super.isModuleRequest(request);
    }

    protected void processFilter(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws Exception {
        Object parsedContent = this.getDynamicContent(request, response, filterChain);
        if (parsedContent == null) {
            this.processFilter(DynamicCSSFilter.class.getName(), request, response, filterChain);
        } else if (parsedContent instanceof File) {
            ServletResponseUtil.write((HttpServletResponse)response, (File)((File)parsedContent));
        } else if (parsedContent instanceof String) {
            ServletResponseUtil.write((HttpServletResponse)response, (String)((String)parsedContent));
        }
    }
}

