/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.events;

import com.liferay.portal.kernel.events.ActionException;
import com.liferay.portal.kernel.events.LifecycleAction;
import com.liferay.portal.kernel.events.LifecycleEvent;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.InstancePool;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.registry.Registry;
import com.liferay.registry.RegistryUtil;
import com.liferay.registry.ServiceRegistration;
import com.liferay.registry.collections.ServiceTrackerCollections;
import com.liferay.registry.collections.ServiceTrackerMap;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public class EventsProcessorUtil {
    private static final Log _log = LogFactoryUtil.getLog(EventsProcessorUtil.class);
    private static final ServiceTrackerMap<String, List<LifecycleAction>> _lifecycleActions = ServiceTrackerCollections.openMultiValueMap(LifecycleAction.class, (String)"key");
    private static final ConcurrentMap<String, Map<Object, ServiceRegistration<LifecycleAction>>> _serviceRegistrationMaps = new ConcurrentHashMap<String, Map<Object, ServiceRegistration<LifecycleAction>>>();

    public static void process(String key, String[] classes) throws ActionException {
        EventsProcessorUtil.process(key, classes, new LifecycleEvent());
    }

    public static void process(String key, String[] classes, HttpServletRequest request, HttpServletResponse response) throws ActionException {
        EventsProcessorUtil.process(key, classes, new LifecycleEvent(request, response));
    }

    public static void process(String key, String[] classes, HttpSession session) throws ActionException {
        EventsProcessorUtil.process(key, classes, new LifecycleEvent(session));
    }

    public static void process(String key, String[] classes, LifecycleEvent lifecycleEvent) throws ActionException {
        for (String className : classes) {
            if (Validator.isNull((String)className)) {
                return;
            }
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Process event " + className));
            }
            LifecycleAction lifecycleAction = (LifecycleAction)InstancePool.get((String)className);
            lifecycleAction.processLifecycleEvent(lifecycleEvent);
        }
        if (Validator.isNull((String)key)) {
            return;
        }
        List lifecycleActions = (List)_lifecycleActions.getService((Object)key);
        if (lifecycleActions != null) {
            for (LifecycleAction lifecycleAction : lifecycleActions) {
                lifecycleAction.processLifecycleEvent(lifecycleEvent);
            }
        }
    }

    public static void process(String key, String[] classes, String[] ids) throws ActionException {
        EventsProcessorUtil.process(key, classes, new LifecycleEvent(ids));
    }

    public static void processEvent(LifecycleAction lifecycleAction, LifecycleEvent lifecycleEvent) throws ActionException {
        lifecycleAction.processLifecycleEvent(lifecycleEvent);
    }

    public static void registerEvent(String key, Object event) {
        Registry registry = RegistryUtil.getRegistry();
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("key", key);
        ServiceRegistration serviceRegistration = registry.registerService(LifecycleAction.class, (Object)((LifecycleAction)event), properties);
        Map serviceRegistrationMap = (Map)_serviceRegistrationMaps.get(key);
        if (serviceRegistrationMap == null) {
            _serviceRegistrationMaps.putIfAbsent(key, new ConcurrentHashMap());
            serviceRegistrationMap = (Map)_serviceRegistrationMaps.get(key);
        }
        serviceRegistrationMap.put(event, serviceRegistration);
    }

    public static void unregisterEvent(String key, Object event) {
        Map serviceRegistrationMap = (Map)_serviceRegistrationMaps.get(key);
        if (serviceRegistrationMap != null) {
            ServiceRegistration serviceRegistration = (ServiceRegistration)serviceRegistrationMap.remove(event);
            if (serviceRegistration != null) {
                serviceRegistration.unregister();
            }
            _serviceRegistrationMaps.remove(key, Collections.emptyList());
        }
    }

    protected EventsProcessorUtil() {
    }

    @Deprecated
    protected Collection<LifecycleAction> _getLifecycleActions(String key) {
        List<LifecycleAction> lifecycleActions = (List<LifecycleAction>)_lifecycleActions.getService((Object)key);
        if (lifecycleActions == null) {
            lifecycleActions = Collections.emptyList();
        }
        return lifecycleActions;
    }

    @Deprecated
    protected void _process(String key, String[] classes, LifecycleEvent lifecycleEvent) throws ActionException {
        EventsProcessorUtil.process(key, classes, lifecycleEvent);
    }

    @Deprecated
    protected void _processEvent(LifecycleAction lifecycleAction, LifecycleEvent lifecycleEvent) throws ActionException {
        EventsProcessorUtil.processEvent(lifecycleAction, lifecycleEvent);
    }

    @Deprecated
    protected void _registerEvent(String key, Object event) {
        EventsProcessorUtil.registerEvent(key, event);
    }

    @Deprecated
    protected void _unregisterEvent(String key, Object event) {
        EventsProcessorUtil.unregisterEvent(key, event);
    }
}

