/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.dao.sql.transformer;

import com.liferay.portal.dao.sql.transformer.BaseSQLTransformerLogic;
import com.liferay.portal.kernel.dao.db.DB;
import com.liferay.portal.kernel.util.ArrayUtil;
import java.util.function.Function;
import java.util.regex.Matcher;

public class MySQLSQLTransformerLogic
extends BaseSQLTransformerLogic {
    private static final String _LOWER_CLOSE = ")";
    private static final String _LOWER_OPEN = "lower(";

    public MySQLSQLTransformerLogic(DB db) {
        super(db);
        Object[] functions = new Function[]{this.getBitwiseCheckFunction(), this.getBooleanFunction(), this.getCastClobTextFunction(), this.getCastLongFunction(), this.getCastTextFunction(), this.getIntegerDivisionFunction(), this.getNullDateFunction()};
        if (!db.isSupportsStringCaseSensitiveQuery()) {
            functions = (Function[])ArrayUtil.append((Object[])functions, this._getLowerFunction());
        }
        this.setFunctions((Function[])functions);
    }

    @Override
    protected String replaceIntegerDivision(Matcher matcher) {
        return matcher.replaceAll("$1 DIV $2");
    }

    private Function<String, String> _getLowerFunction() {
        return sql -> {
            StringBuilder sb;
            block3: {
                int x = sql.indexOf(_LOWER_OPEN);
                if (x == -1) {
                    return sql;
                }
                sb = new StringBuilder(sql.length());
                int y = 0;
                do {
                    sb.append(sql.substring(y, x));
                    y = sql.indexOf(_LOWER_CLOSE, x);
                    if (y == -1) {
                        sb.append(sql.substring(x));
                        break block3;
                    }
                    sb.append(sql.substring(x + _LOWER_OPEN.length(), y));
                } while ((x = sql.indexOf(_LOWER_OPEN, ++y)) != -1);
                sb.append(sql.substring(y));
            }
            sql = sb.toString();
            return sql;
        };
    }
}

