/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.configuration.easyconf;

import com.germinus.easyconf.AggregatedProperties;
import com.germinus.easyconf.ComponentConfiguration;
import com.germinus.easyconf.ComponentProperties;
import com.germinus.easyconf.ConfigurationNotFoundException;
import com.liferay.portal.configuration.easyconf.ClassLoaderAggregateProperties;
import com.liferay.portal.kernel.exception.LoggedExceptionInInitializerError;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.CharPool;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.SystemProperties;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.configuration.Configuration;

public class ClassLoaderComponentConfiguration
extends ComponentConfiguration {
    private static final Constructor<ComponentProperties> _CONSTRUCTOR;
    private static final String _ENV_OVERRIDE_PREFIX = "LIFERAY_";
    private static final Log _log;
    private static final Map<String, Character> _charPoolChars;
    private final ClassLoader _classLoader;
    private final String _companyId;
    private final String _componentName;
    private ComponentProperties _properties;

    public ClassLoaderComponentConfiguration(ClassLoader classLoader, String companyId, String componentName) {
        super(companyId, componentName);
        this._classLoader = classLoader;
        this._companyId = companyId;
        this._componentName = componentName;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ComponentConfiguration)) {
            return false;
        }
        ComponentConfiguration componentConfiguration = (ComponentConfiguration)obj;
        return this._componentName.equals(componentConfiguration.getComponentName());
    }

    public String getComponentName() {
        return this._componentName;
    }

    public Object getConfigurationObject() {
        throw new UnsupportedOperationException();
    }

    public Object getConfigurationObject(String configurationName) {
        throw new UnsupportedOperationException();
    }

    public ComponentProperties getProperties() {
        ComponentProperties componentProperties = this._getAvailableProperties();
        if (!componentProperties.hasBaseConfiguration()) {
            throw new ConfigurationNotFoundException(this._componentName, "The base properties file was not found");
        }
        return componentProperties;
    }

    public int hashCode() {
        return this._componentName.hashCode();
    }

    public void saveConfigurationObject(Object configurationObject) {
        throw new UnsupportedOperationException();
    }

    public void saveConfigurationObject(String confName, Object configurationObject) {
        throw new UnsupportedOperationException();
    }

    protected static String decode(String s) {
        int index = -1;
        int openUnderLine = -1;
        int position = 0;
        StringBundler sb = new StringBundler();
        while ((index = s.indexOf(95, index + 1)) != -1) {
            if (openUnderLine == -1) {
                sb.append(s.substring(position, index));
                openUnderLine = index;
                position = index;
                continue;
            }
            String encoded = s.substring(openUnderLine + 1, index);
            Character character = _charPoolChars.get(StringUtil.toUpperCase((String)encoded));
            if (character == null) {
                int value = GetterUtil.get((String)encoded, (int)-1);
                if (Character.isDefined(value)) {
                    sb.append(new String(Character.toChars(value)));
                } else {
                    if (_log.isWarnEnabled()) {
                        _log.warn((Object)("Unable to decode part \"" + encoded + "\" from \"" + s + "\", preserve it literally"));
                    }
                    sb.append(s.substring(openUnderLine, index + 1));
                }
            } else {
                sb.append((Object)character);
            }
            openUnderLine = -1;
            position = index + 1;
        }
        sb.append(s.substring(position, s.length()));
        return sb.toString();
    }

    private ComponentProperties _getAvailableProperties() {
        if (this._properties != null) {
            return this._properties;
        }
        SystemProperties.set((String)"base.path", (String)".");
        ClassLoaderAggregateProperties classLoaderAggregateProperties = new ClassLoaderAggregateProperties(this._classLoader, this._companyId, this._componentName);
        classLoaderAggregateProperties.addGlobalFileName("global-configuration.properties");
        classLoaderAggregateProperties.addBaseFileName(this._componentName + ".properties");
        if (_log.isInfoEnabled()) {
            _log.info((Object)("Properties for " + this._componentName + " loaded from " + classLoaderAggregateProperties.loadedSources()));
        }
        this._loadEnvOverrides((Configuration)classLoaderAggregateProperties);
        try {
            this._properties = _CONSTRUCTOR.newInstance(new Object[]{classLoaderAggregateProperties});
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
        }
        return this._properties;
    }

    private void _loadEnvOverrides(Configuration configuration) {
        Map<String, String> env = System.getenv();
        for (Map.Entry<String, String> entry : env.entrySet()) {
            String key = entry.getKey();
            if (!key.startsWith(_ENV_OVERRIDE_PREFIX)) continue;
            String newKey = ClassLoaderComponentConfiguration.decode(StringUtil.toLowerCase((String)key.substring(_ENV_OVERRIDE_PREFIX.length())));
            configuration.setProperty(newKey, (Object)entry.getValue());
            if (!_log.isInfoEnabled()) continue;
            _log.info((Object)("Overrode property " + newKey + " with the value from the environment variable " + key));
        }
    }

    static {
        _log = LogFactoryUtil.getLog(ClassLoaderComponentConfiguration.class);
        _charPoolChars = new HashMap<String, Character>();
        try {
            for (Field field : CharPool.class.getFields()) {
                if (!Modifier.isStatic(field.getModifiers()) || field.getType() != Character.TYPE) continue;
                _charPoolChars.put(StringUtil.removeChar((String)field.getName(), (char)'_'), Character.valueOf(field.getChar(null)));
            }
        }
        catch (ReflectiveOperationException roe) {
            throw new ExceptionInInitializerError(roe);
        }
        Constructor constructor = null;
        try {
            constructor = ComponentProperties.class.getDeclaredConstructor(AggregatedProperties.class);
            constructor.setAccessible(true);
        }
        catch (Exception e) {
            throw new LoggedExceptionInInitializerError((Throwable)e);
        }
        _CONSTRUCTOR = constructor;
    }
}

