/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.maven;

import com.liferay.source.formatter.SourceFormatter;
import com.liferay.source.formatter.SourceFormatterArgs;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;

public class FormatSourceMojo
extends AbstractMojo {
    private final SourceFormatterArgs _sourceFormatterArgs = new SourceFormatterArgs();

    public void execute() throws MojoExecutionException {
        try {
            Map pluginContext = this.getPluginContext();
            SourceFormatter sourceFormatter = new SourceFormatter(this._sourceFormatterArgs);
            sourceFormatter.format();
            List<String> modifiedFileNames = sourceFormatter.getModifiedFileNames();
            pluginContext.put("source.formatter.modified.files", modifiedFileNames);
        }
        catch (Exception e) {
            throw new MojoExecutionException(e.getMessage(), e);
        }
    }

    public void setAutoFix(boolean autoFix) {
        this._sourceFormatterArgs.setAutoFix(autoFix);
    }

    public void setBaseDir(String baseDir) {
        this._sourceFormatterArgs.setBaseDirName(baseDir);
    }

    public void setFileNames(String[] fileNames) {
        this._sourceFormatterArgs.setFileNames(Arrays.asList(fileNames));
    }

    public void setFormatCurrentBranch(boolean formatCurrentBranch) {
        this._sourceFormatterArgs.setFormatCurrentBranch(formatCurrentBranch);
    }

    public void setFormatLatestAuthor(boolean formatLatestAuthor) {
        this._sourceFormatterArgs.setFormatLatestAuthor(formatLatestAuthor);
    }

    public void setFormatLocalChanges(boolean formatLocalChanges) {
        this._sourceFormatterArgs.setFormatLocalChanges(formatLocalChanges);
    }

    public void setGitWorkingBranchName(String gitWorkingBranchName) {
        this._sourceFormatterArgs.setGitWorkingBranchName(gitWorkingBranchName);
    }

    public void setIncludeSubrepositories(boolean includeSubrepositories) {
        this._sourceFormatterArgs.setIncludeSubrepositories(includeSubrepositories);
    }

    public void setMaxLineLength(int maxLineLength) {
        this._sourceFormatterArgs.setMaxLineLength(maxLineLength);
    }

    public void setPrintErrors(boolean printErrors) {
        this._sourceFormatterArgs.setPrintErrors(printErrors);
    }

    public void setProcessorThreadCount(int processorThreadCount) {
        this._sourceFormatterArgs.setProcessorThreadCount(processorThreadCount);
    }

    public void setShowDocumentation(boolean showDocumentation) {
        this._sourceFormatterArgs.setShowDocumentation(showDocumentation);
    }

    public void setShowStatusUpdates(boolean showStatusUpdates) {
        this._sourceFormatterArgs.setShowStatusUpdates(showStatusUpdates);
    }

    public void setThrowException(boolean throwException) {
        this._sourceFormatterArgs.setThrowException(throwException);
    }
}

