/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter;

import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.tools.ArgumentsUtil;
import com.liferay.portal.tools.GitException;
import com.liferay.portal.tools.GitUtil;
import com.liferay.source.formatter.BNDSourceProcessor;
import com.liferay.source.formatter.CQLSourceProcessor;
import com.liferay.source.formatter.CSSSourceProcessor;
import com.liferay.source.formatter.CodeownersSourceProcessor;
import com.liferay.source.formatter.DockerfileSourceProcessor;
import com.liferay.source.formatter.ExcludeSyntax;
import com.liferay.source.formatter.ExcludeSyntaxPattern;
import com.liferay.source.formatter.FTLSourceProcessor;
import com.liferay.source.formatter.GradleSourceProcessor;
import com.liferay.source.formatter.GroovySourceProcessor;
import com.liferay.source.formatter.JSONSourceProcessor;
import com.liferay.source.formatter.JSPSourceProcessor;
import com.liferay.source.formatter.JSSourceProcessor;
import com.liferay.source.formatter.JavaSourceProcessor;
import com.liferay.source.formatter.MarkdownSourceProcessor;
import com.liferay.source.formatter.ProgressStatus;
import com.liferay.source.formatter.ProgressStatusUpdate;
import com.liferay.source.formatter.PropertiesSourceProcessor;
import com.liferay.source.formatter.SHSourceProcessor;
import com.liferay.source.formatter.SQLSourceProcessor;
import com.liferay.source.formatter.SourceFormatterArgs;
import com.liferay.source.formatter.SourceFormatterExcludes;
import com.liferay.source.formatter.SourceFormatterMessage;
import com.liferay.source.formatter.SourceMismatchException;
import com.liferay.source.formatter.SourceProcessor;
import com.liferay.source.formatter.SoySourceProcessor;
import com.liferay.source.formatter.TLDSourceProcessor;
import com.liferay.source.formatter.XMLSourceProcessor;
import com.liferay.source.formatter.YMLSourceProcessor;
import com.liferay.source.formatter.checks.util.SourceUtil;
import com.liferay.source.formatter.util.FileUtil;
import com.liferay.source.formatter.util.SourceFormatterUtil;
import java.io.File;
import java.io.FileInputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;

public class SourceFormatter {
    public static final ExcludeSyntaxPattern[] DEFAULT_EXCLUDE_SYNTAX_PATTERNS = new ExcludeSyntaxPattern[]{new ExcludeSyntaxPattern(ExcludeSyntax.GLOB, "**/.git/**"), new ExcludeSyntaxPattern(ExcludeSyntax.GLOB, "**/.gradle/**"), new ExcludeSyntaxPattern(ExcludeSyntax.GLOB, "**/bin/**"), new ExcludeSyntaxPattern(ExcludeSyntax.GLOB, "**/build/**"), new ExcludeSyntaxPattern(ExcludeSyntax.GLOB, "**/classes/**"), new ExcludeSyntaxPattern(ExcludeSyntax.GLOB, "**/npm-shrinkwrap.json"), new ExcludeSyntaxPattern(ExcludeSyntax.GLOB, "**/package-lock.json"), new ExcludeSyntaxPattern(ExcludeSyntax.GLOB, "**/test-classes/**"), new ExcludeSyntaxPattern(ExcludeSyntax.GLOB, "**/test-coverage/**"), new ExcludeSyntaxPattern(ExcludeSyntax.GLOB, "**/test-results/**"), new ExcludeSyntaxPattern(ExcludeSyntax.GLOB, "**/tmp/**"), new ExcludeSyntaxPattern(ExcludeSyntax.REGEX, "^((?!/frontend-js-node-shims/src/).)*/node_modules/.*")};
    private static final String _PROPERTIES_FILE_NAME = "source-formatter.properties";
    private List<String> _allFileNames;
    private volatile SourceMismatchException _firstSourceMismatchException;
    private int _maxStatusMessageLength = -1;
    private final List<String> _modifiedFileNames = new CopyOnWriteArrayList<String>();
    private final BlockingQueue<ProgressStatusUpdate> _progressStatusQueue = new LinkedBlockingQueue<ProgressStatusUpdate>();
    private final Thread _progressStatusThread = new Thread(){

        @Override
        public void run() {
            int fileScansCompletedCount = 0;
            int percentage = 0;
            int processedCheckStyleFileCount = 0;
            int processedSourceChecksFileCount = 0;
            int totalCheckStyleFileCount = 0;
            int totalSourceChecksFileCount = 0;
            boolean sourceChecksInitialized = false;
            boolean sourceChecksCompleted = false;
            while (true) {
                try {
                    while (true) {
                        ProgressStatusUpdate progressStatusUpdate;
                        ProgressStatus progressStatus;
                        if ((progressStatus = (progressStatusUpdate = (ProgressStatusUpdate)SourceFormatter.this._progressStatusQueue.take()).getProgressStatus()).equals((Object)ProgressStatus.CHECK_STYLE_FILE_COMPLETED)) {
                            ++processedCheckStyleFileCount;
                            if (!sourceChecksCompleted) continue;
                            percentage = this._processCompletedPercentage(percentage, processedCheckStyleFileCount, totalCheckStyleFileCount, "CheckStyle checks");
                            continue;
                        }
                        if (progressStatus.equals((Object)ProgressStatus.CHECK_STYLE_STARTING)) {
                            totalCheckStyleFileCount = progressStatusUpdate.getCount();
                            continue;
                        }
                        if (progressStatus.equals((Object)ProgressStatus.SOURCE_CHECKS_INITIALIZED)) {
                            totalSourceChecksFileCount += progressStatusUpdate.getCount();
                            if (++fileScansCompletedCount != SourceFormatter.this._sourceProcessors.size()) continue;
                            sourceChecksInitialized = true;
                            totalSourceChecksFileCount -= processedSourceChecksFileCount;
                            processedSourceChecksFileCount = 0;
                            continue;
                        }
                        if (progressStatus.equals((Object)ProgressStatus.SOURCE_CHECK_FILE_COMPLETED)) {
                            if (!sourceChecksInitialized || (percentage = this._processCompletedPercentage(percentage, ++processedSourceChecksFileCount, totalSourceChecksFileCount, "source checks")) != 100) continue;
                            sourceChecksCompleted = true;
                            totalCheckStyleFileCount -= processedCheckStyleFileCount;
                            processedCheckStyleFileCount = 0;
                            percentage = 0;
                            continue;
                        }
                        if (progressStatus.equals((Object)ProgressStatus.SOURCE_FORMAT_COMPLETED)) break;
                    }
                    if (SourceFormatter.this._maxStatusMessageLength == -1) break;
                    StringBundler sb = new StringBundler(SourceFormatter.this._maxStatusMessageLength);
                    for (int i = 0; i < SourceFormatter.this._maxStatusMessageLength; ++i) {
                        sb.append(' ');
                    }
                    SourceFormatter.this._printProgressStatusMessage(sb.toString());
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
                break;
            }
        }

        private int _processCompletedPercentage(int percentage, int count, int total, String checkType) {
            int newPercentage = count * 100 / total;
            if (newPercentage > percentage) {
                StringBundler sb = new StringBundler();
                sb.append("Processing ");
                sb.append(checkType);
                sb.append(": ");
                sb.append(newPercentage);
                sb.append("% completed");
                SourceFormatter.this._printProgressStatusMessage(sb.toString());
            }
            return newPercentage;
        }
    };
    private Map<String, Properties> _propertiesMap = new HashMap<String, Properties>();
    private final SourceFormatterArgs _sourceFormatterArgs;
    private SourceFormatterExcludes _sourceFormatterExcludes;
    private final Set<SourceFormatterMessage> _sourceFormatterMessages = new ConcurrentSkipListSet<SourceFormatterMessage>();
    private List<SourceProcessor> _sourceProcessors = new ArrayList<SourceProcessor>();

    public static void main(String[] args) throws Exception {
        Map<String, String> arguments = ArgumentsUtil.parseArguments(args);
        try {
            SourceFormatterArgs sourceFormatterArgs = new SourceFormatterArgs();
            boolean autoFix = ArgumentsUtil.getBoolean(arguments, "source.auto.fix", true);
            sourceFormatterArgs.setAutoFix(autoFix);
            String baseDirName = ArgumentsUtil.getString(arguments, "source.base.dir", "./");
            sourceFormatterArgs.setBaseDirName(baseDirName);
            boolean formatCurrentBranch = ArgumentsUtil.getBoolean(arguments, "format.current.branch", false);
            sourceFormatterArgs.setFormatCurrentBranch(formatCurrentBranch);
            boolean formatLatestAuthor = ArgumentsUtil.getBoolean(arguments, "format.latest.author", false);
            sourceFormatterArgs.setFormatLatestAuthor(formatLatestAuthor);
            boolean formatLocalChanges = ArgumentsUtil.getBoolean(arguments, "format.local.changes", false);
            sourceFormatterArgs.setFormatLocalChanges(formatLocalChanges);
            if (formatCurrentBranch) {
                String gitWorkingBranchName = ArgumentsUtil.getString(arguments, "git.working.branch.name", "master");
                sourceFormatterArgs.setGitWorkingBranchName(gitWorkingBranchName);
                sourceFormatterArgs.setRecentChangesFileNames(GitUtil.getCurrentBranchFileNames(baseDirName, gitWorkingBranchName));
            } else if (formatLatestAuthor) {
                sourceFormatterArgs.setRecentChangesFileNames(GitUtil.getLatestAuthorFileNames(baseDirName));
            } else if (formatLocalChanges) {
                sourceFormatterArgs.setRecentChangesFileNames(GitUtil.getLocalChangesFileNames(baseDirName));
            }
            String fileNamesString = ArgumentsUtil.getString(arguments, "source.files", "");
            Object[] fileNames = StringUtil.split(fileNamesString, ",");
            if (ArrayUtil.isNotEmpty(fileNames)) {
                sourceFormatterArgs.setFileNames(Arrays.asList(fileNames));
            } else {
                String fileExtensionsString = ArgumentsUtil.getString(arguments, "source.file.extensions", "");
                String[] fileExtensions = StringUtil.split(fileExtensionsString, ",");
                sourceFormatterArgs.setFileExtensions(Arrays.asList(fileExtensions));
            }
            boolean includeSubrepositories = ArgumentsUtil.getBoolean(arguments, "include.subrepositories", false);
            sourceFormatterArgs.setIncludeSubrepositories(includeSubrepositories);
            int maxLineLength = ArgumentsUtil.getInteger(arguments, "max.line.length", 80);
            sourceFormatterArgs.setMaxLineLength(maxLineLength);
            boolean printErrors = ArgumentsUtil.getBoolean(arguments, "source.print.errors", true);
            sourceFormatterArgs.setPrintErrors(printErrors);
            int processorThreadCount = ArgumentsUtil.getInteger(arguments, "processor.thread.count", 5);
            sourceFormatterArgs.setProcessorThreadCount(processorThreadCount);
            boolean showDocumentation = ArgumentsUtil.getBoolean(arguments, "show.documentation", false);
            sourceFormatterArgs.setShowDocumentation(showDocumentation);
            boolean showStatusUpdates = ArgumentsUtil.getBoolean(arguments, "show.status.updates", false);
            sourceFormatterArgs.setShowStatusUpdates(showStatusUpdates);
            boolean throwException = ArgumentsUtil.getBoolean(arguments, "source.throw.exception", false);
            sourceFormatterArgs.setThrowException(throwException);
            SourceFormatter sourceFormatter = new SourceFormatter(sourceFormatterArgs);
            sourceFormatter.format();
        }
        catch (GitException ge) {
            System.out.println(ge.getMessage());
            System.exit(0);
        }
        catch (Exception e) {
            ArgumentsUtil.processMainException(arguments, e);
        }
    }

    public SourceFormatter(SourceFormatterArgs sourceFormatterArgs) {
        this._sourceFormatterArgs = sourceFormatterArgs;
        if (sourceFormatterArgs.isShowDocumentation()) {
            System.setProperty("java.awt.headless", "false");
        } else {
            System.setProperty("java.awt.headless", "true");
        }
    }

    public void format() throws Exception {
        this._printProgressStatusMessage("Scanning for files...");
        this._init();
        this._printProgressStatusMessage("Initializing checks...");
        this._progressStatusThread.start();
        this._sourceProcessors.add(new BNDSourceProcessor());
        this._sourceProcessors.add(new CodeownersSourceProcessor());
        this._sourceProcessors.add(new CQLSourceProcessor());
        this._sourceProcessors.add(new CSSSourceProcessor());
        this._sourceProcessors.add(new DockerfileSourceProcessor());
        this._sourceProcessors.add(new FTLSourceProcessor());
        this._sourceProcessors.add(new GradleSourceProcessor());
        this._sourceProcessors.add(new GroovySourceProcessor());
        this._sourceProcessors.add(new JavaSourceProcessor());
        this._sourceProcessors.add(new JSONSourceProcessor());
        this._sourceProcessors.add(new JSPSourceProcessor());
        this._sourceProcessors.add(new JSSourceProcessor());
        this._sourceProcessors.add(new MarkdownSourceProcessor());
        this._sourceProcessors.add(new PropertiesSourceProcessor());
        this._sourceProcessors.add(new SHSourceProcessor());
        this._sourceProcessors.add(new SoySourceProcessor());
        this._sourceProcessors.add(new SQLSourceProcessor());
        this._sourceProcessors.add(new TLDSourceProcessor());
        this._sourceProcessors.add(new XMLSourceProcessor());
        this._sourceProcessors.add(new YMLSourceProcessor());
        ExecutorService executorService = Executors.newFixedThreadPool(this._sourceProcessors.size());
        ArrayList<Future> futures = new ArrayList<Future>(this._sourceProcessors.size());
        for (final SourceProcessor sourceProcessor : this._sourceProcessors) {
            Future future = executorService.submit(new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    SourceFormatter.this._runSourceProcessor(sourceProcessor);
                    return null;
                }
            });
            futures.add(future);
        }
        ExecutionException ee1 = null;
        for (Future future : futures) {
            try {
                future.get();
            }
            catch (ExecutionException ee) {
                if (ee1 == null) {
                    ee1 = ee;
                    continue;
                }
                ee1.addSuppressed(ee);
            }
        }
        executorService.shutdown();
        while (!executorService.isTerminated()) {
            Thread.sleep(20L);
        }
        if (ee1 != null) {
            throw ee1;
        }
        if (this._sourceFormatterArgs.isThrowException()) {
            if (!this._sourceFormatterMessages.isEmpty()) {
                StringBundler stringBundler = new StringBundler(this._sourceFormatterMessages.size() * 2);
                for (SourceFormatterMessage sourceFormatterMessage : this._sourceFormatterMessages) {
                    stringBundler.append(sourceFormatterMessage.toString());
                    stringBundler.append("\n");
                }
                throw new Exception(stringBundler.toString());
            }
            if (this._firstSourceMismatchException != null) {
                throw this._firstSourceMismatchException;
            }
        }
        this._progressStatusQueue.put(new ProgressStatusUpdate(ProgressStatus.SOURCE_FORMAT_COMPLETED));
    }

    public List<String> getModifiedFileNames() {
        return this._modifiedFileNames;
    }

    public SourceFormatterArgs getSourceFormatterArgs() {
        return this._sourceFormatterArgs;
    }

    public Set<SourceFormatterMessage> getSourceFormatterMessages() {
        return this._sourceFormatterMessages;
    }

    public SourceMismatchException getSourceMismatchException() {
        return this._firstSourceMismatchException;
    }

    private List<ExcludeSyntaxPattern> _getExcludeSyntaxPatterns(String sourceFormatterExcludes) {
        ArrayList<ExcludeSyntaxPattern> excludeSyntaxPatterns = new ArrayList<ExcludeSyntaxPattern>();
        List<String> excludes = ListUtil.fromString(sourceFormatterExcludes, ",");
        for (String exclude : excludes) {
            excludeSyntaxPatterns.add(new ExcludeSyntaxPattern(ExcludeSyntax.GLOB, exclude));
        }
        String systemExcludes = System.getProperty("source.formatter.excludes");
        excludes = ListUtil.fromString(GetterUtil.getString(systemExcludes));
        for (String exclude : excludes) {
            excludeSyntaxPatterns.add(new ExcludeSyntaxPattern(ExcludeSyntax.GLOB, exclude));
        }
        return excludeSyntaxPatterns;
    }

    private int _getMaxDirLevel() {
        File portalImplDir = SourceFormatterUtil.getFile(this._sourceFormatterArgs.getBaseDirName(), "portal-impl", 7);
        if (portalImplDir != null) {
            return 7;
        }
        return 3;
    }

    private Properties _getProperties(File file) throws Exception {
        Properties properties = new Properties();
        if (file.exists()) {
            properties.load(new FileInputStream(file));
        }
        return properties;
    }

    private void _init() throws Exception {
        this._sourceFormatterExcludes = new SourceFormatterExcludes(SetUtil.fromArray(DEFAULT_EXCLUDE_SYNTAX_PATTERNS));
        String parentDirName = this._sourceFormatterArgs.getBaseDirName();
        for (int i = 0; i < this._getMaxDirLevel(); ++i) {
            this._readProperties(new File(parentDirName + _PROPERTIES_FILE_NAME));
            parentDirName = parentDirName + "../";
        }
        this._allFileNames = SourceFormatterUtil.scanForFiles(this._sourceFormatterArgs.getBaseDirName(), new String[0], new String[]{"**/*.*", "**/CODEOWNERS", "**/Dockerfile"}, this._sourceFormatterExcludes, this._sourceFormatterArgs.isIncludeSubrepositories());
        List<String> modulePropertiesFileNames = SourceFormatterUtil.filterFileNames(this._allFileNames, new String[0], new String[]{"**/source-formatter.properties"}, this._sourceFormatterExcludes, true);
        for (String modulePropertiesFileName : modulePropertiesFileNames) {
            this._readProperties(new File(modulePropertiesFileName));
        }
    }

    private void _printProgressStatusMessage(String message) {
        if (!this._sourceFormatterArgs.isShowStatusUpdates()) {
            return;
        }
        if (message.length() > this._maxStatusMessageLength) {
            this._maxStatusMessageLength = message.length();
        }
        System.out.print(message + "\r");
    }

    private void _readProperties(File propertiesFile) throws Exception {
        Properties properties = this._getProperties(propertiesFile);
        if (properties.isEmpty()) {
            return;
        }
        String propertiesFileLocation = SourceUtil.getAbsolutePath(propertiesFile);
        int pos = propertiesFileLocation.lastIndexOf("/");
        propertiesFileLocation = propertiesFileLocation.substring(0, pos + 1);
        String value = properties.getProperty("source.formatter.excludes");
        if (value == null) {
            this._propertiesMap.put(propertiesFileLocation, properties);
            return;
        }
        if (FileUtil.exists(propertiesFileLocation + "portal-impl")) {
            this._sourceFormatterExcludes.addDefaultExcludeSyntaxPatterns(this._getExcludeSyntaxPatterns(value));
        } else {
            this._sourceFormatterExcludes.addExcludeSyntaxPatterns(propertiesFileLocation, this._getExcludeSyntaxPatterns(value));
        }
        properties.remove("source.formatter.excludes");
        this._propertiesMap.put(propertiesFileLocation, properties);
    }

    private void _runSourceProcessor(SourceProcessor sourceProcessor) throws Exception {
        sourceProcessor.setAllFileNames(this._allFileNames);
        sourceProcessor.setProgressStatusQueue(this._progressStatusQueue);
        sourceProcessor.setPropertiesMap(this._propertiesMap);
        sourceProcessor.setSourceFormatterArgs(this._sourceFormatterArgs);
        sourceProcessor.setSourceFormatterExcludes(this._sourceFormatterExcludes);
        sourceProcessor.format();
        this._sourceFormatterMessages.addAll(sourceProcessor.getSourceFormatterMessages());
        this._modifiedFileNames.addAll(sourceProcessor.getModifiedFileNames());
        if (this._firstSourceMismatchException == null) {
            this._firstSourceMismatchException = sourceProcessor.getFirstSourceMismatchException();
        }
    }
}

