/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.security.permission;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.security.permission.PermissionPropagator;
import com.liferay.portal.kernel.security.permission.ResourceActionsUtil;
import com.liferay.portal.kernel.service.ResourcePermissionLocalServiceUtil;
import com.liferay.portal.kernel.service.ResourcePermissionServiceUtil;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.SetUtil;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.portlet.ActionRequest;

public abstract class BasePermissionPropagator
implements PermissionPropagator {
    protected Set<String> getActionIds(String className) {
        List<String> actionIds = ResourceActionsUtil.getModelResourceActions(className);
        return SetUtil.fromCollection(actionIds);
    }

    protected Set<String> getAvailableActionIds(long companyId, String className, long primKey, long roleId, Set<String> actionIds) throws PortalException {
        List<String> availableActionIds = ResourcePermissionLocalServiceUtil.getAvailableResourcePermissionActionIds(companyId, className, 4, String.valueOf(primKey), roleId, actionIds);
        return SetUtil.fromCollection(availableActionIds);
    }

    protected void propagateRolePermissions(ActionRequest actionRequest, long roleId, String parentClassName, long parentPrimKey, String childClassName, long childPrimKey) throws PortalException {
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        Set<String> parentActionIds = this.getActionIds(parentClassName);
        Set<String> childActionIds = this.getActionIds(childClassName);
        HashSet<String> parentAndChildCommonActionIds = new HashSet<String>();
        for (String actionId : childActionIds) {
            if (!parentActionIds.contains(actionId)) continue;
            parentAndChildCommonActionIds.add(actionId);
        }
        Set<String> parentAvailableActionIds = this.getAvailableActionIds(themeDisplay.getCompanyId(), parentClassName, parentPrimKey, roleId, parentActionIds);
        Set<String> childAvailableActionIds = this.getAvailableActionIds(themeDisplay.getCompanyId(), childClassName, childPrimKey, roleId, childActionIds);
        ArrayList<String> actionIds = new ArrayList<String>();
        for (String actionId : parentAndChildCommonActionIds) {
            if (!parentAvailableActionIds.contains(actionId)) continue;
            actionIds.add(actionId);
        }
        for (String actionId : childAvailableActionIds) {
            if (parentAndChildCommonActionIds.contains(actionId)) continue;
            actionIds.add(actionId);
        }
        ResourcePermissionServiceUtil.setIndividualResourcePermissions(themeDisplay.getScopeGroupId(), themeDisplay.getCompanyId(), childClassName, String.valueOf(childPrimKey), roleId, actionIds.toArray(new String[actionIds.size()]));
    }
}

