/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.concurrent;

import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;

public abstract class ConcurrentMapperHashMap<K, IK, V, IV>
extends AbstractMap<K, V>
implements ConcurrentMap<K, V>,
Serializable {
    protected transient Set<Map.Entry<K, V>> entrySet;
    protected final ConcurrentMap<IK, IV> innerConcurrentMap;
    protected transient Set<K> keySet;
    protected transient Collection<V> values;
    private static final long serialVersionUID = 1L;

    @Override
    public void clear() {
        this.innerConcurrentMap.clear();
    }

    @Override
    public boolean containsKey(Object key) {
        if (key == null) {
            throw new NullPointerException("Key is null");
        }
        return this.innerConcurrentMap.containsKey(this.mapKeyForQuery(key));
    }

    @Override
    public boolean containsValue(Object value) {
        if (value == null) {
            throw new NullPointerException("Value is null");
        }
        return this.innerConcurrentMap.containsValue(this.mapValueForQuery(value));
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        if (this.entrySet == null) {
            this.entrySet = new UnwrapEntrySet();
        }
        return this.entrySet;
    }

    @Override
    public V get(Object key) {
        if (key == null) {
            throw new NullPointerException("Key is null");
        }
        Object innerValue = this.innerConcurrentMap.get(this.mapKeyForQuery(key));
        if (innerValue == null) {
            return null;
        }
        return this.unmapValueForQuery(innerValue);
    }

    @Override
    public boolean isEmpty() {
        return this.innerConcurrentMap.isEmpty();
    }

    @Override
    public Set<K> keySet() {
        if (this.keySet == null) {
            this.keySet = new UnwrapKeySet();
        }
        return this.keySet;
    }

    @Override
    public V put(K key, V value) {
        if (key == null) {
            throw new NullPointerException("Key is null");
        }
        if (value == null) {
            throw new NullPointerException("Value is null");
        }
        IK innerKey = this.mapKey(key);
        IV oldInnerValue = this.innerConcurrentMap.put(innerKey, this.mapValue(key, value));
        if (oldInnerValue == null) {
            return null;
        }
        this.unmapKey(innerKey);
        return this.unmapValue(oldInnerValue);
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map) {
        for (Map.Entry<K, V> entry : map.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public V putIfAbsent(K key, V value) {
        IV innerValue;
        if (key == null) {
            throw new NullPointerException("Key is null");
        }
        if (value == null) {
            throw new NullPointerException("Value is null");
        }
        IK innerKey = this.mapKey(key);
        IV previousInnerValue = this.innerConcurrentMap.putIfAbsent(innerKey, innerValue = this.mapValue(key, value));
        if (previousInnerValue == null) {
            return null;
        }
        this.unmapKey(innerKey);
        this.unmapValue(innerValue);
        return this.unmapValueForQuery(previousInnerValue);
    }

    @Override
    public V remove(Object key) {
        if (key == null) {
            throw new NullPointerException("Key is null");
        }
        IK innerKey = this.mapKeyForQuery(key);
        Object innerValue = this.innerConcurrentMap.remove(innerKey);
        if (innerValue == null) {
            return null;
        }
        return this.unmapValue(innerValue);
    }

    @Override
    public boolean remove(Object key, Object value) {
        Object previousInnerValue;
        if (key == null) {
            throw new NullPointerException("Key is null");
        }
        if (value == null) {
            throw new NullPointerException("Value is null");
        }
        IK innerKey = this.mapKeyForQuery(key);
        IV innerValue = this.mapValueForQuery(value);
        if (!innerValue.equals(previousInnerValue = this.innerConcurrentMap.get(innerKey)) || !this.innerConcurrentMap.remove(innerKey, previousInnerValue)) {
            return false;
        }
        this.unmapValue(previousInnerValue);
        return true;
    }

    @Override
    public V replace(K key, V value) {
        if (key == null) {
            throw new NullPointerException("Key is null");
        }
        if (value == null) {
            throw new NullPointerException("Value is null");
        }
        IV newInnerValue = this.mapValue(key, value);
        IV oldInnerValue = this.innerConcurrentMap.replace(this.mapKeyForQuery(key), newInnerValue);
        if (oldInnerValue == null) {
            this.unmapValue(newInnerValue);
            return null;
        }
        return this.unmapValue(oldInnerValue);
    }

    @Override
    public boolean replace(K key, V oldValue, V newValue) {
        if (key == null) {
            throw new NullPointerException("Key is null");
        }
        if (oldValue == null) {
            throw new NullPointerException("Old value is null");
        }
        if (newValue == null) {
            throw new NullPointerException("New value is null");
        }
        IK innerKey = this.mapKeyForQuery(key);
        IV newInnerValue = this.mapValue(key, newValue);
        Object oldInnerValue = this.innerConcurrentMap.get(innerKey);
        if (oldInnerValue == null || !oldValue.equals(this.unmapValueForQuery(oldInnerValue))) {
            this.unmapValue(newInnerValue);
            return false;
        }
        if (this.innerConcurrentMap.replace(innerKey, oldInnerValue, newInnerValue)) {
            this.unmapValue(oldInnerValue);
            return true;
        }
        this.unmapValue(newInnerValue);
        return false;
    }

    @Override
    public int size() {
        return this.innerConcurrentMap.size();
    }

    @Override
    public Collection<V> values() {
        if (this.values == null) {
            this.values = new UnwrapValues();
        }
        return this.values;
    }

    protected ConcurrentMapperHashMap(ConcurrentMap<IK, IV> innerConcurrentMap) {
        this.innerConcurrentMap = innerConcurrentMap;
    }

    protected abstract IK mapKey(K var1);

    protected abstract IK mapKeyForQuery(K var1);

    protected abstract IV mapValue(K var1, V var2);

    protected abstract IV mapValueForQuery(V var1);

    protected abstract K unmapKey(IK var1);

    protected abstract K unmapKeyForQuery(IK var1);

    protected abstract V unmapValue(IV var1);

    protected abstract V unmapValueForQuery(IV var1);

    private class UnwrapValues
    extends AbstractCollection<V> {
        private UnwrapValues() {
        }

        @Override
        public void clear() {
            ConcurrentMapperHashMap.this.clear();
        }

        @Override
        public boolean contains(Object obj) {
            return ConcurrentMapperHashMap.this.containsValue(obj);
        }

        @Override
        public boolean isEmpty() {
            return ConcurrentMapperHashMap.this.isEmpty();
        }

        @Override
        public Iterator<V> iterator() {
            return new UnwrapValueIterator();
        }

        @Override
        public int size() {
            return ConcurrentMapperHashMap.this.size();
        }
    }

    private class UnwrapValueIterator
    implements Iterator<V> {
        private final Iterator<IV> _iterator;

        public UnwrapValueIterator() {
            Collection values = ConcurrentMapperHashMap.this.innerConcurrentMap.values();
            this._iterator = values.iterator();
        }

        @Override
        public boolean hasNext() {
            return this._iterator.hasNext();
        }

        @Override
        public V next() {
            return ConcurrentMapperHashMap.this.unmapValueForQuery(this._iterator.next());
        }

        @Override
        public void remove() {
            this._iterator.remove();
        }
    }

    private class UnwrapKeySet
    extends AbstractSet<K> {
        private UnwrapKeySet() {
        }

        @Override
        public void clear() {
            ConcurrentMapperHashMap.this.clear();
        }

        @Override
        public boolean contains(Object o) {
            return ConcurrentMapperHashMap.this.containsKey(o);
        }

        @Override
        public boolean isEmpty() {
            return ConcurrentMapperHashMap.this.isEmpty();
        }

        @Override
        public Iterator<K> iterator() {
            return new UnwrapKeyIterator();
        }

        @Override
        public boolean remove(Object o) {
            return ConcurrentMapperHashMap.this.remove(o) != null;
        }

        @Override
        public int size() {
            return ConcurrentMapperHashMap.this.size();
        }
    }

    private class UnwrapKeyIterator
    implements Iterator<K> {
        private final Iterator<IK> _iterator;

        public UnwrapKeyIterator() {
            Set keySet = ConcurrentMapperHashMap.this.innerConcurrentMap.keySet();
            this._iterator = keySet.iterator();
        }

        @Override
        public boolean hasNext() {
            return this._iterator.hasNext();
        }

        @Override
        public K next() {
            return ConcurrentMapperHashMap.this.unmapKeyForQuery(this._iterator.next());
        }

        @Override
        public void remove() {
            this._iterator.remove();
        }
    }

    private class UnwrapEntrySet
    extends AbstractSet<Map.Entry<K, V>> {
        private UnwrapEntrySet() {
        }

        @Override
        public void clear() {
            ConcurrentMapperHashMap.this.clear();
        }

        @Override
        public boolean contains(Object obj) {
            if (!(obj instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)obj;
            Object value = ConcurrentMapperHashMap.this.get(entry.getKey());
            return value != null && value.equals(entry.getValue());
        }

        @Override
        public boolean isEmpty() {
            return ConcurrentMapperHashMap.this.isEmpty();
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            return new UnwrapEntryIterator();
        }

        @Override
        public boolean remove(Object obj) {
            if (!(obj instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)obj;
            return ConcurrentMapperHashMap.this.remove(entry.getKey(), entry.getValue());
        }

        @Override
        public int size() {
            return ConcurrentMapperHashMap.this.size();
        }
    }

    private class UnwrapEntryIterator
    implements Iterator<Map.Entry<K, V>> {
        private final Iterator<Map.Entry<IK, IV>> _iterator;

        public UnwrapEntryIterator() {
            Set entrySet = ConcurrentMapperHashMap.this.innerConcurrentMap.entrySet();
            this._iterator = entrySet.iterator();
        }

        @Override
        public boolean hasNext() {
            return this._iterator.hasNext();
        }

        @Override
        public Map.Entry<K, V> next() {
            return new UnwrapEntry(this._iterator.next());
        }

        @Override
        public void remove() {
            this._iterator.remove();
        }
    }

    private class UnwrapEntry
    implements Map.Entry<K, V> {
        private final Map.Entry<IK, IV> _innerEntry;

        public UnwrapEntry(Map.Entry<IK, IV> innerEntry) {
            this._innerEntry = innerEntry;
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)obj;
            return Objects.equals(this.getKey(), entry.getKey()) && Objects.equals(this.getValue(), entry.getValue());
        }

        @Override
        public K getKey() {
            return ConcurrentMapperHashMap.this.unmapKeyForQuery(this._innerEntry.getKey());
        }

        @Override
        public V getValue() {
            return ConcurrentMapperHashMap.this.unmapValueForQuery(this._innerEntry.getValue());
        }

        @Override
        public int hashCode() {
            return this._innerEntry.hashCode();
        }

        @Override
        public V setValue(V value) {
            Object key = this.getKey();
            Object v = ConcurrentMapperHashMap.this.unmapValueForQuery(this._innerEntry.setValue(ConcurrentMapperHashMap.this.mapValueForQuery(value)));
            ConcurrentMapperHashMap.this.put(key, value);
            return v;
        }
    }
}

