/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.document.library.kernel.util.comparator;

import com.liferay.document.library.kernel.model.DLFileEntry;
import com.liferay.document.library.kernel.model.DLFileShortcut;
import com.liferay.document.library.kernel.model.DLFolder;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.repository.model.FileShortcut;
import com.liferay.portal.kernel.repository.model.Folder;
import com.liferay.portal.kernel.util.OrderByComparator;

public class RepositoryModelTitleComparator<T>
extends OrderByComparator<T> {
    public static final String ORDER_BY_ASC = "title ASC";
    public static final String ORDER_BY_DESC = "title DESC";
    public static final String[] ORDER_BY_FIELDS = new String[]{"title"};
    public static final String ORDER_BY_MODEL_ASC = "modelFolder DESC, title ASC";
    public static final String ORDER_BY_MODEL_DESC = "modelFolder DESC, title DESC";
    private final boolean _ascending;
    private final boolean _orderByModel;

    public RepositoryModelTitleComparator() {
        this(false);
    }

    public RepositoryModelTitleComparator(boolean ascending) {
        this._ascending = ascending;
        this._orderByModel = false;
    }

    public RepositoryModelTitleComparator(boolean ascending, boolean orderByModel) {
        this._ascending = ascending;
        this._orderByModel = orderByModel;
    }

    @Override
    public int compare(T t1, T t2) {
        int value = 0;
        String name1 = this.getName(t1);
        String name2 = this.getName(t2);
        if (this._orderByModel) {
            if ((t1 instanceof DLFolder || t1 instanceof Folder) && (t2 instanceof DLFolder || t2 instanceof Folder)) {
                name1.compareToIgnoreCase(name2);
            } else if (t1 instanceof DLFolder || t1 instanceof Folder) {
                value = -1;
            } else if (t2 instanceof DLFolder || t2 instanceof Folder) {
                value = 1;
            } else {
                name1.compareToIgnoreCase(name2);
            }
        } else {
            value = name1.compareToIgnoreCase(name2);
        }
        if (this._ascending) {
            return value;
        }
        return -value;
    }

    @Override
    public String getOrderBy() {
        if (this._orderByModel) {
            if (this._ascending) {
                return ORDER_BY_MODEL_ASC;
            }
            return ORDER_BY_MODEL_DESC;
        }
        if (this._ascending) {
            return ORDER_BY_ASC;
        }
        return ORDER_BY_DESC;
    }

    @Override
    public String[] getOrderByFields() {
        return ORDER_BY_FIELDS;
    }

    @Override
    public boolean isAscending() {
        return this._ascending;
    }

    protected String getName(Object obj) {
        if (obj instanceof DLFileEntry) {
            DLFileEntry dlFileEntry = (DLFileEntry)obj;
            return dlFileEntry.getTitle();
        }
        if (obj instanceof DLFileShortcut) {
            DLFileShortcut dlFileShortcut = (DLFileShortcut)obj;
            return dlFileShortcut.getToTitle();
        }
        if (obj instanceof DLFolder) {
            DLFolder dlFolder = (DLFolder)obj;
            return dlFolder.getName();
        }
        if (obj instanceof FileEntry) {
            FileEntry fileEntry = (FileEntry)obj;
            return fileEntry.getTitle();
        }
        if (obj instanceof FileShortcut) {
            FileShortcut fileShortcut = (FileShortcut)obj;
            return fileShortcut.getToTitle();
        }
        Folder folder = (Folder)obj;
        return folder.getName();
    }
}

