/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.asset.kernel.model;

import com.liferay.asset.kernel.model.AssetRenderer;
import com.liferay.asset.kernel.model.BaseAssetRenderer;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.portlet.PortletBag;
import com.liferay.portal.kernel.portlet.PortletBagPool;
import com.liferay.portal.kernel.util.AggregateResourceBundleLoader;
import com.liferay.portal.kernel.util.ClassResourceBundleLoader;
import com.liferay.portal.kernel.util.ResourceBundleLoader;
import com.liferay.portal.kernel.util.ResourceBundleLoaderUtil;
import com.liferay.portal.kernel.util.Validator;
import java.io.IOException;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public abstract class BaseJSPAssetRenderer<T>
extends BaseAssetRenderer<T>
implements AssetRenderer<T> {
    private static final Log _log = LogFactoryUtil.getLog(BaseJSPAssetRenderer.class);
    private ServletContext _servletContext;

    public abstract String getJspPath(HttpServletRequest var1, String var2);

    @Override
    public boolean include(HttpServletRequest request, HttpServletResponse response, String template) throws Exception {
        ServletContext servletContext = this.getServletContext();
        String jspPath = this.getJspPath(request, template);
        if (Validator.isNull(jspPath)) {
            return false;
        }
        ResourceBundleLoader resourceBundleLoader = (ResourceBundleLoader)request.getAttribute("RESOURCE_BUNDLE_LOADER");
        RequestDispatcher requestDispatcher = servletContext.getRequestDispatcher(jspPath);
        try {
            request.setAttribute("RESOURCE_BUNDLE_LOADER", (Object)this.getResourceBundleLoader());
            requestDispatcher.include((ServletRequest)request, (ServletResponse)response);
            boolean bl = true;
            return bl;
        }
        catch (ServletException se) {
            _log.error("Unable to include JSP " + jspPath, se);
            throw new IOException("Unable to include " + jspPath, se);
        }
        finally {
            request.setAttribute("RESOURCE_BUNDLE_LOADER", (Object)resourceBundleLoader);
        }
    }

    public void setServletContext(ServletContext servletContext) {
        this._servletContext = servletContext;
    }

    protected ResourceBundleLoader getResourceBundleLoader() {
        if (this._servletContext != null) {
            return ResourceBundleLoaderUtil.getResourceBundleLoaderByServletContextName(this._servletContext.getServletContextName());
        }
        return new AggregateResourceBundleLoader(new ClassResourceBundleLoader("content.Language", this.getClass()), ResourceBundleLoaderUtil.getPortalResourceBundleLoader());
    }

    protected ServletContext getServletContext() {
        if (this._servletContext != null) {
            return this._servletContext;
        }
        String portletId = this.getAssetRendererFactory().getPortletId();
        PortletBag portletBag = PortletBagPool.get(portletId);
        return portletBag.getServletContext();
    }
}

