/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.exportimport.service.impl;

import com.liferay.exportimport.kernel.lar.MissingReferences;
import com.liferay.exportimport.kernel.lar.PortletDataContext;
import com.liferay.exportimport.kernel.lifecycle.ExportImportLifecycleManagerUtil;
import com.liferay.exportimport.kernel.model.ExportImportConfiguration;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.portletfilerepository.PortletFileRepositoryUtil;
import com.liferay.portal.kernel.repository.model.Folder;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.service.permission.GroupPermissionUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portlet.exportimport.service.base.StagingServiceBaseImpl;
import java.io.Serializable;
import java.util.List;
import java.util.Map;

public class StagingServiceImpl
extends StagingServiceBaseImpl {
    public void cleanUpStagingRequest(long stagingRequestId) throws PortalException {
        this.checkPermission(stagingRequestId);
        this.stagingLocalService.cleanUpStagingRequest(stagingRequestId);
    }

    public long createStagingRequest(long groupId, String checksum) throws PortalException {
        GroupPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)groupId, (String)"EXPORT_IMPORT_LAYOUTS");
        return this.stagingLocalService.createStagingRequest(this.getUserId(), groupId, checksum);
    }

    public boolean hasRemoteLayout(String uuid, long groupId, boolean privateLayout) throws PortalException {
        GroupPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)groupId, (String)"EXPORT_IMPORT_LAYOUTS");
        return this.layoutLocalService.hasLayout(uuid, groupId, privateLayout);
    }

    public void propagateExportImportLifecycleEvent(int code, int processFlag, String processId, List<Serializable> arguments) throws PortalException {
        Serializable serializable = arguments.get(0);
        long groupId = 0L;
        if (serializable instanceof PortletDataContext) {
            PortletDataContext portletDataContext = (PortletDataContext)serializable;
            groupId = portletDataContext.getGroupId();
        } else if (serializable instanceof ExportImportConfiguration) {
            ExportImportConfiguration exportImportConfiguration = (ExportImportConfiguration)serializable;
            groupId = MapUtil.getLong((Map)exportImportConfiguration.getSettingsMap(), (String)"targetGroupId");
        }
        GroupPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)groupId, (String)"EXPORT_IMPORT_LAYOUTS");
        ExportImportLifecycleManagerUtil.fireExportImportLifecycleEvent((int)code, (int)processFlag, (String)processId, (Serializable[])arguments.toArray(new Serializable[arguments.size()]));
    }

    @Deprecated
    public MissingReferences publishStagingRequest(long stagingRequestId, boolean privateLayout, Map<String, String[]> parameterMap) throws PortalException {
        this.checkPermission(stagingRequestId);
        return this.stagingLocalService.publishStagingRequest(this.getUserId(), stagingRequestId, privateLayout, parameterMap);
    }

    public MissingReferences publishStagingRequest(long stagingRequestId, ExportImportConfiguration exportImportConfiguration) throws PortalException {
        this.checkPermission(stagingRequestId);
        return this.stagingLocalService.publishStagingRequest(this.getUserId(), stagingRequestId, exportImportConfiguration);
    }

    public void updateStagingRequest(long stagingRequestId, String fileName, byte[] bytes) throws PortalException {
        this.checkPermission(stagingRequestId);
        this.stagingLocalService.updateStagingRequest(this.getUserId(), stagingRequestId, fileName, bytes);
    }

    @Deprecated
    public MissingReferences validateStagingRequest(long stagingRequestId, boolean privateLayout, Map<String, String[]> parameterMap) throws PortalException {
        this.checkPermission(stagingRequestId);
        return this.stagingLocalService.validateStagingRequest(this.getUserId(), stagingRequestId, privateLayout, parameterMap);
    }

    protected void checkPermission(long stagingRequestId) throws PortalException {
        Folder folder = PortletFileRepositoryUtil.getPortletFolder((long)stagingRequestId);
        GroupPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)folder.getGroupId(), (String)"EXPORT_IMPORT_LAYOUTS");
    }
}

