/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.documentlibrary.util;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portlet.documentlibrary.util.LiferayConverter;
import com.xuggle.ferry.RefCounted;
import com.xuggle.xuggler.ICodec;
import com.xuggle.xuggler.IContainer;
import com.xuggle.xuggler.IPacket;
import com.xuggle.xuggler.IPixelFormat;
import com.xuggle.xuggler.IStream;
import com.xuggle.xuggler.IStreamCoder;
import com.xuggle.xuggler.IVideoPicture;
import java.io.File;

public class LiferayVideoThumbnailConverter
extends LiferayConverter {
    private static final Log _log = LogFactoryUtil.getLog(LiferayVideoThumbnailConverter.class);
    private final String _extension;
    private final int _height;
    private IContainer _inputIContainer;
    private final String _inputURL;
    private final File _outputFile;
    private final int _percentage;
    private final int _width;

    public LiferayVideoThumbnailConverter(String inputURL, File outputFile, String extension, int height, int width, int percentage) {
        this._inputURL = inputURL;
        this._outputFile = outputFile;
        this._extension = extension;
        this._height = height;
        this._width = width;
        this._percentage = percentage;
    }

    @Override
    public void convert() throws Exception {
        try {
            this.doConvert();
        }
        finally {
            if (this._inputIContainer != null && this._inputIContainer.isOpened()) {
                this._inputIContainer.close();
            }
        }
    }

    protected void doConvert() throws Exception {
        int inputStreamsCount;
        this._inputIContainer = IContainer.make();
        this.openContainer(this._inputIContainer, this._inputURL, false);
        long seekTimeStamp = -1L;
        if (this._percentage > 0 && this._percentage <= 100) {
            seekTimeStamp = this.getSeekTimeStamp(this._percentage);
        }
        if ((inputStreamsCount = this._inputIContainer.getNumStreams()) < 0) {
            throw new RuntimeException("Input URL does not have any streams");
        }
        IVideoPicture[] inputIVideoPictures = new IVideoPicture[inputStreamsCount];
        IStreamCoder[] inputIStreamCoders = new IStreamCoder[inputStreamsCount];
        for (int i = 0; i < inputStreamsCount; ++i) {
            IStreamCoder inputIStreamCoder;
            IStream inputIStream = this._inputIContainer.getStream((long)i);
            inputIStreamCoders[i] = inputIStreamCoder = inputIStream.getStreamCoder();
            if (inputIStreamCoder.getCodecType() == ICodec.Type.CODEC_TYPE_VIDEO) {
                inputIVideoPictures[i] = IVideoPicture.make((IPixelFormat.Type)inputIStreamCoder.getPixelType(), (int)inputIStreamCoder.getWidth(), (int)inputIStreamCoder.getHeight());
            }
            this.openStreamCoder(inputIStreamCoder);
        }
        boolean thumbnailGenerated = false;
        try {
            if (seekTimeStamp != -1L) {
                this.rewind();
                this.seek(seekTimeStamp);
            }
            thumbnailGenerated = this.generateThumbnail(inputIStreamCoders, inputIVideoPictures);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (!thumbnailGenerated) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)"Unable to create thumbnail from specified frame. Will generate thumbnail from the beginning.");
            }
            this.rewind();
            this.generateThumbnail(inputIStreamCoders, inputIVideoPictures);
        }
        this.cleanUp((RefCounted[])inputIVideoPictures, null);
        this.cleanUp(inputIStreamCoders, null);
    }

    protected boolean generateThumbnail(IStreamCoder[] inputIStreamCoders, IVideoPicture[] inputIVideoPictures) throws Exception {
        boolean keyPacketFound = false;
        int nonKeyAfterKeyCount = 0;
        boolean onlyDecodeKeyPackets = false;
        IPacket inputIPacket = IPacket.make();
        while (this._inputIContainer.readNextPacket(inputIPacket) == 0) {
            int streamIndex;
            IStreamCoder inputIStreamCoder;
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Current packet size " + inputIPacket.getSize()));
            }
            if ((inputIStreamCoder = inputIStreamCoders[streamIndex = inputIPacket.getStreamIndex()]).getCodecType() != ICodec.Type.CODEC_TYPE_VIDEO) continue;
            if (this.isStartDecoding(inputIPacket, inputIStreamCoder, keyPacketFound = this.isKeyPacketFound(inputIPacket, keyPacketFound), nonKeyAfterKeyCount = this.countNonKeyAfterKey(inputIPacket, keyPacketFound, nonKeyAfterKeyCount), onlyDecodeKeyPackets)) {
                IStream iStream = this._inputIContainer.getStream((long)streamIndex);
                long timeStampOffset = this.getStreamTimeStampOffset(iStream);
                int value = this.decodeVideo(null, inputIVideoPictures[streamIndex], null, inputIPacket, null, inputIStreamCoder, null, null, this._outputFile, this._extension, this._height, this._width, timeStampOffset);
                if (value <= 0) {
                    if (inputIPacket.isKey()) {
                        throw new RuntimeException("Unable to decode video stream " + streamIndex);
                    }
                    onlyDecodeKeyPackets = true;
                    continue;
                }
                if (value != 2) continue;
                this.cleanUp(inputIPacket, null);
                return true;
            }
            if (!_log.isDebugEnabled()) continue;
            _log.debug((Object)("Do not decode video stream " + streamIndex));
        }
        this.cleanUp(inputIPacket, null);
        return false;
    }

    @Override
    protected IContainer getInputIContainer() {
        return this._inputIContainer;
    }
}

