/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.documentlibrary.util;

import com.liferay.document.library.kernel.exception.NoSuchFileEntryException;
import com.liferay.document.library.kernel.store.DLStoreUtil;
import com.liferay.document.library.kernel.util.DLPreviewableProcessor;
import com.liferay.document.library.kernel.util.ImageProcessor;
import com.liferay.exportimport.kernel.lar.PortletDataContext;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.image.ImageToolUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.repository.model.FileVersion;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.kernel.util.StreamUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.util.PropsValues;
import java.awt.image.RenderedImage;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.Set;
import java.util.Vector;

public class ImageProcessorImpl
extends DLPreviewableProcessor
implements ImageProcessor {
    private static final Log _log = LogFactoryUtil.getLog(ImageProcessorImpl.class);
    private final List<Long> _fileVersionIds = new Vector<Long>();
    private final Set<String> _imageMimeTypes = SetUtil.fromArray((Object[])PropsValues.DL_FILE_ENTRY_PREVIEW_IMAGE_MIME_TYPES);

    public void afterPropertiesSet() {
    }

    public void cleanUp(FileEntry fileEntry) {
        this.deleteFiles(fileEntry, null);
    }

    public void cleanUp(FileVersion fileVersion) {
        String type = this.getThumbnailType(fileVersion);
        this.deleteFiles(fileVersion, type);
    }

    public void generateImages(FileVersion sourceFileVersion, FileVersion destinationFileVersion) throws Exception {
        this._generateImages(sourceFileVersion, destinationFileVersion);
    }

    public Set<String> getImageMimeTypes() {
        return this._imageMimeTypes;
    }

    public InputStream getPreviewAsStream(FileVersion fileVersion) throws Exception {
        if (this._previewGenerationRequired(fileVersion)) {
            String type = this.getPreviewType(fileVersion);
            return this.doGetPreviewAsStream(fileVersion, type);
        }
        return fileVersion.getContentStream(false);
    }

    public long getPreviewFileSize(FileVersion fileVersion) throws Exception {
        if (this._previewGenerationRequired(fileVersion)) {
            String type = this.getPreviewType(fileVersion);
            return this.doGetPreviewFileSize(fileVersion, type);
        }
        return fileVersion.getSize();
    }

    public String getPreviewType(FileVersion fileVersion) {
        return this._getType(fileVersion);
    }

    public InputStream getThumbnailAsStream(FileVersion fileVersion, int index) throws Exception {
        return this.doGetThumbnailAsStream(fileVersion, index);
    }

    public long getThumbnailFileSize(FileVersion fileVersion, int index) throws Exception {
        return this.doGetThumbnailFileSize(fileVersion, index);
    }

    public String getThumbnailType(FileVersion fileVersion) {
        return this._getType(fileVersion);
    }

    public String getType() {
        return "ImageProcessor";
    }

    public boolean hasImages(FileVersion fileVersion) {
        if (!PropsValues.DL_FILE_ENTRY_PREVIEW_ENABLED && !PropsValues.DL_FILE_ENTRY_THUMBNAIL_ENABLED) {
            return false;
        }
        if (fileVersion.getSize() == 0L) {
            return false;
        }
        boolean hasImages = false;
        try {
            if (this._hasPreview(fileVersion) && this.hasThumbnails(fileVersion)) {
                hasImages = true;
            }
            if (!hasImages && this.isSupported(fileVersion)) {
                this._queueGeneration(null, fileVersion);
            }
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
        }
        return hasImages;
    }

    public boolean isImageSupported(FileVersion fileVersion) {
        return this.isSupported(fileVersion);
    }

    public boolean isImageSupported(String mimeType) {
        return this.isSupported(mimeType);
    }

    public boolean isSupported(String mimeType) {
        return this._imageMimeTypes.contains(mimeType);
    }

    public void storeThumbnail(long companyId, long groupId, long fileEntryId, long fileVersionId, long custom1ImageId, long custom2ImageId, InputStream is, String type) throws Exception {
        this._storeThumbnail(companyId, groupId, fileEntryId, fileVersionId, custom1ImageId, custom2ImageId, is, type);
    }

    public void trigger(FileVersion sourceFileVersion, FileVersion destinationFileVersion) {
        super.trigger(sourceFileVersion, destinationFileVersion);
        this._queueGeneration(sourceFileVersion, destinationFileVersion);
    }

    protected void doExportGeneratedFiles(PortletDataContext portletDataContext, FileEntry fileEntry, Element fileEntryElement) throws Exception {
        this.exportThumbnails(portletDataContext, fileEntry, fileEntryElement, "image");
        this.exportPreview(portletDataContext, fileEntry, fileEntryElement);
    }

    protected void doImportGeneratedFiles(PortletDataContext portletDataContext, FileEntry fileEntry, FileEntry importedFileEntry, Element fileEntryElement) throws Exception {
        this.importThumbnails(portletDataContext, fileEntry, importedFileEntry, fileEntryElement, "image");
        FileVersion importedFileVersion = importedFileEntry.getFileVersion();
        if (!this._previewGenerationRequired(importedFileVersion)) {
            return;
        }
        this.importPreview(portletDataContext, fileEntry, importedFileEntry, fileEntryElement, "image", this.getPreviewType(importedFileVersion));
    }

    protected void exportPreview(PortletDataContext portletDataContext, FileEntry fileEntry, Element fileEntryElement) throws Exception {
        FileVersion fileVersion = fileEntry.getFileVersion();
        if (!(this.isSupported(fileVersion) && this._previewGenerationRequired(fileVersion) && this._hasPreview(fileVersion))) {
            return;
        }
        this.exportPreview(portletDataContext, fileEntry, fileEntryElement, "image", this.getPreviewType(fileVersion));
    }

    protected List<Long> getFileVersionIds() {
        return this._fileVersionIds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private void _generateImages(FileVersion sourceFileVersion, FileVersion destinationFileVersion) throws Exception {
        block14: {
            block13: {
                block12: {
                    block11: {
                        block10: {
                            inputStream = null;
                            if (sourceFileVersion == null) break block10;
                            this.copy(sourceFileVersion, destinationFileVersion);
                            StreamUtil.cleanUp((Closeable[])new Closeable[]{inputStream});
                            this._fileVersionIds.remove(destinationFileVersion.getFileVersionId());
                            return;
                        }
                        if (PropsValues.DL_FILE_ENTRY_THUMBNAIL_ENABLED || PropsValues.DL_FILE_ENTRY_PREVIEW_ENABLED) break block11;
                        StreamUtil.cleanUp((Closeable[])new Closeable[]{inputStream});
                        this._fileVersionIds.remove(destinationFileVersion.getFileVersionId());
                        return;
                    }
                    inputStream = destinationFileVersion.getContentStream(false);
                    bytes = FileUtil.getBytes((InputStream)inputStream);
                    imageBag = ImageToolUtil.read((byte[])bytes);
                    renderedImage = imageBag.getRenderedImage();
                    if (renderedImage != null) break block12;
                    StreamUtil.cleanUp((Closeable[])new Closeable[]{inputStream});
                    this._fileVersionIds.remove(destinationFileVersion.getFileVersionId());
                    return;
                }
                colorModel = renderedImage.getColorModel();
                if (colorModel.getNumColorComponents() != 4) ** GOTO lbl45
                future = ImageToolUtil.convertCMYKtoRGB((byte[])bytes, (String)imageBag.getType());
                if (future != null) break block13;
                StreamUtil.cleanUp((Closeable[])new Closeable[]{inputStream});
                this._fileVersionIds.remove(destinationFileVersion.getFileVersionId());
                return;
            }
            try {
                processIdentity = String.valueOf(destinationFileVersion.getFileVersionId());
                this.futures.put(processIdentity, future);
                convertedRenderedImage = (RenderedImage)future.get();
                if (convertedRenderedImage != null) {
                    renderedImage = convertedRenderedImage;
                }
lbl45:
                // 4 sources

                if (!this._hasPreview(destinationFileVersion)) {
                    this._storePreviewImage(destinationFileVersion, renderedImage);
                }
                if (this.hasThumbnails(destinationFileVersion)) break block14;
                this.storeThumbnailImages(destinationFileVersion, renderedImage);
            }
            catch (NoSuchFileEntryException nsfee) {
                block15: {
                    try {
                        if (!ImageProcessorImpl._log.isDebugEnabled()) break block15;
                        ImageProcessorImpl._log.debug((Object)nsfee, (Throwable)nsfee);
                    }
                    catch (Throwable var11_12) {
                        StreamUtil.cleanUp((Closeable[])new Closeable[]{inputStream});
                        this._fileVersionIds.remove(destinationFileVersion.getFileVersionId());
                        throw var11_12;
                    }
                }
                StreamUtil.cleanUp((Closeable[])new Closeable[]{inputStream});
                this._fileVersionIds.remove(destinationFileVersion.getFileVersionId());
            }
        }
        StreamUtil.cleanUp((Closeable[])new Closeable[]{inputStream});
        this._fileVersionIds.remove(destinationFileVersion.getFileVersionId());
    }

    private String _getType(FileVersion fileVersion) {
        String type = "png";
        if (fileVersion == null) {
            return type;
        }
        String mimeType = fileVersion.getMimeType();
        if (mimeType.equals("image/bmp")) {
            type = "bmp";
        } else if (mimeType.equals("image/gif")) {
            type = "gif";
        } else if (mimeType.equals("image/jpeg")) {
            type = "jpg";
        } else if (mimeType.equals("image/png")) {
            type = "png";
        } else if (!this._previewGenerationRequired(fileVersion)) {
            type = fileVersion.getExtension();
        }
        return type;
    }

    private boolean _hasPreview(FileVersion fileVersion) throws PortalException {
        if (PropsValues.DL_FILE_ENTRY_PREVIEW_ENABLED && this._previewGenerationRequired(fileVersion)) {
            String type = this.getPreviewType(fileVersion);
            String previewFilePath = this.getPreviewFilePath(fileVersion, type);
            if (!DLStoreUtil.hasFile((long)fileVersion.getCompanyId(), (long)0L, (String)previewFilePath)) {
                return false;
            }
        }
        return true;
    }

    private boolean _previewGenerationRequired(FileVersion fileVersion) {
        String mimeType = fileVersion.getMimeType();
        return mimeType.contains("tiff") || mimeType.contains("tif");
    }

    private void _queueGeneration(FileVersion sourceFileVersion, FileVersion destinationFileVersion) {
        if (this._fileVersionIds.contains(destinationFileVersion.getFileVersionId()) || !this.isSupported(destinationFileVersion)) {
            return;
        }
        this._fileVersionIds.add(destinationFileVersion.getFileVersionId());
        this.sendGenerationMessage("liferay/document_library_image_processor", sourceFileVersion, destinationFileVersion);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _storePreviewImage(FileVersion fileVersion, RenderedImage renderedImage) throws Exception {
        String type = this.getPreviewType(fileVersion);
        File file = null;
        try {
            file = FileUtil.createTempFile((String)type);
            try (FileOutputStream fos = new FileOutputStream(file);){
                ImageToolUtil.write((RenderedImage)renderedImage, (String)type, (OutputStream)fos);
            }
            this.addFileToStore(fileVersion.getCompanyId(), "document_preview/", this.getPreviewFilePath(fileVersion, type), file);
        }
        finally {
            FileUtil.delete((File)file);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _storeThumbnail(long companyId, long groupId, long fileEntryId, long fileVersionId, long custom1ImageId, long custom2ImageId, InputStream is, String type) throws Exception {
        StringBundler sb = new StringBundler(5);
        sb.append(ImageProcessorImpl.getPathSegment((long)groupId, (long)fileEntryId, (long)fileVersionId, (boolean)false));
        if (custom1ImageId != 0L) {
            sb.append("-");
            sb.append(1);
        } else if (custom2ImageId != 0L) {
            sb.append("-");
            sb.append(2);
        }
        if (Validator.isNotNull((String)type)) {
            sb.append(".");
            sb.append(type);
        }
        String filePath = sb.toString();
        File file = null;
        try {
            file = FileUtil.createTempFile((InputStream)is);
            this.addFileToStore(companyId, "document_thumbnail/", filePath, file);
        }
        finally {
            FileUtil.delete((File)file);
        }
    }
}

