/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.documentlibrary.util;

import com.liferay.document.library.kernel.model.DLFileEntryConstants;
import com.liferay.document.library.kernel.model.DLFileEntryType;
import com.liferay.document.library.kernel.model.DLFileShortcut;
import com.liferay.document.library.kernel.model.DLFileVersion;
import com.liferay.document.library.kernel.model.DLFolder;
import com.liferay.document.library.kernel.model.DLFolderConstants;
import com.liferay.document.library.kernel.service.DLAppLocalServiceUtil;
import com.liferay.document.library.kernel.service.DLFolderLocalServiceUtil;
import com.liferay.document.library.kernel.util.DL;
import com.liferay.document.library.kernel.util.ImageProcessorUtil;
import com.liferay.document.library.kernel.util.PDFProcessorUtil;
import com.liferay.document.library.kernel.util.VideoProcessorUtil;
import com.liferay.document.library.kernel.util.comparator.RepositoryModelCreateDateComparator;
import com.liferay.document.library.kernel.util.comparator.RepositoryModelModifiedDateComparator;
import com.liferay.document.library.kernel.util.comparator.RepositoryModelReadCountComparator;
import com.liferay.document.library.kernel.util.comparator.RepositoryModelSizeComparator;
import com.liferay.document.library.kernel.util.comparator.RepositoryModelTitleComparator;
import com.liferay.portal.kernel.configuration.Filter;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Subscription;
import com.liferay.portal.kernel.portlet.PortletLayoutFinder;
import com.liferay.portal.kernel.portlet.PortletProvider;
import com.liferay.portal.kernel.portlet.PortletProviderUtil;
import com.liferay.portal.kernel.portlet.PortletURLFactoryUtil;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.repository.model.FileVersion;
import com.liferay.portal.kernel.repository.model.Folder;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.Hits;
import com.liferay.portal.kernel.service.GroupLocalServiceUtil;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.SubscriptionLocalServiceUtil;
import com.liferay.portal.kernel.service.WorkflowDefinitionLinkLocalServiceUtil;
import com.liferay.portal.kernel.theme.PortletDisplay;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HtmlUtil;
import com.liferay.portal.kernel.util.HttpUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.PrefsPropsUtil;
import com.liferay.portal.kernel.util.PropsUtil;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.URLCodec;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.workflow.WorkflowHandlerRegistryUtil;
import com.liferay.portal.util.PropsValues;
import com.liferay.portlet.documentlibrary.webdav.DLWebDAVUtil;
import com.liferay.registry.collections.ServiceTrackerCollections;
import com.liferay.registry.collections.ServiceTrackerList;
import com.liferay.trash.kernel.util.TrashUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import javax.portlet.PortletRequest;
import javax.portlet.PortletURL;
import javax.servlet.http.HttpServletRequest;

public class DLImpl
implements DL {
    private static final String _DEFAULT_FILE_ICON = "page";
    private static final String _DEFAULT_GENERIC_NAME = "default";
    private static final long _DIVISOR = 256L;
    private static final String[] _MICROSOFT_OFFICE_EXTENSIONS;
    private static final String _STRUCTURE_KEY_PREFIX = "AUTO_";
    private static final Log _log;
    private static final Set<String> _allMediaGalleryMimeTypes;
    private static final Set<String> _fileIcons;
    private static final Map<String, String> _genericNames;
    private final ServiceTrackerList<PortletLayoutFinder> _serviceTrackerList = ServiceTrackerCollections.openList(PortletLayoutFinder.class, (String)("(model.class.name=" + FileEntry.class.getName() + ")"));

    public int compareVersions(String version1, String version2) {
        int[] splitVersion1 = StringUtil.split((String)version1, (String)".", (int)0);
        int[] splitVersion2 = StringUtil.split((String)version2, (String)".", (int)0);
        if (splitVersion1.length != 2 && splitVersion2.length != 2) {
            return 0;
        }
        if (splitVersion1.length != 2) {
            return -1;
        }
        if (splitVersion2.length != 2) {
            return 1;
        }
        if (splitVersion1[0] > splitVersion2[0]) {
            return 1;
        }
        if (splitVersion1[0] < splitVersion2[0]) {
            return -1;
        }
        if (splitVersion1[1] > splitVersion2[1]) {
            return 1;
        }
        if (splitVersion1[1] < splitVersion2[1]) {
            return -1;
        }
        return 0;
    }

    public void destroy() {
        this._serviceTrackerList.close();
    }

    public String getAbsolutePath(PortletRequest portletRequest, long folderId) throws PortalException {
        ThemeDisplay themeDisplay = (ThemeDisplay)portletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        if (folderId == 0L) {
            return themeDisplay.translate("home");
        }
        Folder folder = DLAppLocalServiceUtil.getFolder((long)folderId);
        List folders = folder.getAncestors();
        Collections.reverse(folders);
        StringBundler sb = new StringBundler(folders.size() * 3 + 5);
        sb.append(themeDisplay.translate("home"));
        sb.append(" ");
        for (Folder curFolder : folders) {
            sb.append("\u00bb");
            sb.append(" ");
            sb.append(curFolder.getName());
        }
        sb.append("\u00bb");
        sb.append(" ");
        sb.append(folder.getName());
        return sb.toString();
    }

    public Set<String> getAllMediaGalleryMimeTypes() {
        return _allMediaGalleryMimeTypes;
    }

    public String getDDMStructureKey(DLFileEntryType dlFileEntryType) {
        return this.getDDMStructureKey(dlFileEntryType.getUuid());
    }

    public String getDDMStructureKey(String fileEntryTypeUuid) {
        return _STRUCTURE_KEY_PREFIX + StringUtil.toUpperCase((String)fileEntryTypeUuid);
    }

    public String getDeprecatedDDMStructureKey(DLFileEntryType dlFileEntryType) {
        return this.getDeprecatedDDMStructureKey(dlFileEntryType.getFileEntryTypeId());
    }

    public String getDeprecatedDDMStructureKey(long fileEntryTypeId) {
        return _STRUCTURE_KEY_PREFIX + fileEntryTypeId;
    }

    public String getDividedPath(long id) {
        StringBundler sb = new StringBundler(16);
        long dividend = id;
        while (dividend / 256L != 0L) {
            sb.append("/");
            sb.append(dividend % 256L);
            dividend /= 256L;
        }
        sb.append("/");
        sb.append(id);
        return sb.toString();
    }

    public String getDLFileEntryControlPanelLink(PortletRequest portletRequest, long fileEntryId) {
        String portletId = PortletProviderUtil.getPortletId((String)FileEntry.class.getName(), (PortletProvider.Action)PortletProvider.Action.MANAGE);
        PortletURL portletURL = PortalUtil.getControlPanelPortletURL((PortletRequest)portletRequest, (String)portletId, (String)"RENDER_PHASE");
        portletURL.setParameter("mvcRenderCommandName", "/document_library/view_file_entry");
        portletURL.setParameter("fileEntryId", String.valueOf(fileEntryId));
        return portletURL.toString();
    }

    public String getDLFolderControlPanelLink(PortletRequest portletRequest, long folderId) {
        String portletId = PortletProviderUtil.getPortletId((String)Folder.class.getName(), (PortletProvider.Action)PortletProvider.Action.MANAGE);
        PortletURL portletURL = PortalUtil.getControlPanelPortletURL((PortletRequest)portletRequest, (String)portletId, (String)"RENDER_PHASE");
        if (folderId == 0L) {
            portletURL.setParameter("mvcRenderCommandName", "/document_library/view");
        } else {
            portletURL.setParameter("mvcRenderCommandName", "/document_library/view_folder");
        }
        portletURL.setParameter("folderId", String.valueOf(folderId));
        return portletURL.toString();
    }

    public String getDownloadURL(FileEntry fileEntry, FileVersion fileVersion, ThemeDisplay themeDisplay, String queryString) {
        return this.getDownloadURL(fileEntry, fileVersion, themeDisplay, queryString, true, true);
    }

    public String getDownloadURL(FileEntry fileEntry, FileVersion fileVersion, ThemeDisplay themeDisplay, String queryString, boolean appendVersion, boolean absoluteURL) {
        String previewURL = this.getPreviewURL(fileEntry, fileVersion, themeDisplay, queryString, appendVersion, absoluteURL);
        return HttpUtil.addParameter((String)previewURL, (String)"download", (boolean)true);
    }

    public Map<String, String> getEmailDefinitionTerms(PortletRequest portletRequest, String emailFromAddress, String emailFromName) {
        ThemeDisplay themeDisplay = (ThemeDisplay)portletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        LinkedHashMap<String, String> definitionTerms = new LinkedHashMap<String, String>();
        definitionTerms.put("[$COMPANY_ID$]", LanguageUtil.get((Locale)themeDisplay.getLocale(), (String)"the-company-id-associated-with-the-document"));
        definitionTerms.put("[$COMPANY_MX$]", LanguageUtil.get((Locale)themeDisplay.getLocale(), (String)"the-company-mx-associated-with-the-document"));
        definitionTerms.put("[$COMPANY_NAME$]", LanguageUtil.get((Locale)themeDisplay.getLocale(), (String)"the-company-name-associated-with-the-document"));
        definitionTerms.put("[$DOCUMENT_TITLE$]", LanguageUtil.get((Locale)themeDisplay.getLocale(), (String)"the-document-title"));
        definitionTerms.put("[$DOCUMENT_TYPE$]", LanguageUtil.get((Locale)themeDisplay.getLocale(), (String)"the-document-type"));
        definitionTerms.put("[$DOCUMENT_URL$]", LanguageUtil.get((Locale)themeDisplay.getLocale(), (String)"the-document-url"));
        definitionTerms.put("[$DOCUMENT_USER_ADDRESS$]", LanguageUtil.get((Locale)themeDisplay.getLocale(), (String)"the-email-address-of-the-user-who-added-the-document"));
        definitionTerms.put("[$DOCUMENT_USER_NAME$]", LanguageUtil.get((Locale)themeDisplay.getLocale(), (String)"the-user-who-added-the-document"));
        definitionTerms.put("[$FOLDER_NAME$]", LanguageUtil.get((Locale)themeDisplay.getLocale(), (String)"the-folder-in-which-the-document-has-been-added"));
        definitionTerms.put("[$FROM_ADDRESS$]", HtmlUtil.escape((String)emailFromAddress));
        definitionTerms.put("[$FROM_NAME$]", HtmlUtil.escape((String)emailFromName));
        Company company = themeDisplay.getCompany();
        definitionTerms.put("[$PORTAL_URL$]", company.getVirtualHostname());
        PortletDisplay portletDisplay = themeDisplay.getPortletDisplay();
        definitionTerms.put("[$PORTLET_NAME$]", HtmlUtil.escape((String)portletDisplay.getTitle()));
        definitionTerms.put("[$SITE_NAME$]", LanguageUtil.get((Locale)themeDisplay.getLocale(), (String)"the-site-name-associated-with-the-document"));
        definitionTerms.put("[$TO_ADDRESS$]", LanguageUtil.get((Locale)themeDisplay.getLocale(), (String)"the-address-of-the-email-recipient"));
        definitionTerms.put("[$TO_NAME$]", LanguageUtil.get((Locale)themeDisplay.getLocale(), (String)"the-name-of-the-email-recipient"));
        return definitionTerms;
    }

    public Map<String, String> getEmailFromDefinitionTerms(PortletRequest portletRequest, String emailFromAddress, String emailFromName) {
        ThemeDisplay themeDisplay = (ThemeDisplay)portletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        LinkedHashMap<String, String> definitionTerms = new LinkedHashMap<String, String>();
        definitionTerms.put("[$COMPANY_ID$]", LanguageUtil.get((Locale)themeDisplay.getLocale(), (String)"the-company-id-associated-with-the-document"));
        definitionTerms.put("[$COMPANY_MX$]", LanguageUtil.get((Locale)themeDisplay.getLocale(), (String)"the-company-mx-associated-with-the-document"));
        definitionTerms.put("[$COMPANY_NAME$]", LanguageUtil.get((Locale)themeDisplay.getLocale(), (String)"the-company-name-associated-with-the-document"));
        definitionTerms.put("[$DOCUMENT_STATUS_BY_USER_NAME$]", LanguageUtil.get((Locale)themeDisplay.getLocale(), (String)"the-user-who-updated-the-document"));
        definitionTerms.put("[$DOCUMENT_USER_ADDRESS$]", LanguageUtil.get((Locale)themeDisplay.getLocale(), (String)"the-email-address-of-the-user-who-added-the-document"));
        definitionTerms.put("[$DOCUMENT_USER_NAME$]", LanguageUtil.get((Locale)themeDisplay.getLocale(), (String)"the-user-who-added-the-document"));
        PortletDisplay portletDisplay = themeDisplay.getPortletDisplay();
        definitionTerms.put("[$PORTLET_NAME$]", HtmlUtil.escape((String)portletDisplay.getTitle()));
        definitionTerms.put("[$SITE_NAME$]", LanguageUtil.get((Locale)themeDisplay.getLocale(), (String)"the-site-name-associated-with-the-document"));
        return definitionTerms;
    }

    public List<FileEntry> getFileEntries(Hits hits) {
        ArrayList<FileEntry> entries = new ArrayList<FileEntry>();
        for (Document document : hits.getDocs()) {
            long fileEntryId = GetterUtil.getLong((String)document.get("entryClassPK"));
            try {
                FileEntry fileEntry = DLAppLocalServiceUtil.getFileEntry((long)fileEntryId);
                entries.add(fileEntry);
            }
            catch (Exception e) {
                if (!_log.isWarnEnabled()) continue;
                _log.warn((Object)("Documents and Media search index is stale and contains file entry " + fileEntryId));
            }
        }
        return entries;
    }

    public String getFileEntryImage(FileEntry fileEntry, ThemeDisplay themeDisplay) {
        StringBundler sb = new StringBundler(5);
        sb.append("<img src=\"");
        sb.append(themeDisplay.getPathThemeImages());
        sb.append("/file_system/small/");
        sb.append(fileEntry.getIcon());
        sb.append(".png\" style=\"border-width: 0; text-align: left;\">");
        return sb.toString();
    }

    @Deprecated
    public Set<Long> getFileEntryTypeSubscriptionClassPKs(long userId) {
        List subscriptions = SubscriptionLocalServiceUtil.getUserSubscriptions((long)userId, (String)DLFileEntryType.class.getName());
        HashSet<Long> classPKs = new HashSet<Long>(subscriptions.size());
        for (Subscription subscription : subscriptions) {
            classPKs.add(subscription.getClassPK());
        }
        return classPKs;
    }

    public String getFileIcon(String extension) {
        if (!_fileIcons.contains(extension)) {
            extension = _DEFAULT_FILE_ICON;
        }
        return extension;
    }

    public String getFileIconCssClass(String extension) {
        return "documents-and-media";
    }

    public String getGenericName(String extension) {
        String genericName = _genericNames.get(extension);
        if (genericName == null) {
            genericName = _DEFAULT_GENERIC_NAME;
        }
        return genericName;
    }

    public String getImagePreviewURL(FileEntry fileEntry, FileVersion fileVersion, ThemeDisplay themeDisplay) throws Exception {
        String previewQueryString = null;
        if (PropsValues.DL_FILE_ENTRY_THUMBNAIL_ENABLED) {
            if (ImageProcessorUtil.hasImages((FileVersion)fileVersion)) {
                previewQueryString = "&imagePreview=1";
            } else if (PDFProcessorUtil.hasImages((FileVersion)fileVersion)) {
                previewQueryString = "&previewFileIndex=1";
            } else if (VideoProcessorUtil.hasVideo((FileVersion)fileVersion)) {
                previewQueryString = "&videoThumbnail=1";
            }
        }
        return this.getImageSrc(fileEntry, fileVersion, themeDisplay, previewQueryString);
    }

    public String getImagePreviewURL(FileEntry fileEntry, ThemeDisplay themeDisplay) throws Exception {
        return this.getImagePreviewURL(fileEntry, fileEntry.getFileVersion(), themeDisplay);
    }

    public String getPreviewURL(FileEntry fileEntry, FileVersion fileVersion, ThemeDisplay themeDisplay, String queryString) {
        return this.getPreviewURL(fileEntry, fileVersion, themeDisplay, queryString, true, true);
    }

    public String getPreviewURL(FileEntry fileEntry, FileVersion fileVersion, ThemeDisplay themeDisplay, String queryString, boolean appendVersion, boolean absoluteURL) {
        StringBundler sb = new StringBundler(15);
        if (themeDisplay != null && absoluteURL) {
            sb.append(themeDisplay.getPortalURL());
        }
        sb.append(PortalUtil.getPathContext());
        sb.append("/documents/");
        sb.append(fileEntry.getRepositoryId());
        sb.append("/");
        sb.append(fileEntry.getFolderId());
        sb.append("/");
        String fileName = fileEntry.getFileName();
        if (fileEntry.isInTrash()) {
            fileName = TrashUtil.getOriginalTitle((String)fileEntry.getFileName());
        }
        sb.append(URLCodec.encodeURL((String)HtmlUtil.unescape((String)fileName)));
        sb.append("/");
        sb.append(URLCodec.encodeURL((String)fileEntry.getUuid()));
        if (appendVersion) {
            sb.append("?version=");
            sb.append(fileVersion.getVersion());
        }
        if (ImageProcessorUtil.isImageSupported((FileVersion)fileVersion)) {
            if (appendVersion) {
                sb.append("&t=");
            } else {
                sb.append("?t=");
            }
            Date modifiedDate = fileVersion.getModifiedDate();
            sb.append(modifiedDate.getTime());
        }
        sb.append(queryString);
        String previewURL = sb.toString();
        if (themeDisplay != null && themeDisplay.isAddSessionIdToURL()) {
            return PortalUtil.getURLWithSessionId((String)previewURL, (String)themeDisplay.getSessionId());
        }
        return previewURL;
    }

    public <T> OrderByComparator<T> getRepositoryModelOrderByComparator(String orderByCol, String orderByType) {
        return this.getRepositoryModelOrderByComparator(orderByCol, orderByType, false);
    }

    public <T> OrderByComparator<T> getRepositoryModelOrderByComparator(String orderByCol, String orderByType, boolean orderByModel) {
        boolean orderByAsc = true;
        if (orderByType.equals("desc")) {
            orderByAsc = false;
        }
        Object orderByComparator = null;
        orderByComparator = orderByCol.equals("creationDate") ? new RepositoryModelCreateDateComparator(orderByAsc, orderByModel) : (orderByCol.equals("downloads") ? new RepositoryModelReadCountComparator(orderByAsc, orderByModel) : (orderByCol.equals("modifiedDate") ? new RepositoryModelModifiedDateComparator(orderByAsc, orderByModel) : (orderByCol.equals("size") ? new RepositoryModelSizeComparator(orderByAsc, orderByModel) : new RepositoryModelTitleComparator(orderByAsc, orderByModel))));
        return orderByComparator;
    }

    public String getSanitizedFileName(String title, String extension) {
        String fileName = StringUtil.replace((String)title, (char)'/', (char)'_');
        if (Validator.isNotNull((String)extension) && !StringUtil.endsWith((String)fileName, (String)("." + extension))) {
            fileName = fileName + "." + extension;
        }
        if (fileName.length() > 255) {
            int x = fileName.length() - 1;
            if (Validator.isNotNull((String)extension)) {
                x = fileName.lastIndexOf(".");
            }
            int y = x - (fileName.length() - 255);
            fileName = fileName.substring(0, y) + fileName.substring(x);
        }
        return fileName;
    }

    public String getTempFileId(long id, String version) {
        return this.getTempFileId(id, version, null);
    }

    public String getTempFileId(long id, String version, String languageId) {
        if (Validator.isNull((String)languageId)) {
            return String.valueOf(id).concat(".").concat(version);
        }
        StringBundler sb = new StringBundler(5);
        sb.append(id);
        sb.append(".");
        sb.append(version);
        sb.append(".");
        sb.append(languageId);
        return sb.toString();
    }

    @Deprecated
    public String getThumbnailSrc(FileEntry fileEntry, DLFileShortcut dlFileShortcut, ThemeDisplay themeDisplay) throws Exception {
        return this.getThumbnailSrc(fileEntry, fileEntry.getFileVersion(), themeDisplay);
    }

    @Deprecated
    public String getThumbnailSrc(FileEntry fileEntry, FileVersion fileVersion, DLFileShortcut dlFileShortcut, ThemeDisplay themeDisplay) throws Exception {
        return this.getThumbnailSrc(fileEntry, fileVersion, themeDisplay);
    }

    public String getThumbnailSrc(FileEntry fileEntry, FileVersion fileVersion, ThemeDisplay themeDisplay) throws Exception {
        String thumbnailQueryString = null;
        if (PropsValues.DL_FILE_ENTRY_THUMBNAIL_ENABLED) {
            if (ImageProcessorUtil.hasImages((FileVersion)fileVersion)) {
                thumbnailQueryString = "&imageThumbnail=1";
            } else if (PDFProcessorUtil.hasImages((FileVersion)fileVersion)) {
                thumbnailQueryString = "&documentThumbnail=1";
            } else if (VideoProcessorUtil.hasVideo((FileVersion)fileVersion)) {
                thumbnailQueryString = "&videoThumbnail=1";
            }
        }
        return this.getImageSrc(fileEntry, fileVersion, themeDisplay, thumbnailQueryString);
    }

    public String getThumbnailSrc(FileEntry fileEntry, ThemeDisplay themeDisplay) throws Exception {
        return this.getThumbnailSrc(fileEntry, fileEntry.getFileVersion(), themeDisplay);
    }

    public String getThumbnailStyle() {
        return this.getThumbnailStyle(true, 0);
    }

    public String getThumbnailStyle(boolean max, int margin) {
        return this.getThumbnailStyle(max, margin, PrefsPropsUtil.getInteger((String)"dl.file.entry.thumbnail.max.height"), PrefsPropsUtil.getInteger((String)"dl.file.entry.thumbnail.max.width"));
    }

    public String getThumbnailStyle(boolean max, int margin, int height, int width) {
        StringBundler sb = new StringBundler(5);
        if (max) {
            sb.append("max-height: ");
        } else {
            sb.append("height: ");
        }
        sb.append(height += 2 * margin);
        if (max) {
            sb.append("px; max-width: ");
        } else {
            sb.append("px; width: ");
        }
        sb.append(width += 2 * margin);
        sb.append("px;");
        return sb.toString();
    }

    public String getTitleWithExtension(FileEntry fileEntry) {
        String title = fileEntry.getTitle();
        String extension = fileEntry.getExtension();
        return this.getTitleWithExtension(title, extension);
    }

    public String getTitleWithExtension(String title, String extension) {
        String periodAndExtension;
        if (Validator.isNotNull((String)extension) && !title.endsWith(periodAndExtension = ".".concat(extension))) {
            title = title + periodAndExtension;
        }
        return title;
    }

    public String getUniqueFileName(long groupId, long folderId, String fileName) {
        String uniqueFileName = fileName;
        int i = 1;
        while (true) {
            try {
                DLAppLocalServiceUtil.getFileEntry((long)groupId, (long)folderId, (String)uniqueFileName);
                uniqueFileName = FileUtil.appendParentheticalSuffix((String)fileName, (String)String.valueOf(i));
            }
            catch (Exception e) {
                break;
            }
            ++i;
        }
        return uniqueFileName;
    }

    public String getWebDavURL(ThemeDisplay themeDisplay, Folder folder, FileEntry fileEntry) throws PortalException {
        return this.getWebDavURL(themeDisplay, folder, fileEntry, false);
    }

    public String getWebDavURL(ThemeDisplay themeDisplay, Folder folder, FileEntry fileEntry, boolean manualCheckInRequired) throws PortalException {
        return this.getWebDavURL(themeDisplay, folder, fileEntry, manualCheckInRequired, false);
    }

    public String getWebDavURL(ThemeDisplay themeDisplay, Folder folder, FileEntry fileEntry, boolean manualCheckInRequired, boolean openDocumentUrl) throws PortalException {
        StringBundler webDavURL = new StringBundler(7);
        boolean secure = false;
        if (themeDisplay.isSecure() || PropsValues.WEBDAV_SERVLET_HTTPS_REQUIRED) {
            secure = true;
        }
        String portalURL = PortalUtil.getPortalURL((String)themeDisplay.getServerName(), (int)themeDisplay.getServerPort(), (boolean)secure);
        webDavURL.append(portalURL);
        webDavURL.append(themeDisplay.getPathContext());
        webDavURL.append("/webdav");
        if (manualCheckInRequired) {
            webDavURL.append("/manualCheckInRequired");
        }
        Group group = null;
        group = fileEntry != null ? GroupLocalServiceUtil.getGroup((long)fileEntry.getGroupId()) : themeDisplay.getScopeGroup();
        webDavURL.append(group.getFriendlyURL());
        webDavURL.append("/document_library");
        StringBuilder sb = new StringBuilder();
        if (folder != null && folder.getFolderId() != 0L) {
            Folder curFolder = folder;
            while (true) {
                sb.insert(0, URLCodec.encodeURL((String)curFolder.getName(), (boolean)true));
                sb.insert(0, "/");
                if (curFolder.getParentFolderId() == 0L) break;
                curFolder = DLAppLocalServiceUtil.getFolder((long)curFolder.getParentFolderId());
            }
        }
        if (fileEntry != null) {
            sb.append("/");
            sb.append(DLWebDAVUtil.escapeURLTitle(fileEntry.getTitle()));
        }
        webDavURL.append(sb.toString());
        return webDavURL.toString();
    }

    public boolean hasWorkflowDefinitionLink(long companyId, long groupId, long folderId, long fileEntryTypeId) throws Exception {
        while (folderId != 0L) {
            DLFolder dlFolder = DLFolderLocalServiceUtil.fetchDLFolder((long)folderId);
            if (dlFolder == null) {
                return false;
            }
            if (dlFolder.getRestrictionType() != 0) break;
            folderId = dlFolder.getParentFolderId();
        }
        return WorkflowDefinitionLinkLocalServiceUtil.hasWorkflowDefinitionLink((long)companyId, (long)groupId, (String)DLFolderConstants.getClassName(), (long)folderId, (long)fileEntryTypeId) || WorkflowDefinitionLinkLocalServiceUtil.hasWorkflowDefinitionLink((long)companyId, (long)groupId, (String)DLFolderConstants.getClassName(), (long)folderId, (long)-1L);
    }

    public boolean isAutoGeneratedDLFileEntryTypeDDMStructureKey(String ddmStructureKey) {
        return ddmStructureKey.startsWith(_STRUCTURE_KEY_PREFIX);
    }

    public boolean isOfficeExtension(String extension) {
        return ArrayUtil.contains((Object[])_MICROSOFT_OFFICE_EXTENSIONS, (Object)extension);
    }

    @Deprecated
    public boolean isSubscribedToFileEntryType(long companyId, long groupId, long userId, long fileEntryTypeId) {
        if (fileEntryTypeId == 0L) {
            fileEntryTypeId = groupId;
        }
        return SubscriptionLocalServiceUtil.isSubscribed((long)companyId, (long)userId, (String)DLFileEntryType.class.getName(), (long)fileEntryTypeId);
    }

    @Deprecated
    public boolean isSubscribedToFolder(long companyId, long groupId, long userId, long folderId) throws PortalException {
        return this.isSubscribedToFolder(companyId, groupId, userId, folderId, true);
    }

    @Deprecated
    public boolean isSubscribedToFolder(long companyId, long groupId, long userId, long folderId, boolean recursive) throws PortalException {
        ArrayList<Long> ancestorFolderIds = new ArrayList<Long>();
        if (folderId != 0L) {
            Folder folder = DLAppLocalServiceUtil.getFolder((long)folderId);
            ancestorFolderIds.add(folderId);
            if (recursive) {
                ancestorFolderIds.addAll(folder.getAncestorFolderIds());
                ancestorFolderIds.add(groupId);
            }
        } else {
            ancestorFolderIds.add(groupId);
        }
        long[] folderIdsArray = ArrayUtil.toLongArray(ancestorFolderIds);
        return SubscriptionLocalServiceUtil.isSubscribed((long)companyId, (long)userId, (String)DLFolder.class.getName(), (long[])folderIdsArray);
    }

    public boolean isValidVersion(String version) {
        if (version.equals("PWC")) {
            return true;
        }
        String[] versionParts = StringUtil.split((String)version, (String)".");
        if (versionParts.length != 2) {
            return false;
        }
        return Validator.isNumber((String)versionParts[0]) && Validator.isNumber((String)versionParts[1]);
    }

    public void startWorkflowInstance(long userId, DLFileVersion dlFileVersion, String syncEventType, ServiceContext serviceContext) throws PortalException {
        HashMap<String, String> workflowContext = new HashMap<String, String>();
        workflowContext.put("url", this.getEntryURL(dlFileVersion, serviceContext));
        workflowContext.put("event", syncEventType);
        WorkflowHandlerRegistryUtil.startWorkflowInstance((long)dlFileVersion.getCompanyId(), (long)dlFileVersion.getGroupId(), (long)userId, (String)DLFileEntryConstants.getClassName(), (long)dlFileVersion.getFileVersionId(), (Object)dlFileVersion, (ServiceContext)serviceContext, workflowContext);
    }

    protected String getEntryURL(DLFileVersion dlFileVersion, ServiceContext serviceContext) throws PortalException {
        if (Objects.equals(serviceContext.getCommand(), "add_webdav") || Objects.equals(serviceContext.getCommand(), "update_webdav")) {
            return serviceContext.getPortalURL() + serviceContext.getCurrentURL();
        }
        String entryURL = GetterUtil.getString((Object)serviceContext.getAttribute("entryURL"));
        if (Validator.isNotNull((String)entryURL)) {
            return entryURL;
        }
        HttpServletRequest request = serviceContext.getRequest();
        ThemeDisplay themeDisplay = serviceContext.getThemeDisplay();
        if (request == null || themeDisplay == null) {
            return "";
        }
        Object portletURL = null;
        long plid = serviceContext.getPlid();
        long controlPanelPlid = PortalUtil.getControlPanelPlid((long)serviceContext.getCompanyId());
        String portletId = PortletProviderUtil.getPortletId((String)FileEntry.class.getName(), (PortletProvider.Action)PortletProvider.Action.VIEW);
        for (PortletLayoutFinder portletLayoutFinder : this._serviceTrackerList) {
            try {
                PortletLayoutFinder.Result result = portletLayoutFinder.find(themeDisplay, themeDisplay.getSiteGroupId());
                portletId = result.getPortletId();
                plid = result.getPlid();
                break;
            }
            catch (PortalException pe) {
                if (!_log.isDebugEnabled()) continue;
                _log.debug((Object)pe, (Throwable)pe);
            }
        }
        portletURL = plid == controlPanelPlid || plid == 0L ? PortalUtil.getControlPanelPortletURL((HttpServletRequest)request, (String)portletId, (String)"RENDER_PHASE") : PortletURLFactoryUtil.create((HttpServletRequest)request, (String)portletId, (long)plid, (String)"RENDER_PHASE");
        portletURL.setParameter("mvcRenderCommandName", "/document_library/view_file_entry");
        portletURL.setParameter("fileEntryId", String.valueOf(dlFileVersion.getFileEntryId()));
        return portletURL.toString();
    }

    protected String getImageSrc(FileEntry fileEntry, FileVersion fileVersion, ThemeDisplay themeDisplay, String queryString) throws Exception {
        String thumbnailSrc = "";
        if (Validator.isNotNull((String)queryString)) {
            thumbnailSrc = this.getPreviewURL(fileEntry, fileVersion, themeDisplay, queryString, true, true);
        }
        return thumbnailSrc;
    }

    private static void _populateGenericNamesMap(String genericName) {
        String[] extensions;
        for (String extension : extensions = PropsUtil.getArray((String)"dl.file.generic.extensions", (Filter)new Filter(genericName))) {
            _genericNames.put(extension, genericName);
        }
    }

    static {
        String[] genericNames;
        _MICROSOFT_OFFICE_EXTENSIONS = new String[]{"accda", "accdb", "accdc", "accde", "accdp", "accdr", "accdt", "accdu", "acl", "ade", "adp", "asd", "cnv", "crtx", "doc", "docm", "docx", "dot", "dotm", "dotx", "grv", "iaf", "laccdb", "maf", "mam", "maq", "mar", "mat", "mda", "mdb", "mde", "mdt", "mdw", "mpd", "mpp", "mpt", "oab", "obi", "oft", "olm", "one", "onepkg", "ops", "ost", "pa", "pip", "pot", "potm", "potx", "ppa", "ppam", "pps", "ppsm", "ppsx", "ppt", "pptm", "pptx", "prf", "pst", "pub", "puz", "rpmsg", "sldm", "sldx", "slk", "snp", "svd", "thmx", "vdx", "vrge08message", "vsd", "vss", "vst", "vsx", "vtx", "wbk", "wll", "xar", "xl", "xla", "xlam", "xlb", "xlc", "xll", "xlm", "xls", "xlsb", "xlsm", "xlsx", "xlt", "xltm", "xltx", "xlw", "xsf", "xsn"};
        _log = LogFactoryUtil.getLog(DLImpl.class);
        _allMediaGalleryMimeTypes = new TreeSet<String>();
        _fileIcons = new HashSet<String>();
        _genericNames = new HashMap<String, String>();
        _allMediaGalleryMimeTypes.addAll(SetUtil.fromArray((Object[])PropsUtil.getArray((String)"dl.file.entry.preview.audio.mime.types")));
        _allMediaGalleryMimeTypes.addAll(SetUtil.fromArray((Object[])PropsUtil.getArray((String)"dl.file.entry.preview.video.mime.types")));
        _allMediaGalleryMimeTypes.addAll(SetUtil.fromArray((Object[])PropsUtil.getArray((String)"dl.file.entry.preview.image.mime.types")));
        String[] fileIcons = null;
        try {
            fileIcons = PropsUtil.getArray((String)"dl.file.icons");
        }
        catch (Exception e) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)e, (Throwable)e);
            }
            fileIcons = new String[]{""};
        }
        for (int i = 0; i < fileIcons.length; ++i) {
            if ("*".equals(fileIcons[i])) continue;
            String extension = fileIcons[i];
            if (extension.length() > 0) {
                extension = extension.substring(1);
            }
            _fileIcons.add(extension);
        }
        for (String genericName : genericNames = PropsUtil.getArray((String)"dl.file.generic.names")) {
            DLImpl._populateGenericNamesMap(genericName);
        }
    }
}

