/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.asset.util;

import com.liferay.asset.kernel.model.AssetTag;
import com.liferay.asset.kernel.service.AssetTagLocalServiceUtil;
import com.liferay.portal.kernel.dao.orm.ActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.IndexableActionableDynamicQuery;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.search.BaseIndexer;
import com.liferay.portal.kernel.search.BooleanClauseOccur;
import com.liferay.portal.kernel.search.BooleanQuery;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.IndexWriterHelperUtil;
import com.liferay.portal.kernel.search.Query;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.Summary;
import com.liferay.portal.kernel.search.filter.BooleanFilter;
import com.liferay.portal.kernel.search.generic.BooleanQueryImpl;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.spring.osgi.OSGiBeanProperties;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portlet.asset.service.permission.AssetTagPermission;
import java.util.Locale;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;

@OSGiBeanProperties
public class AssetTagIndexer
extends BaseIndexer<AssetTag> {
    public static final String CLASS_NAME = AssetTag.class.getName();
    private static final Log _log = LogFactoryUtil.getLog(AssetTagIndexer.class);

    public AssetTagIndexer() {
        this.setDefaultSelectedFieldNames(new String[]{"companyId", "groupId", "uid"});
        this.setFilterSearch(true);
        this.setPermissionAware(true);
    }

    public String getClassName() {
        return CLASS_NAME;
    }

    public boolean hasPermission(PermissionChecker permissionChecker, String entryClassName, long entryClassPK, String actionId) throws Exception {
        AssetTag tag = AssetTagLocalServiceUtil.getTag((long)entryClassPK);
        return AssetTagPermission.contains(permissionChecker, tag, "VIEW");
    }

    public void postProcessSearchQuery(BooleanQuery searchQuery, BooleanFilter fullQueryBooleanFilter, SearchContext searchContext) throws Exception {
        String name = (String)((Object)searchContext.getAttribute("name"));
        if (Validator.isNotNull((String)name)) {
            BooleanQueryImpl nameQuery = new BooleanQueryImpl();
            this.addSearchTerm((BooleanQuery)nameQuery, searchContext, "name", true);
            searchQuery.add((Query)nameQuery, BooleanClauseOccur.SHOULD);
        }
    }

    protected void doDelete(AssetTag assetTag) throws Exception {
        this.deleteDocument(assetTag.getCompanyId(), assetTag.getTagId());
    }

    protected Document doGetDocument(AssetTag assetTag) throws Exception {
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Indexing asset tag " + assetTag));
        }
        Document document = this.getBaseModelDocument(CLASS_NAME, (BaseModel)assetTag);
        document.addTextSortable("name", assetTag.getName());
        document.addNumberSortable("assetCount", Integer.valueOf(assetTag.getAssetCount()));
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Document " + assetTag + " indexed successfully"));
        }
        return document;
    }

    protected Summary doGetSummary(Document document, Locale locale, String snippet, PortletRequest portletRequest, PortletResponse portletResponse) {
        return null;
    }

    protected void doReindex(AssetTag assetTag) throws Exception {
        Document document = this.getDocument(assetTag);
        IndexWriterHelperUtil.updateDocument((String)this.getSearchEngineId(), (long)assetTag.getCompanyId(), (Document)document, (boolean)this.isCommitImmediately());
    }

    protected void doReindex(String className, long classPK) throws Exception {
        AssetTag tag = AssetTagLocalServiceUtil.getTag((long)classPK);
        this.doReindex(tag);
    }

    protected void doReindex(String[] ids) throws Exception {
        long companyId = GetterUtil.getLong((String)ids[0]);
        this.reindexTags(companyId);
    }

    protected void reindexTags(long companyId) throws PortalException {
        final IndexableActionableDynamicQuery indexableActionableDynamicQuery = AssetTagLocalServiceUtil.getIndexableActionableDynamicQuery();
        indexableActionableDynamicQuery.setCompanyId(companyId);
        indexableActionableDynamicQuery.setPerformActionMethod((ActionableDynamicQuery.PerformActionMethod)new ActionableDynamicQuery.PerformActionMethod<AssetTag>(){

            public void performAction(AssetTag tag) {
                block3: {
                    try {
                        Document document = AssetTagIndexer.this.getDocument(tag);
                        if (document != null) {
                            indexableActionableDynamicQuery.addDocuments(new Document[]{document});
                        }
                    }
                    catch (PortalException pe) {
                        if (!_log.isWarnEnabled()) break block3;
                        _log.warn((Object)("Unable to index asset tag " + tag.getTagId()), (Throwable)pe);
                    }
                }
            }
        });
        indexableActionableDynamicQuery.setSearchEngineId(this.getSearchEngineId());
        indexableActionableDynamicQuery.performActions();
    }
}

