/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.upgrade.v7_0_3;

import com.liferay.portal.kernel.dao.db.DB;
import com.liferay.portal.kernel.dao.db.DBManagerUtil;
import com.liferay.portal.kernel.dao.db.DBType;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.util.LoggingTimer;
import com.liferay.portal.kernel.util.StringBundler;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

public class UpgradeSybase
extends UpgradeProcess {
    private static final Log _log = LogFactoryUtil.getLog(UpgradeSybase.class);

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void alterVarcharColumns() throws Exception {
        StringBundler sb = new StringBundler(3);
        sb.append("select o.name, c.name from sysobjects o, syscolumns c, ");
        sb.append("systypes t where o.id = c.id and c.type = t.type and ");
        sb.append("t.name = 'varchar' and c.length = 1000");
        try (LoggingTimer loggingTimer = new LoggingTimer();
             PreparedStatement ps = this.connection.prepareStatement(sb.toString());){
            ResultSet rs = ps.executeQuery();
            Throwable throwable = null;
            block29: while (true) {
                try {
                    while (rs.next()) {
                        String tableName = rs.getString(1);
                        String columnName = rs.getString(2);
                        try {
                            this.runSQL("alter table " + tableName + " modify " + columnName + " varchar(4000)");
                            continue block29;
                        }
                        catch (SQLException sqle) {
                            if (sqle.getErrorCode() != 1441) throw sqle;
                            if (!_log.isWarnEnabled()) continue;
                            sb = new StringBundler(6);
                            sb.append("Unable to alter length of column ");
                            sb.append(columnName);
                            sb.append(" for table ");
                            sb.append(tableName);
                            sb.append(" because it contains values larger ");
                            sb.append("than the new column length");
                            _log.warn((Object)sb.toString());
                            continue;
                            return;
                        }
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
            }
            finally {
                if (rs != null) {
                    if (throwable != null) {
                        try {
                            rs.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        rs.close();
                    }
                }
            }
        }
    }

    protected void doUpgrade() throws Exception {
        DB db = DBManagerUtil.getDB();
        if (db.getDBType() != DBType.SYBASE) {
            return;
        }
        this.alterVarcharColumns();
    }
}

