/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.upgrade.v7_0_3;

import com.liferay.message.boards.kernel.model.MBDiscussion;
import com.liferay.portal.kernel.dao.db.DBType;
import com.liferay.portal.kernel.dao.db.DBTypeToSQLMap;
import com.liferay.portal.kernel.dao.jdbc.AutoBatchPreparedStatementUtil;
import com.liferay.portal.kernel.upgrade.UpgradeException;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.util.LoggingTimer;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;

public class UpgradeMessageBoards
extends UpgradeProcess {
    protected void deleteEmptyMBDiscussion() throws Exception {
        String tempTableName = "TEMP_TABLE_" + StringUtil.randomString((int)4);
        try (LoggingTimer loggingTimer = new LoggingTimer();){
            this.runSQL("create table " + tempTableName + " (threadId LONG)");
            StringBundler sb = new StringBundler(8);
            sb.append("insert into ");
            sb.append(tempTableName);
            sb.append(" select MBMessage.threadId from MBThread, MBMessage ");
            sb.append("where MBThread.threadId = MBMessage.threadId and ");
            sb.append("MBThread.categoryId = ");
            sb.append(-1L);
            sb.append(" group by MBMessage.threadId having ");
            sb.append("count(MBMessage.messageId) = 1");
            this.runSQL(sb.toString());
            this._deleteAssetEntry(tempTableName);
            this._deleteTable("MBDiscussion", tempTableName);
            this._deleteTable("MBMessage", tempTableName);
            this._deleteTable("MBThread", tempTableName);
        }
        catch (Exception e) {
            throw new UpgradeException((Throwable)e);
        }
        finally {
            this.runSQL("drop table " + tempTableName);
        }
    }

    protected void doUpgrade() throws Exception {
        this.deleteEmptyMBDiscussion();
        this.populateMBDiscussionGroupId();
    }

    protected void populateMBDiscussionGroupId() throws Exception {
        StringBundler sb = new StringBundler();
        sb.append("select MBThread.groupId, MBDiscussion.discussionId from ");
        sb.append("MBDiscussion inner join MBThread on MBDiscussion.threadId ");
        sb.append("= MBThread.threadId where MBDiscussion.groupId = 0");
        try (PreparedStatement ps1 = AutoBatchPreparedStatementUtil.concurrentAutoBatch((Connection)this.connection, (String)"update MBDiscussion set groupId = ? where discussionId = ?");
             PreparedStatement ps2 = this.connection.prepareStatement(sb.toString());
             ResultSet rs = ps2.executeQuery();){
            while (rs.next()) {
                long groupId = rs.getLong(1);
                long discussionId = rs.getLong(2);
                ps1.setLong(1, groupId);
                ps1.setLong(2, discussionId);
                ps1.addBatch();
            }
            ps1.executeBatch();
        }
    }

    private void _deleteAssetEntry(String tempTableName) throws Exception {
        long classNameId = PortalUtil.getClassNameId((String)MBDiscussion.class.getName());
        StringBundler sb = new StringBundler(7);
        sb.append("delete from AssetEntry where classPK in (");
        sb.append("select MBMessage.messageId from MBMessage inner join ");
        sb.append(tempTableName);
        sb.append(" on MBMessage.threadId = ");
        sb.append(tempTableName);
        sb.append(".threadId) and classNameId = ");
        sb.append(classNameId);
        DBTypeToSQLMap dbTypeToSQLMap = new DBTypeToSQLMap(sb.toString());
        sb = new StringBundler(8);
        sb.append("delete AssetEntry from AssetEntry inner join MBMessage ");
        sb.append("inner join ");
        sb.append(tempTableName);
        sb.append(" where MBMessage.threadId = ");
        sb.append(tempTableName);
        sb.append(".threadId and AssetEntry.classPK = MBMessage.messageId ");
        sb.append("and AssetEntry.classNameId = ");
        sb.append(classNameId);
        dbTypeToSQLMap.add(DBType.MYSQL, sb.toString());
        this.runSQL(dbTypeToSQLMap);
    }

    private void _deleteTable(String tableName, String tempTableName) throws Exception {
        StringBundler sb = new StringBundler(5);
        sb.append("delete from ");
        sb.append(tableName);
        sb.append(" where threadId in (select threadId from ");
        sb.append(tempTableName);
        sb.append(")");
        DBTypeToSQLMap dbTypeToSQLMap = new DBTypeToSQLMap(sb.toString());
        sb = new StringBundler(11);
        sb.append("delete ");
        sb.append(tableName);
        sb.append(" from ");
        sb.append(tableName);
        sb.append(" inner join ");
        sb.append(tempTableName);
        sb.append(" where ");
        sb.append(tableName);
        sb.append(".threadId = ");
        sb.append(tempTableName);
        sb.append(".threadId");
        dbTypeToSQLMap.add(DBType.MYSQL, sb.toString());
        this.runSQL(dbTypeToSQLMap);
    }
}

