/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.servlet;

import com.liferay.portal.kernel.security.pacl.DoPrivileged;
import com.liferay.portal.kernel.servlet.BrowserMetadata;
import com.liferay.portal.kernel.servlet.BrowserSniffer;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import javax.servlet.http.HttpServletRequest;

@DoPrivileged
public class BrowserSnifferImpl
implements BrowserSniffer {
    protected static String[] revisionLeadings = new String[]{"rv", "it", "ra", "ie"};
    protected static char[] revisionSeparators = new char[]{'\\', ':', '/', ' '};
    protected static String[] versionLeadings = new String[]{"version", "firefox", "minefield", "chrome"};
    protected static char[] versionSeparators = new char[]{'\\', '/'};

    public boolean acceptsGzip(HttpServletRequest request) {
        String acceptEncoding = request.getHeader("Accept-Encoding");
        return acceptEncoding != null && acceptEncoding.contains("gzip");
    }

    public String getBrowserId(HttpServletRequest request) {
        BrowserMetadata browserMetadata = this.getBrowserMetadata(request);
        if (browserMetadata.isIe()) {
            return "ie";
        }
        if (browserMetadata.isFirefox()) {
            return "firefox";
        }
        return "other";
    }

    public BrowserMetadata getBrowserMetadata(HttpServletRequest request) {
        return new BrowserMetadata(this.getUserAgent(request));
    }

    public float getMajorVersion(HttpServletRequest request) {
        return GetterUtil.getFloat((String)this.getVersion(request));
    }

    public String getRevision(HttpServletRequest request) {
        String revision = (String)request.getAttribute("BROWSER_SNIFFER_REVISION");
        if (revision != null) {
            return revision;
        }
        revision = BrowserSnifferImpl.parseVersion(this.getUserAgent(request), revisionLeadings, revisionSeparators);
        request.setAttribute("BROWSER_SNIFFER_REVISION", (Object)revision);
        return revision;
    }

    public String getVersion(HttpServletRequest request) {
        String version = (String)request.getAttribute("BROWSER_SNIFFER_VERSION");
        if (version != null) {
            return version;
        }
        String userAgent = this.getUserAgent(request);
        version = BrowserSnifferImpl.parseVersion(userAgent, versionLeadings, versionSeparators);
        if (version.isEmpty()) {
            version = BrowserSnifferImpl.parseVersion(userAgent, revisionLeadings, revisionSeparators);
        }
        request.setAttribute("BROWSER_SNIFFER_VERSION", (Object)version);
        return version;
    }

    public boolean isAir(HttpServletRequest request) {
        BrowserMetadata browserMetadata = this.getBrowserMetadata(request);
        return browserMetadata.isAir();
    }

    public boolean isAndroid(HttpServletRequest request) {
        BrowserMetadata browserMetadata = this.getBrowserMetadata(request);
        return browserMetadata.isAndroid();
    }

    public boolean isChrome(HttpServletRequest request) {
        BrowserMetadata browserMetadata = this.getBrowserMetadata(request);
        return browserMetadata.isChrome();
    }

    public boolean isFirefox(HttpServletRequest request) {
        BrowserMetadata browserMetadata = this.getBrowserMetadata(request);
        return browserMetadata.isFirefox();
    }

    public boolean isGecko(HttpServletRequest request) {
        BrowserMetadata browserMetadata = this.getBrowserMetadata(request);
        return browserMetadata.isGecko();
    }

    public boolean isIe(HttpServletRequest request) {
        BrowserMetadata browserMetadata = this.getBrowserMetadata(request);
        return browserMetadata.isIe();
    }

    public boolean isIeOnWin32(HttpServletRequest request) {
        BrowserMetadata browserMetadata = this.getBrowserMetadata(request);
        return browserMetadata.isIeOnWin32();
    }

    public boolean isIeOnWin64(HttpServletRequest request) {
        BrowserMetadata browserMetadata = this.getBrowserMetadata(request);
        return browserMetadata.isIeOnWin64();
    }

    public boolean isIphone(HttpServletRequest request) {
        BrowserMetadata browserMetadata = this.getBrowserMetadata(request);
        return browserMetadata.isIphone();
    }

    public boolean isLinux(HttpServletRequest request) {
        BrowserMetadata browserMetadata = this.getBrowserMetadata(request);
        return browserMetadata.isLinux();
    }

    public boolean isMac(HttpServletRequest request) {
        BrowserMetadata browserMetadata = this.getBrowserMetadata(request);
        return browserMetadata.isMac();
    }

    public boolean isMobile(HttpServletRequest request) {
        BrowserMetadata browserMetadata = this.getBrowserMetadata(request);
        return browserMetadata.isMobile();
    }

    public boolean isMozilla(HttpServletRequest request) {
        BrowserMetadata browserMetadata = this.getBrowserMetadata(request);
        return browserMetadata.isMozilla();
    }

    public boolean isOpera(HttpServletRequest request) {
        BrowserMetadata browserMetadata = this.getBrowserMetadata(request);
        return browserMetadata.isOpera();
    }

    public boolean isRtf(HttpServletRequest request) {
        BrowserMetadata browserMetadata = this.getBrowserMetadata(request);
        return browserMetadata.isRtf(this.getVersion(request));
    }

    public boolean isSafari(HttpServletRequest request) {
        BrowserMetadata browserMetadata = this.getBrowserMetadata(request);
        return browserMetadata.isSafari();
    }

    public boolean isSun(HttpServletRequest request) {
        BrowserMetadata browserMetadata = this.getBrowserMetadata(request);
        return browserMetadata.isSun();
    }

    public boolean isWebKit(HttpServletRequest request) {
        BrowserMetadata browserMetadata = this.getBrowserMetadata(request);
        return browserMetadata.isWebKit();
    }

    public boolean isWindows(HttpServletRequest request) {
        BrowserMetadata browserMetadata = this.getBrowserMetadata(request);
        return browserMetadata.isWindows();
    }

    protected static String parseVersion(String userAgent, String[] leadings, char[] separators) {
        for (String leading : leadings) {
            int index = 0;
            while ((index = userAgent.indexOf(leading, index)) >= 0 && (index += leading.length()) + 2 <= userAgent.length()) {
                char c2;
                char c1 = userAgent.charAt(index);
                if (((c2 = userAgent.charAt(++index)) < '0' || c2 > '9') && c2 != '.') continue;
                for (char separator : separators) {
                    if (c1 != separator) {
                        continue;
                    }
                    int majorStart = index;
                    int majorEnd = index + 1;
                    for (int i = majorStart; i < userAgent.length(); ++i) {
                        char c = userAgent.charAt(i);
                        if (c >= '0' && c <= '9') continue;
                        majorEnd = i;
                        break;
                    }
                    String major = userAgent.substring(majorStart, majorEnd);
                    if (userAgent.charAt(majorEnd) != '.') {
                        return major;
                    }
                    int minorStart = majorEnd + 1;
                    int minorEnd = userAgent.length();
                    for (int i = minorStart; i < userAgent.length(); ++i) {
                        char c = userAgent.charAt(i);
                        if (c >= '0' && c <= '9') continue;
                        minorEnd = i;
                        break;
                    }
                    String minor = userAgent.substring(minorStart, minorEnd);
                    return major.concat(".").concat(minor);
                }
            }
        }
        return "";
    }

    protected String getAccept(HttpServletRequest request) {
        String accept = "";
        if (request == null) {
            return accept;
        }
        accept = String.valueOf(request.getAttribute("ACCEPT"));
        if (Validator.isNotNull((String)accept)) {
            return accept;
        }
        accept = request.getHeader("ACCEPT");
        accept = accept != null ? StringUtil.toLowerCase((String)accept) : "";
        request.setAttribute("ACCEPT", (Object)accept);
        return accept;
    }

    protected String getUserAgent(HttpServletRequest request) {
        if (request == null) {
            return "";
        }
        Object userAgentObject = request.getAttribute("User-Agent");
        if (userAgentObject != null) {
            return userAgentObject.toString();
        }
        String userAgent = request.getHeader("User-Agent");
        userAgent = userAgent != null ? StringUtil.toLowerCase((String)userAgent) : "";
        request.setAttribute("User-Agent", (Object)userAgent);
        return userAgent;
    }

    @Deprecated
    protected boolean isIe(String userAgent) {
        BrowserMetadata browserMetadata = new BrowserMetadata(userAgent);
        return browserMetadata.isIe();
    }
}

