/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.resiliency.mpi.portlet;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.Portlet;
import com.liferay.portal.kernel.portlet.ActionResult;
import com.liferay.portal.kernel.portlet.PortletContainer;
import com.liferay.portal.kernel.portlet.PortletContainerException;
import com.liferay.portal.kernel.resiliency.PortalResiliencyException;
import com.liferay.portal.kernel.resiliency.spi.SPI;
import com.liferay.portal.kernel.resiliency.spi.SPIRegistryUtil;
import com.liferay.portal.kernel.resiliency.spi.agent.SPIAgent;
import com.liferay.portal.util.PropsValues;
import java.util.Collections;
import java.util.List;
import javax.portlet.Event;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class PortalResiliencyPortletContainerWrapper
implements PortletContainer {
    private static final String[] _ACTION_REQUEST_ATTRIBUTE_NAMES = new String[]{"SPI_AGENT_LIFECYCLE", "SPI_AGENT_PORTLET"};
    private static final String[] _EVENT_REQUEST_ATTRIBUTE_NAMES = new String[]{"SPI_AGENT_EVENT", "SPI_AGENT_LAYOUT", "SPI_AGENT_LIFECYCLE", "SPI_AGENT_PORTLET"};
    private static final String[] _RENDER_REQUEST_ATTRIBUTE_NAMES = _ACTION_REQUEST_ATTRIBUTE_NAMES;
    private static final String[] _RESOURCE_REQUEST_ATTRIBUTE_NAMES = _ACTION_REQUEST_ATTRIBUTE_NAMES;
    private static final Log _log = LogFactoryUtil.getLog(PortalResiliencyPortletContainerWrapper.class);
    private final PortletContainer _portletContainer;

    public static PortletContainer createPortalResiliencyPortletContainerWrapper(PortletContainer portletContainer) {
        if (PropsValues.PORTAL_RESILIENCY_ENABLED) {
            portletContainer = new PortalResiliencyPortletContainerWrapper(portletContainer);
        }
        return portletContainer;
    }

    public PortalResiliencyPortletContainerWrapper(PortletContainer portletContainer) {
        this._portletContainer = portletContainer;
    }

    public void preparePortlet(HttpServletRequest request, Portlet portlet) throws PortletContainerException {
        this._portletContainer.preparePortlet(request, portlet);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ActionResult processAction(HttpServletRequest request, HttpServletResponse response, Portlet portlet) throws PortletContainerException {
        SPIAgent spiAgent = this.getSPIAgentForPortlet(portlet);
        if (spiAgent == null) {
            return this._portletContainer.processAction(request, response, portlet);
        }
        Object[] requestAttributeValues = this.captureRequestAttibutes(request, _ACTION_REQUEST_ATTRIBUTE_NAMES);
        request.setAttribute("SPI_AGENT_LIFECYCLE", (Object)SPIAgent.Lifecycle.ACTION);
        request.setAttribute("SPI_AGENT_PORTLET", (Object)portlet);
        try {
            spiAgent.service(request, response);
            ActionResult actionResult = (ActionResult)request.getAttribute("SPI_AGENT_ACTION_RESULT");
            return actionResult;
        }
        catch (PortalResiliencyException pre) {
            _log.error((Object)pre, (Throwable)pre);
            ActionResult actionResult = ActionResult.EMPTY_ACTION_RESULT;
            return actionResult;
        }
        finally {
            request.removeAttribute("SPI_AGENT_ACTION_RESULT");
            this.restoreRequestAttibutes(request, _ACTION_REQUEST_ATTRIBUTE_NAMES, requestAttributeValues);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Event> processEvent(HttpServletRequest request, HttpServletResponse response, Portlet portlet, Layout layout, Event event) throws PortletContainerException {
        SPIAgent spiAgent = this.getSPIAgentForPortlet(portlet);
        if (spiAgent == null) {
            return this._portletContainer.processEvent(request, response, portlet, layout, event);
        }
        Object[] requestAttributeValues = this.captureRequestAttibutes(request, _EVENT_REQUEST_ATTRIBUTE_NAMES);
        request.setAttribute("SPI_AGENT_EVENT", (Object)event);
        request.setAttribute("SPI_AGENT_LAYOUT", (Object)layout);
        request.setAttribute("SPI_AGENT_LIFECYCLE", (Object)SPIAgent.Lifecycle.EVENT);
        request.setAttribute("SPI_AGENT_PORTLET", (Object)portlet);
        try {
            spiAgent.service(request, response);
            List list = (List)request.getAttribute("SPI_AGENT_EVENT_RESULT");
            return list;
        }
        catch (PortalResiliencyException pre) {
            _log.error((Object)pre, (Throwable)pre);
            List<Event> list = Collections.emptyList();
            return list;
        }
        finally {
            request.removeAttribute("SPI_AGENT_EVENT_RESULT");
            this.restoreRequestAttibutes(request, _EVENT_REQUEST_ATTRIBUTE_NAMES, requestAttributeValues);
        }
    }

    public void processPublicRenderParameters(HttpServletRequest request, Layout layout) {
        this._portletContainer.processPublicRenderParameters(request, layout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void render(HttpServletRequest request, HttpServletResponse response, Portlet portlet) throws PortletContainerException {
        SPIAgent spiAgent = this.getSPIAgentForPortlet(portlet);
        if (spiAgent == null) {
            this._portletContainer.render(request, response, portlet);
            return;
        }
        Object[] requestAttributeValues = this.captureRequestAttibutes(request, _RENDER_REQUEST_ATTRIBUTE_NAMES);
        request.setAttribute("SPI_AGENT_LIFECYCLE", (Object)SPIAgent.Lifecycle.RENDER);
        request.setAttribute("SPI_AGENT_PORTLET", (Object)portlet);
        try {
            spiAgent.service(request, response);
        }
        catch (PortalResiliencyException pre) {
            _log.error((Object)pre, (Throwable)pre);
        }
        finally {
            this.restoreRequestAttibutes(request, _RENDER_REQUEST_ATTRIBUTE_NAMES, requestAttributeValues);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void serveResource(HttpServletRequest request, HttpServletResponse response, Portlet portlet) throws PortletContainerException {
        SPIAgent spiAgent = this.getSPIAgentForPortlet(portlet);
        if (spiAgent == null) {
            this._portletContainer.serveResource(request, response, portlet);
            return;
        }
        Object[] requestAttributeValues = this.captureRequestAttibutes(request, _RESOURCE_REQUEST_ATTRIBUTE_NAMES);
        request.setAttribute("SPI_AGENT_LIFECYCLE", (Object)SPIAgent.Lifecycle.RESOURCE);
        request.setAttribute("SPI_AGENT_PORTLET", (Object)portlet);
        try {
            spiAgent.service(request, response);
        }
        catch (PortalResiliencyException pre) {
            _log.error((Object)pre, (Throwable)pre);
        }
        finally {
            this.restoreRequestAttibutes(request, _RESOURCE_REQUEST_ATTRIBUTE_NAMES, requestAttributeValues);
        }
    }

    protected Object[] captureRequestAttibutes(HttpServletRequest request, String ... names) {
        Object[] values = new Object[names.length];
        for (int i = 0; i < names.length; ++i) {
            values[i] = request.getAttribute(names[i]);
        }
        return values;
    }

    protected SPIAgent getSPIAgentForPortlet(Portlet portlet) throws PortletContainerException {
        try {
            SPI spi = SPIRegistryUtil.getPortletSPI((String)portlet.getRootPortletId());
            if (spi == null) {
                return null;
            }
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Portlet " + portlet + " is registered to SPI " + spi));
            }
            return spi.getSPIAgent();
        }
        catch (Exception e) {
            throw new PortletContainerException((Throwable)e);
        }
    }

    protected void restoreRequestAttibutes(HttpServletRequest request, String[] names, Object[] values) {
        for (int i = 0; i < names.length; ++i) {
            String name = names[i];
            Object value = values[i];
            if (value == null) {
                request.removeAttribute(name);
                continue;
            }
            request.setAttribute(name, value);
        }
    }
}

