/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.util;

import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.source.formatter.checks.util.SourceUtil;
import com.liferay.source.formatter.util.FileUtil;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.List;

public class SourceFormatterUtil {
    public static List<String> filterFileNames(List<String> allFileNames, String[] excludes, String[] includes) {
        ArrayList<String> excludesRegex = new ArrayList<String>();
        ArrayList<String> includesRegex = new ArrayList<String>();
        for (String exclude : excludes) {
            if (exclude.contains("$")) continue;
            excludesRegex.add(SourceFormatterUtil._createRegex(exclude));
        }
        for (String include : includes) {
            if (include.contains("$")) continue;
            includesRegex.add(SourceFormatterUtil._createRegex(include));
        }
        ArrayList<String> fileNames = new ArrayList<String>();
        block2: for (String fileName : allFileNames) {
            String encodedFileName = SourceUtil.getAbsolutePath(fileName);
            encodedFileName = StringUtil.replace(encodedFileName, '\\', '/');
            for (String includeRegex : includesRegex) {
                if (!encodedFileName.matches(includeRegex)) continue;
                for (String excludeRegex : excludesRegex) {
                    if (!encodedFileName.matches(excludeRegex)) continue;
                    continue block2;
                }
                fileNames.add(fileName);
                continue block2;
            }
        }
        return fileNames;
    }

    public static List<String> filterRecentChangesFileNames(String baseDir, List<String> recentChangesFileNames, String[] excludes, String[] includes, boolean includeSubrepositories) throws Exception {
        if (ArrayUtil.isEmpty(includes)) {
            return new ArrayList<String>();
        }
        ArrayList<PathMatcher> excludeDirPathMatchers = new ArrayList<PathMatcher>();
        ArrayList<PathMatcher> excludeFilePathMatchers = new ArrayList<PathMatcher>();
        ArrayList<PathMatcher> includeFilePathMatchers = new ArrayList<PathMatcher>();
        FileSystem fileSystem = FileSystems.getDefault();
        for (String exclude : excludes) {
            if (!exclude.startsWith("**/")) {
                exclude = "**/" + exclude;
            }
            if (exclude.endsWith("/**")) {
                exclude = exclude.substring(0, exclude.length() - 3);
                excludeDirPathMatchers.add(fileSystem.getPathMatcher("glob:" + exclude));
                continue;
            }
            excludeFilePathMatchers.add(fileSystem.getPathMatcher("glob:" + exclude));
        }
        for (String include : includes) {
            includeFilePathMatchers.add(fileSystem.getPathMatcher("glob:" + include));
        }
        return SourceFormatterUtil._filterRecentChangesFileNames(baseDir, recentChangesFileNames, excludeDirPathMatchers, excludeFilePathMatchers, includeFilePathMatchers);
    }

    public static File getFile(String baseDir, String fileName, int level) {
        for (int i = 0; i < level; ++i) {
            File file = new File(baseDir + fileName);
            if (file.exists()) {
                return file;
            }
            fileName = "../" + fileName;
        }
        return null;
    }

    public static void printError(String fileName, File file) {
        SourceFormatterUtil.printError(fileName, file.toString());
    }

    public static void printError(String fileName, String message) {
        System.out.println(message);
    }

    public static List<String> scanForFiles(String baseDir, String[] excludes, String[] includes, boolean includeSubrepositories) throws Exception {
        if (ArrayUtil.isEmpty(includes)) {
            return new ArrayList<String>();
        }
        ArrayList<PathMatcher> excludeDirPathMatchers = new ArrayList<PathMatcher>();
        ArrayList<PathMatcher> excludeFilePathMatchers = new ArrayList<PathMatcher>();
        ArrayList<PathMatcher> includeFilePathMatchers = new ArrayList<PathMatcher>();
        FileSystem fileSystem = FileSystems.getDefault();
        for (String exclude : excludes) {
            if (!exclude.startsWith("**/")) {
                exclude = "**/" + exclude;
            }
            if (exclude.endsWith("/**")) {
                exclude = exclude.substring(0, exclude.length() - 3);
                excludeDirPathMatchers.add(fileSystem.getPathMatcher("glob:" + exclude));
                continue;
            }
            excludeFilePathMatchers.add(fileSystem.getPathMatcher("glob:" + exclude));
        }
        for (String include : includes) {
            includeFilePathMatchers.add(fileSystem.getPathMatcher("glob:" + include));
        }
        return SourceFormatterUtil._scanForFiles(baseDir, excludeDirPathMatchers, excludeFilePathMatchers, includeFilePathMatchers, includeSubrepositories);
    }

    private static String _createRegex(String s) {
        if (!s.startsWith("**/")) {
            s = "**/" + s;
        }
        s = StringUtil.replace(s, '.', "\\.");
        StringBundler sb = new StringBundler();
        for (int i = 0; i < s.length(); ++i) {
            char c1 = s.charAt(i);
            if (c1 != '*') {
                sb.append(c1);
                continue;
            }
            if (i == s.length() - 1) {
                sb.append("[^/]*");
                continue;
            }
            char c2 = s.charAt(i + 1);
            if (c2 == '*') {
                sb.append(".*");
                ++i;
                continue;
            }
            sb.append("[^/]*");
        }
        return sb.toString();
    }

    private static List<String> _filterRecentChangesFileNames(String baseDir, List<String> recentChangesFileNames, List<PathMatcher> excludeDirPathMatchers, List<PathMatcher> excludeFilePathMatchers, List<PathMatcher> includeFilePathMatchers) throws Exception {
        ArrayList<String> fileNames = new ArrayList<String>();
        block0: for (String fileName : recentChangesFileNames) {
            fileName = baseDir.concat(fileName);
            File file = new File(fileName);
            File canonicalFile = file.getCanonicalFile();
            Path filePath = canonicalFile.toPath();
            for (PathMatcher pathMatcher : excludeFilePathMatchers) {
                if (!pathMatcher.matches(filePath)) continue;
                continue block0;
            }
            File dir = file.getParentFile();
            do {
                File canonicalDir = dir.getCanonicalFile();
                Path dirPath = canonicalDir.toPath();
                for (PathMatcher pathMatcher : excludeDirPathMatchers) {
                    if (!pathMatcher.matches(dirPath)) continue;
                    continue block0;
                }
                if (Files.exists(dirPath.resolve("source_formatter.ignore"), new LinkOption[0])) continue block0;
            } while ((dir = dir.getParentFile()) != null);
            for (PathMatcher pathMatcher : includeFilePathMatchers) {
                if (!pathMatcher.matches(filePath)) continue;
                fileName = StringUtil.replace(fileName, '/', '\\');
                fileNames.add(fileName);
                continue block0;
            }
        }
        return fileNames;
    }

    private static Path _getCanonicalPath(Path path) {
        try {
            File file = path.toFile();
            File canonicalFile = file.getCanonicalFile();
            return canonicalFile.toPath();
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    private static List<String> _scanForFiles(String baseDir, final List<PathMatcher> excludeDirPathMatchers, final List<PathMatcher> excludeFilePathMatchers, final List<PathMatcher> includeFilePathMatchers, final boolean includeSubrepositories) throws Exception {
        final ArrayList<String> fileNames = new ArrayList<String>();
        Files.walkFileTree(Paths.get(baseDir, new String[0]), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult preVisitDirectory(Path dirPath, BasicFileAttributes basicFileAttributes) {
                Path gitRepoPath;
                if (Files.exists(dirPath.resolve("source_formatter.ignore"), new LinkOption[0])) {
                    return FileVisitResult.SKIP_SUBTREE;
                }
                if (!includeSubrepositories && Files.exists(gitRepoPath = dirPath.resolve(".gitrepo"), new LinkOption[0])) {
                    try {
                        String content = FileUtil.read(gitRepoPath.toFile());
                        if (content.contains("mode = pull")) {
                            return FileVisitResult.SKIP_SUBTREE;
                        }
                    }
                    catch (Exception content) {
                        // empty catch block
                    }
                }
                dirPath = SourceFormatterUtil._getCanonicalPath(dirPath);
                for (PathMatcher pathMatcher : excludeDirPathMatchers) {
                    if (!pathMatcher.matches(dirPath)) continue;
                    return FileVisitResult.SKIP_SUBTREE;
                }
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFile(Path filePath, BasicFileAttributes basicFileAttributes) {
                Path canonicalPath = SourceFormatterUtil._getCanonicalPath(filePath);
                for (PathMatcher pathMatcher : excludeFilePathMatchers) {
                    if (!pathMatcher.matches(canonicalPath)) continue;
                    return FileVisitResult.CONTINUE;
                }
                for (PathMatcher pathMatcher : includeFilePathMatchers) {
                    if (!pathMatcher.matches(canonicalPath)) continue;
                    fileNames.add(filePath.toString());
                    return FileVisitResult.CONTINUE;
                }
                return FileVisitResult.CONTINUE;
            }
        });
        return fileNames;
    }
}

