/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checks;

import com.liferay.portal.kernel.util.ReleaseInfo;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.source.formatter.checks.BaseFileCheck;
import com.liferay.source.formatter.checks.comparator.ElementComparator;
import com.liferay.source.formatter.checks.util.SourceUtil;
import java.util.List;
import org.dom4j.Document;
import org.dom4j.Element;

public class XMLFriendlyURLRoutesFileCheck
extends BaseFileCheck {
    @Override
    protected String doProcess(String fileName, String absolutePath, String content) throws Exception {
        if (fileName.endsWith("routes.xml")) {
            content = this._formatFriendlyURLRoutesXML(fileName, content);
        }
        return content;
    }

    private String _formatFriendlyURLRoutesXML(String fileName, String content) throws Exception {
        Document document = SourceUtil.readXML(content);
        Element rootElement = document.getRootElement();
        List routeElements = rootElement.elements("route");
        ElementComparator elementComparator = new ElementComparator();
        for (Element routeElement : routeElements) {
            this.checkElementOrder(fileName, routeElement, "ignored-parameter", null, elementComparator);
            this.checkElementOrder(fileName, routeElement, "implicit-parameter", null, elementComparator);
            this.checkElementOrder(fileName, routeElement, "overridden-parameter", null, elementComparator);
        }
        int pos = content.indexOf("<routes>\n");
        if (pos == -1) {
            return content;
        }
        StringBundler sb = new StringBundler(9);
        String mainReleaseVersion = this._getMainReleaseVersion();
        sb.append("<?xml version=\"1.0\"?>\n");
        sb.append("<!DOCTYPE routes PUBLIC \"-//Liferay//DTD Friendly URL ");
        sb.append("Routes ");
        sb.append(mainReleaseVersion);
        sb.append("//EN\" \"http://www.liferay.com/dtd/");
        sb.append("liferay-friendly-url-routes_");
        sb.append(StringUtil.replace(mainReleaseVersion, '.', '_'));
        sb.append(".dtd\">\n\n");
        sb.append(content.substring(pos));
        return sb.toString();
    }

    private String _getMainReleaseVersion() {
        String releaseVersion = ReleaseInfo.getVersion();
        int pos = releaseVersion.lastIndexOf(46);
        return releaseVersion.substring(0, pos) + ".0";
    }
}

