/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checks;

import com.liferay.portal.tools.ToolsUtil;
import com.liferay.source.formatter.checks.BaseFileCheck;
import com.liferay.source.formatter.checks.util.JavaSourceUtil;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JavaUpgradeClassCheck
extends BaseFileCheck {
    private static final String _UPGRADE_SERVICE_UTIL_EXCLUDES = "upgrade.service.util.excludes";
    private final Pattern _componentAnnotationPattern = Pattern.compile("@Component(\n|\\([\\s\\S]*?\\)\n)");
    private final Pattern _registryRegisterPattern = Pattern.compile("registry\\.register\\((.*?)\\);\n", 32);
    private final Pattern _upgradeClassNamePattern = Pattern.compile("new .*?(\\w+)\\(", 32);

    @Override
    public boolean isPortalCheck() {
        return true;
    }

    @Override
    protected String doProcess(String fileName, String absolutePath, String content) {
        if (!fileName.contains("/upgrade/")) {
            return content;
        }
        this._checkLocaleUtil(fileName, content);
        this._checkServiceUtil(fileName, absolutePath, content);
        this._checkTimestamp(fileName, content);
        if (!fileName.endsWith("Upgrade.java")) {
            return content;
        }
        this._checkAnnotation(fileName, content);
        this._checkRegistryVersion(fileName, content);
        return content;
    }

    private void _checkAnnotation(String fileName, String content) {
        if (!content.contains("implements UpgradeStepRegistrator")) {
            return;
        }
        Matcher matcher = this._componentAnnotationPattern.matcher(content);
        if (!matcher.find()) {
            return;
        }
        String componentAnnotation = matcher.group();
        if (!componentAnnotation.contains("service =")) {
            this.addMessage(fileName, "@Component requires 'service' parameter");
        }
    }

    private void _checkLocaleUtil(String fileName, String content) {
        int pos = content.indexOf("LocaleUtil.getDefault()");
        if (pos != -1) {
            this.addMessage(fileName, "Use UpgradeProcessUtil.getDefaultLanguageId(companyId) instead of LocaleUtil.getDefault()", this.getLineCount(content, pos));
        }
    }

    private void _checkRegistryVersion(String fileName, String content) {
        Matcher matcher1 = this._registryRegisterPattern.matcher(content);
        block0: while (matcher1.find()) {
            String parameter;
            Matcher matcher2;
            List<String> parametersList;
            if (ToolsUtil.isInsideQuotes(content, matcher1.start()) || (parametersList = JavaSourceUtil.getParameterList(content.substring(matcher1.start()))).size() <= 4) continue;
            String previousUpgradeClassName = null;
            for (int i = 3; i < parametersList.size() && (matcher2 = this._upgradeClassNamePattern.matcher(parameter = parametersList.get(i))).find(); ++i) {
                String upgradeClassName = matcher2.group(1);
                if (previousUpgradeClassName != null && previousUpgradeClassName.compareTo(upgradeClassName) > 0) {
                    this.addMessage(fileName, "Break up Upgrade classes with a minor version increment or order alphabetically, see LPS-65685", this.getLineCount(content, matcher1.start()));
                    continue block0;
                }
                previousUpgradeClassName = upgradeClassName;
            }
        }
    }

    private void _checkServiceUtil(String fileName, String absolutePath, String content) {
        int pos;
        if (!this.isExcludedPath(_UPGRADE_SERVICE_UTIL_EXCLUDES, absolutePath) && fileName.contains("/portal/upgrade/") && !fileName.contains("/test/") && !fileName.contains("/testIntegration/") && (pos = content.indexOf("ServiceUtil.")) != -1) {
            this.addMessage(fileName, "Do not use *ServiceUtil classes in upgrade classes, see LPS-34911", this.getLineCount(content, pos));
        }
    }

    private void _checkTimestamp(String fileName, String content) {
        int pos = content.indexOf("rs.getDate(");
        if (pos != -1) {
            this.addMessage(fileName, "Use rs.getTimestamp instead of rs.getDate", this.getLineCount(content, pos));
        }
    }
}

