/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checks;

import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.source.formatter.checks.BaseFileCheck;
import com.liferay.source.formatter.checks.util.JavaSourceUtil;

public class JavaPackagePathCheck
extends BaseFileCheck {
    @Override
    protected String doProcess(String fileName, String absolutePath, String content) {
        this._checkPackagePath(fileName, content);
        return content;
    }

    private void _checkPackagePath(String fileName, String content) {
        String packagePath = JavaSourceUtil.getPackagePath(content);
        if (Validator.isNull(packagePath)) {
            this.addMessage(fileName, "Missing package");
            return;
        }
        int pos = fileName.lastIndexOf(47);
        String filePath = StringUtil.replace(fileName.substring(0, pos), '/', '.');
        if (!filePath.endsWith(packagePath)) {
            this.addMessage(fileName, "The declared package '" + packagePath + "' does not match the expected package", "package.markdown");
            return;
        }
        if (packagePath.matches(".*\\.internal\\.([\\w.]+\\.)?impl")) {
            this.addMessage(fileName, "Do not use 'impl' inside 'internal', see LPS-70113");
        }
    }
}

