/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checks;

import com.liferay.source.formatter.checks.BaseFileCheck;
import com.liferay.source.formatter.checks.util.JavaSourceUtil;

public class JavaModuleServiceProxyFactoryCheck
extends BaseFileCheck {
    @Override
    public boolean isModulesCheck() {
        return true;
    }

    @Override
    protected String doProcess(String fileName, String absolutePath, String content) {
        if (fileName.endsWith("JavaModuleServiceProxyFactoryCheck.java")) {
            return content;
        }
        String packagePath = JavaSourceUtil.getPackagePath(content);
        if (!packagePath.startsWith("com.liferay")) {
            return content;
        }
        if (content.contains("ServiceProxyFactory.newServiceTrackedInstance(")) {
            this.addMessage(fileName, "Do not use ServiceProxyFactory.newServiceTrackedInstance in modules, see LPS-57358");
        }
        return content;
    }
}

