/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checks;

import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.source.formatter.checks.BaseFileCheck;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CSSEmptyLinesCheck
extends BaseFileCheck {
    private final Pattern _emptyLineAfterOpenCurlyBrace = Pattern.compile("\\{\n\n");
    private final Pattern _emptyLineBeforeCloseCurlyBrace = Pattern.compile("\n\n\t*\\}");

    @Override
    protected String doProcess(String fileName, String absolutePath, String content) {
        return this._fixEmptyLines(content);
    }

    private String _fixEmptyLines(String content) {
        Matcher matcher = this._emptyLineAfterOpenCurlyBrace.matcher(content);
        if (matcher.find()) {
            return StringUtil.replaceFirst(content, "\n\n", "\n", matcher.start());
        }
        matcher = this._emptyLineBeforeCloseCurlyBrace.matcher(content);
        if (matcher.find()) {
            return StringUtil.replaceFirst(content, "\n\n", "\n", matcher.start());
        }
        return content;
    }
}

