/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.portlet;

import aQute.bnd.annotation.ProviderType;
import com.liferay.portal.kernel.portlet.PortletBag;
import com.liferay.portal.kernel.portlet.PortletBagPool;
import com.liferay.portal.kernel.security.pacl.permission.PortalRuntimePermission;
import com.liferay.portal.kernel.util.AutoResetThreadLocal;
import com.liferay.portal.kernel.util.ClassLoaderPool;
import javax.servlet.ServletContext;

@ProviderType
public class PortletClassLoaderUtil {
    private static final ThreadLocal<String> _servletContextName = new AutoResetThreadLocal<String>(PortletClassLoaderUtil.class + "._servletContextName");

    public static ClassLoader getClassLoader() {
        return ClassLoaderPool.getClassLoader(PortletClassLoaderUtil.getServletContextName());
    }

    public static ClassLoader getClassLoader(String portletId) {
        PortalRuntimePermission.checkGetClassLoader(portletId);
        PortletBag portletBag = PortletBagPool.get(portletId);
        if (portletBag == null) {
            return null;
        }
        ServletContext servletContext = portletBag.getServletContext();
        return servletContext.getClassLoader();
    }

    public static String getServletContextName() {
        String servletContextName = _servletContextName.get();
        if (servletContextName == null) {
            throw new IllegalStateException("No servlet context name specified");
        }
        return servletContextName;
    }

    public static void setServletContextName(String servletContextName) {
        PortalRuntimePermission.checkSetBeanProperty(PortletClassLoaderUtil.class);
        _servletContextName.set(servletContextName);
    }
}

