/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.io;

import com.liferay.portal.kernel.io.Deserializer;
import com.liferay.portal.kernel.io.Serializer;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.nio.ByteBuffer;

public class SerializableObjectWrapper
implements Externalizable {
    private static final Log _log = LogFactoryUtil.getLog(SerializableObjectWrapper.class);
    private Serializable _serializable;

    public static <T> T unwrap(Object object) {
        if (!(object instanceof SerializableObjectWrapper)) {
            return (T)object;
        }
        SerializableObjectWrapper serializableWrapper = (SerializableObjectWrapper)object;
        return (T)serializableWrapper._serializable;
    }

    public SerializableObjectWrapper() {
    }

    public SerializableObjectWrapper(Serializable serializable) {
        this._serializable = serializable;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof SerializableObjectWrapper)) {
            return false;
        }
        SerializableObjectWrapper serializableWrapper = (SerializableObjectWrapper)object;
        return this._serializable.equals(serializableWrapper._serializable);
    }

    public int hashCode() {
        return this._serializable.hashCode();
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException {
        byte[] data = new byte[objectInput.readInt()];
        objectInput.readFully(data);
        Deserializer deserializer = new Deserializer(ByteBuffer.wrap(data));
        try {
            this._serializable = deserializer.readObject();
        }
        catch (ClassNotFoundException cnfe) {
            _log.error("Unable to deserialize object", cnfe);
        }
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        Serializer serializer = new Serializer();
        serializer.writeObject(this._serializable);
        ByteBuffer byteBuffer = serializer.toByteBuffer();
        objectOutput.writeInt(byteBuffer.remaining());
        objectOutput.write(byteBuffer.array(), byteBuffer.position(), byteBuffer.remaining());
    }
}

