/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.asset.kernel.model;

import com.liferay.asset.kernel.model.AssetEntry;
import com.liferay.asset.kernel.model.AssetRenderer;
import com.liferay.asset.kernel.model.AssetRendererFactory;
import com.liferay.asset.kernel.model.ClassType;
import com.liferay.asset.kernel.model.ClassTypeField;
import com.liferay.asset.kernel.model.ClassTypeReader;
import com.liferay.asset.kernel.model.NullClassTypeReader;
import com.liferay.asset.kernel.service.AssetEntryLocalServiceUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Portlet;
import com.liferay.portal.kernel.portlet.LiferayPortletRequest;
import com.liferay.portal.kernel.portlet.LiferayPortletResponse;
import com.liferay.portal.kernel.portlet.PortletBag;
import com.liferay.portal.kernel.portlet.PortletBagPool;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.ResourceActionsUtil;
import com.liferay.portal.kernel.service.PortletLocalServiceUtil;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.ResourceBundleUtil;
import com.liferay.portal.kernel.util.Tuple;
import com.liferay.portal.kernel.util.Validator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import javax.portlet.PortletRequest;
import javax.portlet.PortletURL;
import javax.portlet.WindowState;

public abstract class BaseAssetRendererFactory<T>
implements AssetRendererFactory<T> {
    private static final boolean _PERMISSION = true;
    private boolean _categorizable = true;
    private String _className;
    private boolean _linkable;
    private String _portletId;
    private boolean _searchable;
    private boolean _selectable = true;
    private boolean _supportsClassTypes;

    @Override
    public AssetEntry getAssetEntry(long assetEntryId) throws PortalException {
        return AssetEntryLocalServiceUtil.getEntry(assetEntryId);
    }

    @Override
    public AssetEntry getAssetEntry(String className, long classPK) throws PortalException {
        return AssetEntryLocalServiceUtil.getEntry(className, classPK);
    }

    @Override
    public AssetRenderer<T> getAssetRenderer(long classPK) throws PortalException {
        return this.getAssetRenderer((T)classPK, 1);
    }

    @Override
    public AssetRenderer<T> getAssetRenderer(long groupId, String urlTitle) throws PortalException {
        return null;
    }

    @Override
    public AssetRenderer<T> getAssetRenderer(T entry, int type) throws PortalException {
        return null;
    }

    @Override
    public String getClassName() {
        return this._className;
    }

    @Override
    public long getClassNameId() {
        return PortalUtil.getClassNameId(this.getClassName());
    }

    @Override
    @Deprecated
    public Tuple getClassTypeFieldName(long classTypeId, String fieldName, Locale locale) throws Exception {
        ClassTypeReader classTypeReader = this.getClassTypeReader();
        ClassType classType = classTypeReader.getClassType(classTypeId, locale);
        List<ClassTypeField> classTypeFields = classType.getClassTypeFields();
        for (ClassTypeField classTypeField : classTypeFields) {
            if (!fieldName.equals(classTypeField.getName())) continue;
            return this.toTuple(classTypeField);
        }
        return null;
    }

    @Override
    @Deprecated
    public List<Tuple> getClassTypeFieldNames(long classTypeId, Locale locale, int start, int end) throws Exception {
        ClassTypeReader classTypeReader = this.getClassTypeReader();
        ClassType classType = classTypeReader.getClassType(classTypeId, locale);
        List<ClassTypeField> classTypeFields = classType.getClassTypeFields(start, end);
        ArrayList<Tuple> tuples = new ArrayList<Tuple>(classTypeFields.size());
        for (ClassTypeField classTypeField : classTypeFields) {
            tuples.add(this.toTuple(classTypeField));
        }
        return tuples;
    }

    @Override
    @Deprecated
    public int getClassTypeFieldNamesCount(long classTypeId, Locale locale) throws Exception {
        ClassTypeReader classTypeReader = this.getClassTypeReader();
        ClassType classType = classTypeReader.getClassType(classTypeId, locale);
        return classType.getClassTypeFieldsCount();
    }

    @Override
    public ClassTypeReader getClassTypeReader() {
        return new NullClassTypeReader();
    }

    @Override
    @Deprecated
    public Map<Long, String> getClassTypes(long[] groupIds, Locale locale) throws Exception {
        ClassTypeReader classTypeReader = this.getClassTypeReader();
        List<ClassType> classTypes = classTypeReader.getAvailableClassTypes(groupIds, locale);
        HashMap<Long, String> classTypesMap = new HashMap<Long, String>();
        for (ClassType classType : classTypes) {
            classTypesMap.put(classType.getClassTypeId(), classType.getName());
        }
        return classTypesMap;
    }

    @Override
    public String getIconCssClass() {
        return null;
    }

    @Override
    @Deprecated
    public String getIconPath(PortletRequest portletRequest) {
        return "";
    }

    @Override
    public String getPortletId() {
        return this._portletId;
    }

    @Override
    public String getSubtypeTitle(Locale locale) {
        return LanguageUtil.get(locale, "subtype");
    }

    @Override
    public String getTypeName(Locale locale) {
        PortletBag portletBag;
        ResourceBundle resourceBundle;
        String modelResourceNamePrefix = ResourceActionsUtil.getModelResourceNamePrefix();
        String key = modelResourceNamePrefix.concat(this.getClassName());
        String value = LanguageUtil.get(locale, key, null);
        if (value == null && (resourceBundle = (portletBag = PortletBagPool.get(this.getPortletId())).getResourceBundle(locale)) != null) {
            value = ResourceBundleUtil.getString(resourceBundle, key);
        }
        if (value == null) {
            value = this.getClassName();
        }
        return value;
    }

    @Override
    @Deprecated
    public String getTypeName(Locale locale, boolean hasSubtypes) {
        return this.getTypeName(locale);
    }

    @Override
    public String getTypeName(Locale locale, long subtypeId) {
        return this.getTypeName(locale);
    }

    @Override
    @Deprecated
    public PortletURL getURLAdd(LiferayPortletRequest liferayPortletRequest, LiferayPortletResponse liferayPortletResponse) throws PortalException {
        return this.getURLAdd(liferayPortletRequest, liferayPortletResponse, 0L);
    }

    @Override
    public PortletURL getURLAdd(LiferayPortletRequest liferayPortletRequest, LiferayPortletResponse liferayPortletResponse, long classTypeId) throws PortalException {
        return null;
    }

    @Override
    public PortletURL getURLView(LiferayPortletResponse liferayPortletResponse, WindowState windowState) throws PortalException {
        return null;
    }

    @Override
    public boolean hasAddPermission(PermissionChecker permissionChecker, long groupId, long classTypeId) throws Exception {
        return false;
    }

    @Override
    @Deprecated
    public boolean hasClassTypeFieldNames(long classTypeId, Locale locale) throws Exception {
        ClassTypeReader classTypeReader = this.getClassTypeReader();
        ClassType classType = classTypeReader.getClassType(classTypeId, locale);
        return classType.getClassTypeFieldsCount() > 0;
    }

    @Override
    public boolean hasPermission(PermissionChecker permissionChecker, long classPK, String actionId) throws Exception {
        return true;
    }

    @Override
    public boolean isActive(long companyId) {
        if (Validator.isNull(this.getPortletId())) {
            return true;
        }
        Portlet portlet = PortletLocalServiceUtil.getPortletById(companyId, this.getPortletId());
        if (portlet == null) {
            portlet = PortletLocalServiceUtil.getPortletById(this.getPortletId());
        }
        if (portlet == null) {
            return false;
        }
        return portlet.isActive();
    }

    @Override
    public boolean isCategorizable() {
        return this._categorizable;
    }

    @Override
    public boolean isLinkable() {
        return this._linkable;
    }

    @Override
    public boolean isSearchable() {
        return this._searchable;
    }

    @Override
    public boolean isSelectable() {
        return this._selectable;
    }

    @Override
    public boolean isSupportsClassTypes() {
        return this._supportsClassTypes;
    }

    @Override
    public void setClassName(String className) {
        this._className = className;
    }

    @Override
    public void setPortletId(String portletId) {
        this._portletId = portletId;
    }

    protected long getControlPanelPlid(ThemeDisplay themeDisplay) throws PortalException {
        return PortalUtil.getControlPanelPlid(themeDisplay.getCompanyId());
    }

    protected Group getGroup(LiferayPortletRequest liferayPortletRequest) {
        return (Group)liferayPortletRequest.getAttribute("ASSET_RENDERER_FACTORY_GROUP");
    }

    protected void setCategorizable(boolean categorizable) {
        this._categorizable = categorizable;
    }

    protected void setLinkable(boolean linkable) {
        this._linkable = linkable;
    }

    protected void setSearchable(boolean searchable) {
        this._searchable = searchable;
    }

    protected void setSelectable(boolean selectable) {
        this._selectable = selectable;
    }

    protected void setSupportsClassTypes(boolean supportsClassTypes) {
        this._supportsClassTypes = supportsClassTypes;
    }

    protected Tuple toTuple(ClassTypeField classTypeField) {
        return new Tuple(classTypeField.getLabel(), classTypeField.getName(), classTypeField.getType(), classTypeField.getClassTypeId());
    }
}

